-------------------------------------------------------------------------------
-- ߥ졼ѥ֥åRAM
-- 
-- Υ⥸塼ѤXilinxǥѥ뤹
-- ץߥƥ֤BlockRAM롥
-- 
-- Copyright Takefumi MIYOSHI (c) 2008 All rights reserved.
--
-- $Id: blockram.vhd 4364 2008-09-18 01:59:40Z miyo $
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity BlockRAM is
  generic (
    WIDTH : integer := 8;
    DEPTH : integer := 9);
  port (
    clka : in std_logic;
    dina : in std_logic_vector(WIDTH-1 downto 0);
    addra : in std_logic_vector(DEPTH-1 downto 0);
    wea : in std_logic_vector(0 downto 0);
    clkb : in std_logic;
    addrb : in std_logic_vector(DEPTH-1 downto 0);
    doutb : out std_logic_vector(WIDTH-1 downto 0)
    );
end BlockRAM;

architecture syn of BlockRAM is

  type ram_type is array (2**DEPTH-1 downto 0) of std_logic_vector (WIDTH-1 downto 0);
  signal RAM: ram_type := (others => "00000000");

  signal outb : std_logic_vector(WIDTH -1 downto 0);

begin

  doutb <= outb;
  
  process (clka)
  begin
    if clka'event and clka = '1' then
        if wea(0) = '1' then
          RAM(conv_integer(addra)) <= dina;
        end if;
    end if;
  end process;

  process (clkb)
  begin
    if clkb'event and clkb = '1' then
      outb <= RAM(conv_integer(addrb));
    end if;
  end process;
end syn;
