/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.StateSignal;
import net.wasamon.javarock.model.vhdl.ArrayRef;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLFieldAccess;
import net.wasamon.javarock.model.vhdl.VHDLFieldSignal;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLLiteral;
import net.wasamon.javarock.model.vhdl.VHDLNonBlockAssignStmt;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.type.StdLogic;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;

public class VHDLArrayAccess
extends VHDLExpr {
    final VHDLProcess process;
    final VHDLExpr indexed;
    final VHDLExpr expr;
    final VHDLExpr.TERM term;
    final VHDLScopeIface scope;

    public VHDLArrayAccess(VHDLProcess process, VHDLScopeIface scope, VHDLExpr indexed, VHDLExpr expr, VHDLExpr.TERM t) {
        this.process = process;
        this.indexed = indexed;
        this.scope = scope;
        this.expr = expr;
        VHDLArrayIndexOperation stmt = new VHDLArrayIndexOperation();
        scope.add(stmt);
        if (indexed instanceof VHDLIdent && ((VHDLIdent)indexed).var instanceof VHDLFieldSignal) {
            if (t == VHDLExpr.TERM.LHS) {
                ((VHDLFieldSignal)((Object)((VHDLIdent)indexed).var)).addWriter(scope, stmt);
            } else {
                ((VHDLFieldSignal)((Object)((VHDLIdent)indexed).var)).addReader(scope, stmt);
            }
        }
        this.term = t;
    }

    @Override
    public void connect() {
    }

    @Override
    public void link() {
    }

    public VHDLIdent ident(VHDLExpr.TERM t) {
        if (this.indexed instanceof VHDLFieldAccess) {
            return ((VHDLFieldAccess)this.indexed).getIdent(t);
        }
        return (VHDLIdent)this.indexed;
    }

    public VHDLIdent getIdent() {
        String base = this.indexed instanceof VHDLFieldAccess ? ((VHDLFieldAccess)this.indexed).name : this.indexed.getExprAsStr();
        if (this.term == VHDLExpr.TERM.LHS) {
            return this.scope.getIdent(String.format("%s_wdata", base), VHDLExpr.TERM.LHS);
        }
        return this.scope.getIdent(String.format("%s_rdata", base), VHDLExpr.TERM.RHS);
    }

    public String getReadSignal() {
        System.out.printf("VHDLArrayAccess:getReadSignal: TO => %s\n", this.indexed.getClass().getName());
        String base = this.indexed instanceof VHDLFieldAccess ? ((VHDLFieldAccess)this.indexed).name : this.indexed.getExprAsStr();
        return this.scope.getIdent(String.format("%s_rdata", base), VHDLExpr.TERM.RHS).getExprAsStr();
    }

    @Override
    public String getExprAsStr() {
        String base = this.indexed instanceof VHDLFieldAccess ? ((VHDLFieldAccess)this.indexed).name : this.indexed.getExprAsStr();
        if (this.term == VHDLExpr.TERM.LHS) {
            return String.format("%s_wdata", base);
        }
        return String.format("%s_rdata", base);
    }

    @Override
    public JavaRockType getType() {
        return this.ident(this.term).getType();
    }

    private String getBaseString() {
        if (this.indexed instanceof VHDLFieldAccess) {
            return ((VHDLFieldAccess)this.indexed).name;
        }
        return this.indexed.getExprAsStr();
    }

    @Override
    public void addSensitivityList(VHDLProcess p) {
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        ArrayList<VHDLIdent> l0 = this.indexed.getSrcIdent();
        if (l0 != null) {
            list.addAll(l0);
        }
        if (this.indexed instanceof VHDLIdent) {
            list.add((VHDLIdent)this.indexed);
        }
        if ((l0 = this.expr.getSrcIdent()) != null) {
            list.addAll(l0);
        }
        if (this.expr instanceof VHDLIdent) {
            list.add((VHDLIdent)this.expr);
        }
        return list;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        ArrayList<VHDLIdent> l0 = this.indexed.getDestIdent();
        if (l0 != null) {
            list.addAll(l0);
        }
        if (this.indexed instanceof VHDLIdent) {
            list.add((VHDLIdent)this.indexed);
        }
        if ((l0 = this.expr.getDestIdent()) != null) {
            list.addAll(l0);
        }
        return list;
    }

    @Override
    public boolean hasFixedBitWidth() {
        JavaRockType t = this.getType();
        if (!(t instanceof VHDLArrayType)) {
            if (t instanceof StdLogicVector) {
                return true;
            }
            if (t instanceof ArrayRef) {
                if (((ArrayRef)t).type.base instanceof StdLogicVector) {
                    return true;
                }
                throw new RuntimeException("VHDLArrayAccess::hasFixedBitWidth: VHDLArrayAccess does not support such type: " + this.getType());
            }
            throw new RuntimeException("VHDLArrayAccess::hasFixedBitWidth: VHDLArrayAccess does not support such type: " + this.getType());
        }
        return !(((VHDLArrayType)t).base instanceof StdLogic);
    }

    class VHDLArrayIndexOperation
    extends VHDLStatement {
        final StateSignal STATE_SIG;

        public VHDLArrayIndexOperation() {
            this.STATE_SIG = new StateSignal(String.format("array_index_operation_state_counter_%s", VHDLArrayAccess.this.process.getScopeID()));
            VHDLSignal sig = VHDLArrayAccess.this.process.module.addSignal(this.STATE_SIG.value(), VHDLTypeBuilder.getStdLogicVector("2", "0"), null, true, false);
            VHDLArrayAccess.this.process.addResetStmt(sig);
        }

        @Override
        public void connect() {
        }

        @Override
        public void link() {
            super.link();
            if (VHDLArrayAccess.this.indexed instanceof VHDLFieldAccess) {
                String base = ((VHDLFieldAccess)VHDLArrayAccess.this.indexed).name;
                if (VHDLArrayAccess.this.term == VHDLExpr.TERM.LHS) {
                    new VHDLNonBlockAssignStmt(VHDLArrayAccess.this.process, VHDLArrayAccess.this.scope, VHDLArrayAccess.this.scope.getIdent(String.format("%s_waddr", base), VHDLExpr.TERM.LHS), VHDLArrayAccess.this.expr, this);
                    new VHDLNonBlockAssignStmt(VHDLArrayAccess.this.process, VHDLArrayAccess.this.scope, VHDLArrayAccess.this.scope.getIdent(String.format("%s_we", base), VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLLiteral(1), this);
                } else {
                    new VHDLNonBlockAssignStmt(VHDLArrayAccess.this.process, VHDLArrayAccess.this.scope, VHDLArrayAccess.this.scope.getIdent(String.format("%s_raddr", base), VHDLExpr.TERM.LHS), VHDLArrayAccess.this.expr, this);
                }
            }
        }

        @Override
        public int state_count() {
            return 1;
        }

        @Override
        public boolean isStepNext() {
            return VHDLArrayAccess.this.term != VHDLExpr.TERM.LHS;
        }

        @Override
        public boolean isEndOfState() {
            return VHDLArrayAccess.this.term != VHDLExpr.TERM.LHS;
        }

        @Override
        public String getStmtBody() {
            return "<<VHDLArrayAccess>>";
        }

        @Override
        public void generate(PrintWriter out, int offset) {
            String base = VHDLArrayAccess.this.getBaseString();
            if (VHDLArrayAccess.this.term == VHDLExpr.TERM.LHS) {
                new VHDLNonBlockAssignStmt(VHDLArrayAccess.this.process, VHDLArrayAccess.this.scope, VHDLArrayAccess.this.scope.getIdent(String.format("%s_waddr", base), VHDLExpr.TERM.LHS), VHDLArrayAccess.this.expr).generate(out, offset);
                new VHDLNonBlockAssignStmt(VHDLArrayAccess.this.process, VHDLArrayAccess.this.scope, VHDLArrayAccess.this.scope.getIdent(String.format("%s_we", base), VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLLiteral(1)).generate(out, offset);
            } else {
                VHDLIdent raddr = VHDLArrayAccess.this.scope.getIdent(String.format("%s_raddr", base), VHDLExpr.TERM.LHS);
                this.writeln(out, String.format("case conv_integer(%s) is", this.STATE_SIG.value()), offset);
                this.writeln(out, "when 0 =>", offset + 2);
                new VHDLNonBlockAssignStmt(VHDLArrayAccess.this.process, VHDLArrayAccess.this.scope, raddr, VHDLArrayAccess.this.expr).generate(out, offset + 4);
                this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 4);
                this.writeln(out, "when 1 =>", offset + 2);
                this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIG.value()), offset + 4);
                this.writeln(out, String.format("%s <= %s + 1;", VHDLArrayAccess.this.scope.get_state_sig().value(), VHDLArrayAccess.this.scope.get_state_sig().value()), offset + 4);
                this.writeln(out, String.format("when others => %s <= (others => '0');", this.STATE_SIG.value()), offset + 2);
                this.writeln(out, "end case;", offset);
            }
            if (this.hasSibling()) {
                this.getSibling().generate(out, offset);
            }
        }

        @Override
        public boolean isSkip() {
            return false;
        }

        @Override
        public ArrayList<VHDLIdent> getDestIdent() {
            String base = VHDLArrayAccess.this.getBaseString();
            ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
            if (VHDLArrayAccess.this.term == VHDLExpr.TERM.LHS) {
                list.add(VHDLArrayAccess.this.scope.getIdent(String.format("%s_waddr", base), VHDLExpr.TERM.LHS));
                list.add(VHDLArrayAccess.this.scope.getIdent(String.format("%s_we", base), VHDLExpr.TERM.LHS));
            } else {
                list.add(VHDLArrayAccess.this.scope.getIdent(String.format("%s_raddr", base), VHDLExpr.TERM.LHS));
            }
            ArrayList<VHDLIdent> l0 = VHDLArrayAccess.this.indexed.getDestIdent();
            if (l0 != null) {
                list.addAll(l0);
            }
            if (VHDLArrayAccess.this.indexed instanceof VHDLIdent) {
                list.add((VHDLIdent)VHDLArrayAccess.this.indexed);
            }
            return list;
        }

        @Override
        public ArrayList<VHDLIdent> getSrcIdent() {
            return VHDLArrayAccess.this.expr.getSrcIdent();
        }
    }
}

