/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.vhdl.VHDLBinaryExpr;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLMethodReturnValueIdent;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLStatement;

public class VHDLExprStatement
extends VHDLStatement
implements VHDLItem {
    final VHDLExpr expr;
    final VHDLProcess p;

    public VHDLExprStatement(VHDLProcess p, VHDLExpr expr) {
        this.p = p;
        this.expr = expr;
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        if (!(this.expr instanceof VHDLMethodReturnValueIdent) && this.expr != null) {
            this.expr.generate(out, offset);
            this.writeln(out, ";", 0);
        }
        if (this.hasSibling()) {
            this.getSibling().generate(out, offset);
        }
    }

    @Override
    public void connect() {
        this.expr.connect();
    }

    @Override
    public void link() {
        super.link();
        this.expr.link();
    }

    @Override
    public int state_count() {
        if (this.hasSibling()) {
            return this.getSibling().state_count();
        }
        if (this.expr instanceof VHDLMethodReturnValueIdent) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isStepNext() {
        if (this.hasSibling()) {
            return this.getSibling().isStepNext();
        }
        return false;
    }

    @Override
    public String getStmtBody() {
        return String.format("VHDLExprStatement: expr = %s (%s)", this.expr, this.expr != null ? this.expr.getClass() : "NULL");
    }

    @Override
    public boolean isEndOfState() {
        boolean flag = true;
        if (this.hasSibling()) {
            flag |= this.getSibling().isEndOfState();
        }
        flag = this.expr instanceof VHDLMethodReturnValueIdent ? (flag |= false) : (this.expr != null ? (flag |= true) : (flag |= false));
        return flag;
    }

    @Override
    public boolean isSkip() {
        boolean flag = true;
        if (this.hasSibling()) {
            flag &= this.getSibling().isSkip();
        }
        flag = this.expr instanceof VHDLMethodReturnValueIdent ? (flag &= true) : (this.expr != null ? (flag &= false) : (flag &= true));
        return flag;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        return this.expr.getDestIdent();
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        return this.expr.getSrcIdent();
    }

    @Override
    public void setStateLabel(int cnt) {
        super.setStateLabel(cnt);
        if (this.expr instanceof VHDLBinaryExpr) {
            ((VHDLBinaryExpr)this.expr).setStateLabel(cnt);
        }
    }
}

