/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.StateMachineIface;
import net.wasamon.javarock.model.vhdl.ArbitorCandidate;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLFieldArbitor;
import net.wasamon.javarock.model.vhdl.VHDLFieldSignal;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLLiteral;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLNewArray;
import net.wasamon.javarock.model.vhdl.VHDLNonBlockAssignStmt;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLRawStatement;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import net.wasamon.javarock.tools.CompileState;
import net.wasamon.javarock.tools.Manager;

public class VHDLFieldPrimitiveSignal
extends VHDLSignal
implements VHDLFieldSignal {
    final VHDLSignal read_sig;
    final VHDLSignal write_sig;
    final VHDLPort output_port;
    final VHDLPort input_port;
    final VHDLPort input_strobe_port;
    final VHDLFieldArbitor arbitor = new VHDLFieldArbitor();
    final ArrayList<VHDLSignal> subSignals = new ArrayList();
    boolean readonly = false;
    private final VHDLRawStatement arbitor_stmt = new VHDLRawStatement("");
    private final VHDLRawStatement update_stmt = new VHDLRawStatement("");

    public VHDLFieldPrimitiveSignal(VHDLModule m, VHDLScopeIface scope, String name, JavaRockType type, boolean export_flag) {
        this(m, name, type, null, export_flag);
    }

    public VHDLFieldPrimitiveSignal(VHDLModule m, String name, JavaRockType type, VHDLExpr reset, boolean export_flag) {
        super(m, name, type, reset);
        this.read_sig = new VHDLSignal(m, String.valueOf(name) + "_field_rdata", type, reset);
        this.write_sig = new VHDLSignal(m, String.valueOf(name) + "_field_wdata", type, reset);
        this.subSignals.add(new VHDLSignal(m, this.genResetSignalName(this.write_sig.name), this.write_sig.type, reset));
        this.subSignals.add(new VHDLSignal(m, this.genResetStrobeName(this.write_sig.name), VHDLTypeBuilder.getStdLogic(), null));
        if (export_flag) {
            this.output_port = new VHDLPort(this.module, String.valueOf(this.read_sig.name) + "_output_port", type, VHDLPort.Dir.OUT);
            m.output.put(this.output_port.name, this.output_port);
            this.input_port = new VHDLPort(this.module, String.valueOf(this.read_sig.name) + "_input_port", type, VHDLPort.Dir.IN);
            m.output.put(this.input_port.name, this.input_port);
            this.input_strobe_port = new VHDLPort(this.module, String.valueOf(this.read_sig.name) + "_input_strobe_port", (JavaRockType)VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN);
            m.output.put(this.input_strobe_port.name, this.input_strobe_port);
            m.combinations.add(new VHDLNonBlockAssignStmt(null, null, new VHDLIdent(this.output_port, VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLIdent(this.read_sig, VHDLExpr.TERM.RHS)));
        } else {
            this.output_port = null;
            this.input_port = null;
            this.input_strobe_port = null;
        }
    }

    private String genWriterSignalPostFix(StateMachineIface p) {
        String postfix = p != null ? p.get_state_sig().value() : "top";
        return "_writer_" + postfix;
    }

    private String genWriterStrobePostFix(StateMachineIface p) {
        String postfix = p != null ? p.get_state_sig().value() : "top";
        return "_writer_strobe_" + postfix;
    }

    private String genResetSignalName(String s) {
        return String.valueOf(s) + "_reset";
    }

    private String genResetStrobeName(String s) {
        return String.valueOf(s) + "_reset_strobe";
    }

    @Override
    public String addWriter(VHDLScopeIface scope, VHDLStatement stmt) {
        String postfix = this.genWriterSignalPostFix(scope);
        boolean flag = this.arbitor.add(scope, stmt, String.valueOf(this.write_sig.name) + postfix);
        if (flag) {
            this.subSignals.add(new VHDLSignal(this.module, String.valueOf(this.write_sig.name) + this.genWriterSignalPostFix(scope), this.write_sig.type));
            this.subSignals.add(new VHDLSignal(this.module, String.valueOf(this.write_sig.name) + this.genWriterStrobePostFix(scope), VHDLTypeBuilder.getStdLogic(), null));
        }
        if (Manager.INSTANCE.isCompileState(CompileState.LINK)) {
            this.genArbitor();
            this.genUpdateReadSingal();
        }
        return postfix;
    }

    @Override
    public String addReader(VHDLScopeIface scope, VHDLStatement stmt) {
        return "";
    }

    @Override
    public String getReadSigName() {
        return this.read_sig.name;
    }

    @Override
    public String getWriteSigName() {
        return this.write_sig.name;
    }

    @Override
    public void connect() {
        super.connect();
    }

    private String genStateCondition(ArbitorCandidate c) {
        String s = "";
        String sep = "";
        for (VHDLStatement stmt : c.stmts) {
            s = String.valueOf(s) + String.format("%sconv_integer(%s) = %d", sep, c.state.get_state_sig().value(), stmt.getStateLabel());
            sep = " or ";
        }
        return s;
    }

    private String genStrobeCondition(ArbitorCandidate c) {
        return String.format("%s = '1'", String.valueOf(this.write_sig.name) + this.genWriterStrobePostFix(c.state));
    }

    private void genArbitor() {
        if (this.readonly) {
            this.arbitor_stmt.update("");
            return;
        }
        String s = "";
        s = String.valueOf(s) + String.format("process(clk)\n", new Object[0]);
        s = String.valueOf(s) + String.format("begin\n", new Object[0]);
        s = String.valueOf(s) + String.format("  if (clk'event and clk = '1') then\n", new Object[0]);
        s = String.valueOf(s) + String.format("    if (reset = '1') then\n", new Object[0]);
        s = String.valueOf(s) + String.format("      %s <= %s;\n", this.write_sig.name, this.genResetSignalName(this.write_sig.name));
        s = String.valueOf(s) + String.format("    elsif (%s = '1') then\n", this.genResetStrobeName(this.write_sig.name));
        s = String.valueOf(s) + String.format("      %s <= %s;\n", this.write_sig.name, this.genResetSignalName(this.write_sig.name));
        for (ArbitorCandidate c : this.arbitor.candidates()) {
            s = String.valueOf(s) + String.format("    elsif (%s) then\n", this.genStrobeCondition(c));
            s = String.valueOf(s) + String.format("      %s <= %s;\n", this.write_sig.name, String.valueOf(this.write_sig.name) + this.genWriterSignalPostFix(c.state));
        }
        s = String.valueOf(s) + String.format("    end if;\n", new Object[0]);
        s = String.valueOf(s) + String.format("  end if;\n", new Object[0]);
        s = String.valueOf(s) + String.format("end process;\n", new Object[0]);
        s = String.valueOf(s) + String.format("process(clk)\n", new Object[0]);
        s = String.valueOf(s) + String.format("begin\n", new Object[0]);
        s = String.valueOf(s) + String.format("  if (clk'event and clk = '1') then\n", new Object[0]);
        s = String.valueOf(s) + String.format("    if (reset = '1') then\n", new Object[0]);
        s = String.valueOf(s) + String.format("      %s <= '1';\n", this.genResetStrobeName(this.write_sig.name));
        s = String.valueOf(s) + String.format("    else\n", new Object[0]);
        s = String.valueOf(s) + String.format("      %s <= '0';\n", this.genResetStrobeName(this.write_sig.name));
        s = String.valueOf(s) + String.format("    end if;\n", new Object[0]);
        for (ArbitorCandidate c : this.arbitor.candidates()) {
            s = String.valueOf(s) + String.format("    if (%s) then\n", this.genStateCondition(c));
            s = String.valueOf(s) + String.format("      %s <= '1';\n", String.valueOf(this.write_sig.name) + this.genWriterStrobePostFix(c.state));
            s = String.valueOf(s) + String.format("    else\n", new Object[0]);
            s = String.valueOf(s) + String.format("      %s <= '0';\n", String.valueOf(this.write_sig.name) + this.genWriterStrobePostFix(c.state));
            s = String.valueOf(s) + String.format("    end if;\n", new Object[0]);
        }
        s = String.valueOf(s) + String.format("  end if;\n", new Object[0]);
        s = String.valueOf(s) + String.format("end process;\n", new Object[0]);
        this.arbitor_stmt.update(s);
    }

    private void genUpdateReadSingal() {
        String s = "";
        if (!this.readonly) {
            s = String.valueOf(s) + String.format("%s <= %s when (reset = '1') else\n", this.read_sig.name, this.genResetSignalName(this.write_sig.name));
            s = String.valueOf(s) + String.format("      %s when (%s = '1') else\n", this.genResetSignalName(this.write_sig.name), this.genResetStrobeName(this.write_sig.name));
            for (ArbitorCandidate c : this.arbitor.candidates()) {
                s = String.valueOf(s) + String.format("      %s when (%s) else\n", c.src, this.genStrobeCondition(c));
            }
            s = String.valueOf(s) + String.format("      %s;\n", this.write_sig.name);
        } else {
            s = String.valueOf(s) + String.format("%s <= %s;\n", this.read_sig.name, this.write_sig.name);
        }
        this.update_stmt.update(s);
    }

    private void check() {
        for (ArbitorCandidate c : this.arbitor.candidates()) {
            for (VHDLStatement stmt : c.stmts) {
                if (stmt.getStateLabel() != 0) continue;
                System.out.printf("VHDLFieldPrimitiveSignal::getStateCondition: LABEL[%s] is 0, the desgin should not work.\n", stmt);
            }
        }
    }

    @Override
    public void link() {
        this.genArbitor();
        this.genUpdateReadSingal();
        ((VHDLModule)this.module).combinations.add(this.arbitor_stmt);
        ((VHDLModule)this.module).combinations.add(this.update_stmt);
    }

    public String toString() {
        String s = "";
        for (VHDLSignal sig : this.subSignals) {
            s = String.valueOf(s) + sig + "\n";
        }
        s = String.valueOf(s) + this.read_sig + "\n";
        s = String.valueOf(s) + this.write_sig + "\n";
        return s;
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        for (VHDLSignal sig : this.subSignals) {
            sig.generate(out, offset);
        }
        this.read_sig.generate(out, offset);
        this.write_sig.generate(out, offset);
    }

    @Override
    public String getResetStmt() {
        String s = "";
        if (this.reset == null && this.type != null && this.type.getDefaultValue() != null) {
            s = String.valueOf(s) + this.genResetSignalName(this.write_sig.name);
            s = String.valueOf(s) + " <= ";
            s = String.valueOf(s) + this.getResetExpr();
        } else if (this.reset != null && this.reset instanceof VHDLLiteral) {
            s = String.valueOf(s) + this.genResetSignalName(this.write_sig.name);
            s = String.valueOf(s) + " <= ";
            s = String.valueOf(s) + this.getResetExpr();
        } else {
            if (this.reset != null && this.reset instanceof VHDLNewArray) {
                return "";
            }
            if (this.reset != null) {
                s = String.valueOf(s) + this.reset;
            } else if (this.reset == null) {
                return "";
            }
        }
        s = String.valueOf(s) + ";";
        return s;
    }

    @Override
    public void setReadOnly(boolean flag) {
        this.readonly = flag;
    }
}

