/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.vhdl.VHDLArrayAccess;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLFieldSignal;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLLiteral;
import net.wasamon.javarock.model.vhdl.VHDLMethodReturnValueIdent;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.VHDLVariable;
import net.wasamon.javarock.model.vhdl.type.StdLogic;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;
import net.wasamon.javarock.model.vhdl.type.VHDLInteger;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;

public class VHDLNonBlockAssignStmt
extends VHDLStatement
implements VHDLItem {
    final VHDLIdent lhs;
    final VHDLExpr rhs;
    final VHDLScopeIface scope;
    final VHDLProcess p;
    final String postfix_lhs;

    public VHDLNonBlockAssignStmt(VHDLProcess p, VHDLScopeIface scope, VHDLIdent lhs, VHDLExpr rhs, VHDLStatement stmt) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.scope = scope;
        this.p = p;
        if (p != null && rhs instanceof VHDLIdent) {
            p.addSensitive((VHDLIdent)rhs);
        }
        this.postfix_lhs = lhs.var instanceof VHDLFieldSignal ? ((VHDLFieldSignal)((Object)lhs.var)).addWriter(scope, stmt) : "";
    }

    public VHDLNonBlockAssignStmt(VHDLProcess p, VHDLScopeIface scope, VHDLIdent lhs, VHDLExpr rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.scope = scope;
        this.p = p;
        if (p != null && rhs instanceof VHDLIdent) {
            p.addSensitive((VHDLIdent)rhs);
        }
        this.postfix_lhs = lhs.var instanceof VHDLFieldSignal ? ((VHDLFieldSignal)((Object)lhs.var)).addWriter(scope, this) : "";
    }

    public VHDLNonBlockAssignStmt(VHDLProcess p, VHDLScopeIface scope, VHDLIdent lhs, VHDLExpr rhs, boolean force_direct_flag) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.scope = scope;
        this.p = p;
        if (p != null && rhs instanceof VHDLIdent) {
            p.addSensitive((VHDLIdent)rhs);
        }
        this.postfix_lhs = lhs.var instanceof VHDLFieldSignal && !force_direct_flag ? ((VHDLFieldSignal)((Object)lhs.var)).addWriter(scope, this) : "";
    }

    public VHDLNonBlockAssignStmt(VHDLProcess p, VHDLScopeIface scope, VHDLArrayAccess lhs, VHDLExpr rhs) {
        this.lhs = lhs.ident(VHDLExpr.TERM.LHS);
        this.rhs = rhs;
        this.scope = scope;
        this.p = p;
        if (rhs instanceof VHDLIdent) {
            p.addSensitive((VHDLIdent)rhs);
        }
        this.postfix_lhs = "";
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        if (!(this.rhs instanceof VHDLIdent && ((VHDLIdent)this.rhs).var.type instanceof VHDLArrayType && this.lhs instanceof VHDLIdent && this.lhs.var.type instanceof VHDLArrayType)) {
            this.writeln(out, String.format("%s;", this.getStmtBody()), offset);
        }
        if (this.hasSibling()) {
            this.getSibling().generate(out, offset);
        }
    }

    @Override
    public void connect() {
        if (this.rhs instanceof VHDLIdent && ((VHDLIdent)this.rhs).var.type instanceof VHDLArrayType && this.lhs.var.type instanceof VHDLArrayType) {
            String rbase = ((VHDLIdent)this.rhs).sym;
            String lbase = this.lhs.sym;
            VHDLArrayType rarray = (VHDLArrayType)((VHDLIdent)this.rhs).var.type;
            VHDLArrayType larray = (VHDLArrayType)this.lhs.var.type;
            VHDLIdent lhs = new VHDLIdent(new VHDLVariable(this.p.module, String.valueOf(lbase) + "_length", VHDLTypeBuilder.getStdLogicVector(31, 0)), VHDLExpr.TERM.LHS);
            VHDLIdent rhs = this.scope.getIdent(String.valueOf(rbase) + "_length", VHDLExpr.TERM.RHS);
            this.p.module.combinations.add(new VHDLNonBlockAssignStmt(this.p, this.scope, lhs, (VHDLExpr)rhs));
            lhs = new VHDLIdent(new VHDLVariable(this.p.module, String.valueOf(lbase) + "_rdata", VHDLTypeBuilder.getStdLogicVector(31, 0)), VHDLExpr.TERM.LHS);
            rhs = this.scope.getIdent(String.valueOf(rbase) + "_rdata", VHDLExpr.TERM.RHS);
            this.p.module.combinations.add(new VHDLNonBlockAssignStmt(this.p, this.scope, lhs, (VHDLExpr)rhs));
            lhs = this.scope.getIdent(String.valueOf(rbase) + "_raddr", VHDLExpr.TERM.LHS);
            rhs = new VHDLIdent(new VHDLVariable(this.p.module, String.valueOf(lbase) + "_raddr", VHDLTypeBuilder.getStdLogicVector(larray.getDepth(), 0)), VHDLExpr.TERM.RHS);
            this.p.module.combinations.add(new VHDLNonBlockAssignStmt(this.p, this.scope, lhs, (VHDLExpr)rhs));
        } else {
            this.rhs.connect();
            this.lhs.connect();
        }
        if (this.lhs.var instanceof VHDLSignal && !((VHDLSignal)this.lhs.var).hasResetProcess()) {
            this.p.addResetStmt((VHDLSignal)this.lhs.var);
        }
        if (!this.p.sequential) {
            this.rhs.addSensitivityList(this.p);
        }
    }

    @Override
    public void link() {
        this.rhs.link();
        this.lhs.link();
        super.link();
    }

    @Override
    public int state_count() {
        if (this.hasSibling()) {
            return this.getSibling().state_count();
        }
        return 1;
    }

    @Override
    public boolean isStepNext() {
        if (this.hasSibling()) {
            return this.getSibling().isStepNext();
        }
        return false;
    }

    @Override
    public String getStmtBody() {
        String rvalue = this.rhs.getExprAsStr();
        boolean convFlag = false;
        if (this.rhs.hasFixedBitWidth()) {
            rvalue = String.format("conv_integer(%s)", this.rhs.getExprAsStr());
            convFlag |= true;
        }
        if (this.rhs instanceof VHDLLiteral && !this.rhs.isInteger() && this.lhs.var.type instanceof StdLogicVector) {
            rvalue = String.format("conv_integer(%s)", this.rhs.getExprAsStr());
            convFlag |= true;
        }
        if (this.rhs.isInteger()) {
            convFlag |= true;
        }
        if (this.rhs instanceof VHDLIdent && this.rhs.getType() instanceof VHDLInteger) {
            convFlag |= true;
        }
        if (this.rhs instanceof VHDLMethodReturnValueIdent && this.lhs.var.type instanceof StdLogicVector) {
            rvalue = String.format("conv_integer(%s)", this.rhs.getExprAsStr());
            convFlag |= true;
        }
        if (this.rhs instanceof VHDLArrayAccess && this.lhs.var.type instanceof StdLogicVector) {
            rvalue = String.format("conv_integer(%s)", ((VHDLArrayAccess)this.rhs).getReadSignal());
            convFlag |= true;
        }
        if (this.rhs instanceof VHDLArrayAccess && this.lhs.var.type instanceof StdLogic) {
            rvalue = ((VHDLArrayAccess)this.rhs).getReadSignal();
            convFlag |= true;
        }
        if (this.lhs.var.type instanceof StdLogicVector && convFlag) {
            return String.format("%s%s <= conv_std_logic_vector(%s, %s'length)", this.lhs.getExprAsStr(), this.postfix_lhs, rvalue, this.lhs.getExprAsStr());
        }
        return String.format("%s%s <= %s", this.lhs.getExprAsStr(), this.postfix_lhs, rvalue);
    }

    @Override
    public boolean isEndOfState() {
        boolean flag = true;
        if (this.hasSibling()) {
            flag &= this.getSibling().isEndOfState();
        }
        return flag;
    }

    @Override
    public boolean isSkip() {
        return false;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        list.add(this.lhs);
        return list;
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        return this.rhs.getSrcIdent();
    }
}

