/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.util.ArrayList;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLOp;
import net.wasamon.javarock.model.vhdl.VHDLProcess;

public class VHDLUnaryExpr
extends VHDLExpr
implements VHDLItem {
    public final VHDLExpr arg;
    public final VHDLOp op;

    public VHDLUnaryExpr(VHDLProcess p, VHDLOp op, VHDLExpr arg) {
        this.arg = arg;
        this.op = op;
    }

    @Override
    public void connect() {
        this.arg.connect();
    }

    @Override
    public void link() {
        this.arg.link();
    }

    @Override
    public JavaRockType getType() {
        return this.arg.getType();
    }

    @Override
    public String getExprAsStr() {
        if (this.arg == null) {
            return String.format("VHDLBinaryExpr: null expr found @ %s %s\n", new Object[]{this.arg, this.op});
        }
        String s0 = this.arg.getExprAsStr();
        if (this.op == VHDLOp.NOT) {
            if (this.arg.isInteger()) {
                s0 = String.format("conv_std_logic_vector(%s, 32)", this.arg);
            }
            return String.format("conv_integer(%s %s)", new Object[]{this.op, s0});
        }
        return String.format("%s %s", new Object[]{this.op, s0});
    }

    @Override
    public void addSensitivityList(VHDLProcess p) {
        this.arg.addSensitivityList(p);
    }

    @Override
    public boolean isInteger() {
        return this.op.isArith();
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        return this.arg.getSrcIdent();
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        return this.arg.getDestIdent();
    }
}

