/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.code;

import java.util.HashMap;
import java.util.Map;
import openjdk.com.sun.tools.javac.util.Assert;
import openjdk.com.sun.tools.javac.util.Context;
import openjdk.com.sun.tools.javac.util.JCDiagnostic;
import openjdk.com.sun.tools.javac.util.ListBuffer;

public class DeferredLintHandler {
    protected static final Context.Key<DeferredLintHandler> deferredLintHandlerKey = new Context.Key();
    private JCDiagnostic.DiagnosticPosition currentPos;
    private Map<JCDiagnostic.DiagnosticPosition, ListBuffer<LintLogger>> loggersQueue = new HashMap<JCDiagnostic.DiagnosticPosition, ListBuffer<LintLogger>>();
    public static final DeferredLintHandler immediateHandler = new DeferredLintHandler(){

        @Override
        public void report(LintLogger logger) {
            logger.report();
        }
    };

    public static DeferredLintHandler instance(Context context) {
        DeferredLintHandler instance = context.get(deferredLintHandlerKey);
        if (instance == null) {
            instance = new DeferredLintHandler(context);
        }
        return instance;
    }

    protected DeferredLintHandler(Context context) {
        context.put(deferredLintHandlerKey, this);
    }

    private DeferredLintHandler() {
    }

    public void report(LintLogger logger) {
        ListBuffer<LintLogger> loggers = this.loggersQueue.get(this.currentPos);
        Assert.checkNonNull(loggers);
        loggers.append(logger);
    }

    public void flush(JCDiagnostic.DiagnosticPosition pos) {
        ListBuffer<LintLogger> loggers = this.loggersQueue.get(pos);
        if (loggers != null) {
            for (LintLogger lintLogger : loggers) {
                lintLogger.report();
            }
            this.loggersQueue.remove(pos);
        }
    }

    public DeferredLintHandler setPos(JCDiagnostic.DiagnosticPosition currentPos) {
        this.currentPos = currentPos;
        this.loggersQueue.put(currentPos, ListBuffer.lb());
        return this;
    }

    /* synthetic */ DeferredLintHandler(DeferredLintHandler deferredLintHandler) {
        this();
    }

    public static interface LintLogger {
        public void report();
    }
}

