/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.code;

import java.util.Locale;
import openjdk.com.sun.tools.javac.api.Messages;
import openjdk.com.sun.tools.javac.code.BoundKind;
import openjdk.com.sun.tools.javac.code.Symbol;
import openjdk.com.sun.tools.javac.code.Type;
import openjdk.com.sun.tools.javac.util.List;
import openjdk.com.sun.tools.javac.util.ListBuffer;

public abstract class Printer
implements Type.Visitor<String, Locale>,
Symbol.Visitor<String, Locale> {
    List<Type> seenCaptured = List.nil();
    static final int PRIME = 997;

    protected abstract String localize(Locale var1, String var2, Object ... var3);

    protected abstract String capturedVarId(Type.CapturedType var1, Locale var2);

    public static Printer createStandardPrinter(final Messages messages) {
        return new Printer(){

            @Override
            protected String localize(Locale locale, String key, Object ... args) {
                return messages.getLocalizedString(locale, key, args);
            }

            @Override
            protected String capturedVarId(Type.CapturedType t, Locale locale) {
                return String.valueOf(((long)t.hashCode() & 0xFFFFFFFFL) % 997L);
            }
        };
    }

    public String visitTypes(List<Type> ts, Locale locale) {
        ListBuffer sbuf = ListBuffer.lb();
        for (Type t : ts) {
            sbuf.append(this.visit(t, locale));
        }
        return sbuf.toList().toString();
    }

    public String visitSymbols(List<Symbol> ts, Locale locale) {
        ListBuffer sbuf = ListBuffer.lb();
        for (Symbol t : ts) {
            sbuf.append(this.visit(t, locale));
        }
        return sbuf.toList().toString();
    }

    public String visit(Type t, Locale locale) {
        return t.accept(this, locale);
    }

    public String visit(Symbol s, Locale locale) {
        return s.accept(this, locale);
    }

    @Override
    public String visitCapturedType(Type.CapturedType t, Locale locale) {
        if (this.seenCaptured.contains(t)) {
            return this.localize(locale, "compiler.misc.type.captureof.1", this.capturedVarId(t, locale));
        }
        try {
            this.seenCaptured = this.seenCaptured.prepend(t);
            String string = this.localize(locale, "compiler.misc.type.captureof", this.capturedVarId(t, locale), this.visit(t.wildcard, locale));
            return string;
        }
        finally {
            this.seenCaptured = this.seenCaptured.tail;
        }
    }

    @Override
    public String visitForAll(Type.ForAll t, Locale locale) {
        return "<" + this.visitTypes(t.tvars, locale) + ">" + this.visit(t.qtype, locale);
    }

    @Override
    public String visitUndetVar(Type.UndetVar t, Locale locale) {
        if (t.inst != null) {
            return this.visit(t.inst, locale);
        }
        return String.valueOf(this.visit(t.qtype, locale)) + "?";
    }

    @Override
    public String visitArrayType(Type.ArrayType t, Locale locale) {
        return String.valueOf(this.visit(t.elemtype, locale)) + "[]";
    }

    @Override
    public String visitClassType(Type.ClassType t, Locale locale) {
        StringBuffer buf = new StringBuffer();
        if (t.getEnclosingType().tag == 10 && t.tsym.owner.kind == 2) {
            buf.append(this.visit(t.getEnclosingType(), locale));
            buf.append(".");
            buf.append(this.className(t, false, locale));
        } else {
            buf.append(this.className(t, true, locale));
        }
        if (((List)t.getTypeArguments()).nonEmpty()) {
            buf.append('<');
            buf.append(this.visitTypes((List<Type>)t.getTypeArguments(), locale));
            buf.append(">");
        }
        return buf.toString();
    }

    @Override
    public String visitMethodType(Type.MethodType t, Locale locale) {
        return "(" + this.printMethodArgs(t.argtypes, false, locale) + ")" + this.visit(t.restype, locale);
    }

    @Override
    public String visitPackageType(Type.PackageType t, Locale locale) {
        return t.tsym.getQualifiedName().toString();
    }

    @Override
    public String visitWildcardType(Type.WildcardType t, Locale locale) {
        StringBuffer s = new StringBuffer();
        s.append((Object)t.kind);
        if (t.kind != BoundKind.UNBOUND) {
            s.append(this.visit(t.type, locale));
        }
        return s.toString();
    }

    @Override
    public String visitErrorType(Type.ErrorType t, Locale locale) {
        return this.visitType((Type)t, locale);
    }

    @Override
    public String visitTypeVar(Type.TypeVar t, Locale locale) {
        return this.visitType((Type)t, locale);
    }

    @Override
    public String visitType(Type t, Locale locale) {
        String s = t.tsym == null || t.tsym.name == null ? this.localize(locale, "compiler.misc.type.none", new Object[0]) : t.tsym.name.toString();
        return s;
    }

    protected String className(Type.ClassType t, boolean longform, Locale locale) {
        Symbol.TypeSymbol sym = t.tsym;
        if (sym.name.length() == 0 && (sym.flags() & 0x1000000L) != 0L) {
            StringBuffer s = new StringBuffer(this.visit(t.supertype_field, locale));
            List<Type> is = t.interfaces_field;
            while (is.nonEmpty()) {
                s.append("&");
                s.append(this.visit((Type)is.head, locale));
                is = is.tail;
            }
            return s.toString();
        }
        if (sym.name.length() == 0) {
            Type.ClassType norm = (Type.ClassType)t.tsym.type;
            String s = norm == null ? this.localize(locale, "compiler.misc.anonymous.class", new Object[]{null}) : (norm.interfaces_field.nonEmpty() ? this.localize(locale, "compiler.misc.anonymous.class", this.visit((Type)norm.interfaces_field.head, locale)) : this.localize(locale, "compiler.misc.anonymous.class", this.visit(norm.supertype_field, locale)));
            return s;
        }
        if (longform) {
            return sym.getQualifiedName().toString();
        }
        return sym.name.toString();
    }

    protected String printMethodArgs(List<Type> args, boolean varArgs, Locale locale) {
        if (!varArgs) {
            return this.visitTypes(args, locale);
        }
        StringBuffer buf = new StringBuffer();
        while (args.tail.nonEmpty()) {
            buf.append(this.visit((Type)args.head, locale));
            args = args.tail;
            buf.append(',');
        }
        if (((Type)args.head).tag == 11) {
            buf.append(this.visit(((Type.ArrayType)args.head).elemtype, locale));
            buf.append("...");
        } else {
            buf.append(this.visit((Type)args.head, locale));
        }
        return buf.toString();
    }

    @Override
    public String visitClassSymbol(Symbol.ClassSymbol sym, Locale locale) {
        return sym.name.isEmpty() ? this.localize(locale, "compiler.misc.anonymous.class", sym.flatname) : sym.fullname.toString();
    }

    @Override
    public String visitMethodSymbol(Symbol.MethodSymbol s, Locale locale) {
        String ms;
        if (s.isStaticOrInstanceInit()) {
            return s.owner.name.toString();
        }
        String string = ms = s.name == s.name.table.names.init ? s.owner.name.toString() : s.name.toString();
        if (s.type != null) {
            if (s.type.tag == 16) {
                ms = "<" + this.visitTypes(s.type.getTypeArguments(), locale) + ">" + ms;
            }
            ms = String.valueOf(ms) + "(" + this.printMethodArgs(s.type.getParameterTypes(), (s.flags() & 0x400000000L) != 0L, locale) + ")";
        }
        return ms;
    }

    @Override
    public String visitOperatorSymbol(Symbol.OperatorSymbol s, Locale locale) {
        return this.visitMethodSymbol((Symbol.MethodSymbol)s, locale);
    }

    @Override
    public String visitPackageSymbol(Symbol.PackageSymbol s, Locale locale) {
        return s.isUnnamed() ? this.localize(locale, "compiler.misc.unnamed.package", new Object[0]) : s.fullname.toString();
    }

    @Override
    public String visitTypeSymbol(Symbol.TypeSymbol s, Locale locale) {
        return this.visitSymbol((Symbol)s, locale);
    }

    @Override
    public String visitVarSymbol(Symbol.VarSymbol s, Locale locale) {
        return this.visitSymbol((Symbol)s, locale);
    }

    @Override
    public String visitSymbol(Symbol s, Locale locale) {
        return s.name.toString();
    }
}

