/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.file;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import openjdk.com.sun.tools.javac.file.FSInfo;
import openjdk.com.sun.tools.javac.util.Context;

public class CacheFSInfo
extends FSInfo {
    private Map<File, Entry> cache = new ConcurrentHashMap<File, Entry>();

    public static void preRegister(Context context) {
        context.put(FSInfo.class, new Context.Factory<FSInfo>(){

            @Override
            public FSInfo make(Context c) {
                CacheFSInfo instance = new CacheFSInfo();
                c.put(FSInfo.class, instance);
                return instance;
            }
        });
    }

    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public File getCanonicalFile(File file) {
        Entry e = this.getEntry(file);
        return e.canonicalFile;
    }

    @Override
    public boolean exists(File file) {
        Entry e = this.getEntry(file);
        return e.exists;
    }

    @Override
    public boolean isDirectory(File file) {
        Entry e = this.getEntry(file);
        return e.isDirectory;
    }

    @Override
    public boolean isFile(File file) {
        Entry e = this.getEntry(file);
        return e.isFile;
    }

    @Override
    public List<File> getJarClassPath(File file) throws IOException {
        Entry e = this.getEntry(file);
        if (e.jarClassPath == null) {
            e.jarClassPath = super.getJarClassPath(file);
        }
        return e.jarClassPath;
    }

    private Entry getEntry(File file) {
        Entry e = this.cache.get(file);
        if (e == null) {
            e = new Entry();
            e.canonicalFile = super.getCanonicalFile(file);
            e.exists = super.exists(file);
            e.isDirectory = super.isDirectory(file);
            e.isFile = super.isFile(file);
            this.cache.put(file, e);
        }
        return e;
    }

    private static class Entry {
        File canonicalFile;
        boolean exists;
        boolean isFile;
        boolean isDirectory;
        List<File> jarClassPath;

        private Entry() {
        }
    }
}

