/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.Hashtable;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;

public class VHDLArrayPort
extends VHDLPort {
    final VHDLProcess p;
    final Hashtable<String, VHDLPort> ports = new Hashtable();

    public VHDLArrayPort(VHDLProcess p, String name, VHDLArrayType type, VHDLPort.Dir dir) {
        super((JavaRockComponentIface)p.module, name, (JavaRockType)type, dir);
        this.p = p;
        if (dir == VHDLPort.Dir.IN) {
            this.addPort("raddr", new VHDLPort((JavaRockComponentIface)p.module, String.format("%s_raddr", name), (JavaRockType)VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.OUT));
            this.addPort("rdata", new VHDLPort((JavaRockComponentIface)p.module, String.format("%s_rdata", name), (JavaRockType)VHDLTypeBuilder.getStdLogicVector(String.valueOf(type.getWidth()) + "-1", "0"), VHDLPort.Dir.IN));
            this.addPort("length", new VHDLPort((JavaRockComponentIface)p.module, String.format("%s_length", name), (JavaRockType)VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
        } else {
            this.addPort("raddr", new VHDLPort((JavaRockComponentIface)p.module, String.format("%s_raddr", name), (JavaRockType)VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
            this.addPort("rdata", new VHDLPort((JavaRockComponentIface)p.module, String.format("%s_rdata", name), (JavaRockType)VHDLTypeBuilder.getStdLogicVector(String.valueOf(type.getWidth()) + "-1", "0"), VHDLPort.Dir.OUT));
            this.addPort("length", new VHDLPort((JavaRockComponentIface)p.module, String.format("%s_length", name), (JavaRockType)VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.OUT));
        }
    }

    private void addPort(String key, VHDLPort p) {
        this.ports.put(key, p);
    }

    public VHDLIdent getIdent(String n, VHDLExpr.TERM t) {
        if (this.ports.containsKey(n)) {
            return new VHDLIdent(this.ports.get(n), t);
        }
        throw new RuntimeException("VHDLArrayPort does not have such a field: " + n);
    }

    @Override
    public void connect() {
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        String sp = "";
        String pad = this.pad(offset);
        for (VHDLPort p : this.ports.values()) {
            this.write(out, String.valueOf(sp) + pad + p.getDeclExpr(), 0);
            sp = ";\n";
        }
    }
}

