/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.util.ArrayList;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.VHDLArrayAccess;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLFieldAccess;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLLiteral;
import net.wasamon.javarock.model.vhdl.VHDLNonBlockAssignStmt;
import net.wasamon.javarock.model.vhdl.VHDLOp;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.type.StdLogic;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;

public class VHDLBinaryExpr
extends VHDLExpr
implements VHDLItem {
    public final VHDLExpr arg0;
    public final VHDLExpr arg1;
    public final VHDLOp op;
    final VHDLProcess p;
    final VHDLScopeIface scope;
    private VHDLStatement stmt;

    public VHDLBinaryExpr(VHDLProcess p, VHDLScopeIface scope, VHDLOp op, VHDLExpr arg0, VHDLExpr arg1) {
        this.p = p;
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.op = op;
        this.scope = scope;
        if (arg0 instanceof VHDLIdent && op != VHDLOp.NONBLOCKING_ASSIGN && op != VHDLOp.BLOCKING_ASSIGN && p != null) {
            p.addSensitive((VHDLIdent)arg0);
        }
        if (arg1 instanceof VHDLIdent && p != null) {
            p.addSensitive((VHDLIdent)arg1);
        }
    }

    private VHDLStatement genNonBlockingAssignStmt() {
        if (this.arg0 instanceof VHDLArrayAccess) {
            return new VHDLNonBlockAssignStmt(this.p, this.scope, ((VHDLArrayAccess)this.arg0).getIdent(), this.arg1);
        }
        if (this.arg0 instanceof VHDLFieldAccess) {
            return new VHDLNonBlockAssignStmt(this.p, this.scope, ((VHDLFieldAccess)this.arg0).getIdent(VHDLExpr.TERM.LHS), this.arg1);
        }
        if (this.arg0 instanceof VHDLIdent) {
            return new VHDLNonBlockAssignStmt(this.p, this.scope, (VHDLIdent)this.arg0, this.arg1);
        }
        System.err.println(String.format("%s(%s) is not VHDLIdent", this.arg0.getExprAsStr(), this.arg0.getClass()));
        System.exit(0);
        return null;
    }

    @Override
    public void connect() {
        this.arg1.connect();
        this.arg0.connect();
        if (this.op == VHDLOp.NONBLOCKING_ASSIGN) {
            this.stmt = this.genNonBlockingAssignStmt();
            this.stmt.connect();
        }
    }

    public void setStateLabel(int cnt) {
        if (this.op == VHDLOp.NONBLOCKING_ASSIGN) {
            this.stmt.setStateLabel(cnt);
        }
    }

    @Override
    public void link() {
        this.arg1.link();
        this.arg0.link();
    }

    @Override
    public JavaRockType getType() {
        return this.arg0.getType();
    }

    @Override
    public String getExprAsStr() {
        if (this.arg0 == null || this.arg1 == null) {
            System.err.printf("VHDLBinaryExpr: null expr found @ %s %s %s\n", new Object[]{this.arg0, this.arg1, this.op});
        }
        String s1 = this.arg1 instanceof VHDLArrayAccess ? ((VHDLArrayAccess)this.arg1).getIdent().getExprAsStr() : (this.arg1 instanceof VHDLFieldAccess ? ((VHDLFieldAccess)this.arg1).getIdent(VHDLExpr.TERM.RHS).getExprAsStr() : this.arg1.getExprAsStr());
        String s0 = this.arg0 instanceof VHDLArrayAccess ? ((VHDLArrayAccess)this.arg0).getIdent().getExprAsStr() : (this.arg0 instanceof VHDLFieldAccess ? ((VHDLFieldAccess)this.arg0).getIdent(VHDLExpr.TERM.RHS).getExprAsStr() : this.arg0.getExprAsStr());
        if (!this.arg0.isInteger() && this.arg0.hasFixedBitWidth() && !(this.arg0.getType() instanceof StdLogic)) {
            s0 = String.format("conv_integer(%s)", s0);
        }
        if (!this.arg1.isInteger() && this.arg1.hasFixedBitWidth() && !(this.arg1.getType() instanceof StdLogic)) {
            s1 = String.format("conv_integer(%s)", s1);
        }
        switch (this.op) {
            case AND: 
            case OR: 
            case XOR: {
                s0 = this.arg0.isInteger() ? String.format("conv_std_logic_vector(%s, 32)", this.arg0.getExprAsStr()) : this.arg0.getExprAsStr();
                s1 = this.arg1.isInteger() ? String.format("conv_std_logic_vector(%s, 32)", this.arg1.getExprAsStr()) : this.arg1.getExprAsStr();
                if (this.arg1.getType() instanceof StdLogic || this.arg0.getType() instanceof StdLogic) {
                    return String.format("%s %s %s", new Object[]{s0, this.op, s1});
                }
                return String.format("conv_integer(%s %s %s)", new Object[]{s0, this.op, s1});
            }
            case LSHIFT: {
                if (this.arg0.getType() instanceof StdLogicVector) {
                    StdLogicVector v = (StdLogicVector)this.arg0.getType();
                    return String.format("conv_integer(%s(%s - %s downto 0) & conv_std_logic_vector(0, %s))", this.arg0.getExprAsStr(), v.begin, this.arg1.getExprAsStr(), this.arg1.getExprAsStr());
                }
                return String.format("LSHIFT(arg0, arg1)", new Object[0]);
            }
            case LOGIC_RSHIFT: {
                if (!(this.arg0 instanceof VHDLIdent) || !(this.arg0.getType() instanceof StdLogicVector)) {
                    throw new RuntimeException("SHIFT operation only supports std_logic_vector as arg0");
                }
                if (!(this.arg1 instanceof VHDLLiteral)) {
                    throw new RuntimeException("SHIFT operation only supports literal as arg1");
                }
                StdLogicVector v = (StdLogicVector)this.arg0.getType();
                return String.format("conv_integer(conv_std_logic_vector(0, %s) & %s(%s downto %s))", this.arg1.getExprAsStr(), this.arg0.getExprAsStr(), v.begin, this.arg1);
            }
            case ARITH_RSHIFT: {
                if (!(this.arg0 instanceof VHDLIdent) || !(this.arg0.getType() instanceof StdLogicVector)) {
                    throw new RuntimeException("SHIFT operation only supports std_logic_vector as arg0");
                }
                if (!(this.arg1 instanceof VHDLLiteral)) {
                    throw new RuntimeException("SHIFT operation only supports literal as arg1");
                }
                StdLogicVector v = (StdLogicVector)this.arg0.getType();
                return String.format("conv_integer((%s downto (%s-%s+1) => %s(%s)) & %s(%s downto %s))", v.begin, v.begin, this.arg1.getExprAsStr(), this.arg0.getExprAsStr(), v.begin, this.arg0.getExprAsStr(), v.begin, this.arg1);
            }
            case NONBLOCKING_ASSIGN: {
                return this.stmt.getStmtBody();
            }
            case POINTER_CONNECT: {
                return "-- " + this.arg0 + " <<= " + this.arg1;
            }
        }
        return String.format("%s %s %s", new Object[]{s0, this.op, s1});
    }

    @Override
    public void addSensitivityList(VHDLProcess p) {
        this.arg1.addSensitivityList(p);
        this.arg0.addSensitivityList(p);
    }

    @Override
    public boolean isInteger() {
        return this.op.isArith();
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        if (!(this.arg0 instanceof VHDLIdent && this.op == VHDLOp.NONBLOCKING_ASSIGN || this.op == VHDLOp.BLOCKING_ASSIGN)) {
            if (this.arg0 instanceof VHDLIdent) {
                list.add((VHDLIdent)this.arg0);
            } else if (this.arg0.getSrcIdent() != null) {
                list.addAll(this.arg0.getSrcIdent());
            }
        }
        if (this.arg1 != null) {
            if (this.arg1 instanceof VHDLIdent) {
                list.add((VHDLIdent)this.arg1);
            } else if (this.arg1.getSrcIdent() != null) {
                list.addAll(this.arg1.getSrcIdent());
            }
        }
        return list;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        if (this.arg0 instanceof VHDLIdent && (this.op == VHDLOp.NONBLOCKING_ASSIGN || this.op == VHDLOp.BLOCKING_ASSIGN)) {
            list.add((VHDLIdent)this.arg0);
        }
        if (this.arg0 instanceof VHDLFieldAccess && (this.op == VHDLOp.NONBLOCKING_ASSIGN || this.op == VHDLOp.BLOCKING_ASSIGN)) {
            list.add(((VHDLFieldAccess)this.arg0).ident);
        }
        return list;
    }
}

