/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLNewArray;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;

public class VHDLBlockAssignStmt
extends VHDLStatement
implements VHDLItem {
    final VHDLIdent lhs;
    final VHDLExpr rhs;
    final VHDLProcess p;

    public VHDLBlockAssignStmt(VHDLProcess p, VHDLIdent lhs, VHDLExpr rhs) {
        this.p = p;
        this.lhs = lhs;
        this.rhs = rhs;
        if (rhs instanceof VHDLIdent) {
            p.addSensitive((VHDLIdent)rhs);
        }
    }

    @Override
    public boolean isStepNext() {
        return false;
    }

    @Override
    public String getStmtBody() {
        return String.format("%s := %s", this.lhs, this.rhs);
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        this.writeln(out, String.valueOf(this.getStmtBody()) + ";", offset);
    }

    @Override
    public void connect() {
        this.lhs.connect();
        this.rhs.connect();
        if (this.rhs instanceof VHDLNewArray && this.lhs.var.type instanceof VHDLArrayType) {
            System.out.println("new array as vhdlblock assignstmt");
        }
    }

    @Override
    public void link() {
        super.link();
        this.lhs.link();
        this.rhs.link();
    }

    @Override
    public int state_count() {
        return 0;
    }

    @Override
    public boolean isEndOfState() {
        return false;
    }

    @Override
    public boolean isSkip() {
        return false;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        list.add(this.lhs);
        return list;
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        return this.rhs.getSrcIdent();
    }
}

