/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

public enum VHDLOp {
    POINTER_CONNECT("", "", false),
    NONBLOCKING_ASSIGN("<=", "=", false),
    BLOCKING_ASSIGN(":=", "=", false),
    PLUS("+", "+", true),
    MINUS("-", "-", true),
    MUL("*", "*", true),
    DIV("/", "/", true),
    MOD("%", "%", true),
    COMPEQ("=", "==", true),
    NEQ("/=", "!=", true),
    GT(">", ">", true),
    GEQ(">=", ">=", true),
    LT("<", "<", true),
    LEQ("<=", "<=", true),
    LSHIFT("<<", "<<", true),
    LOGIC_RSHIFT(">>>", ">>>", true),
    ARITH_RSHIFT(">>", ">>", true),
    NOP("", "", false),
    AND("and", "&", true),
    NOT("not", "~", true),
    LAND("and", "&&", true),
    LOR("or", "||", true),
    OR("or", "|", true),
    XOR("xor", "^", true),
    LNOT("not", "!", true),
    INC("++", "++", true);

    private final String vsym;
    private final String jsym;
    private final boolean isArith;

    private VHDLOp(String vsym, String jsym, boolean isArith) {
        this.vsym = vsym;
        this.jsym = jsym;
        this.isArith = isArith;
    }

    public boolean isArith() {
        return this.isArith;
    }

    public String toString() {
        return this.vsym;
    }

    public static VHDLOp getOp(String opName) {
        if (VHDLOp.COMPEQ.jsym.equals(opName)) {
            return COMPEQ;
        }
        if (VHDLOp.GT.jsym.equals(opName)) {
            return GT;
        }
        if (VHDLOp.LT.jsym.equals(opName)) {
            return LT;
        }
        if (VHDLOp.GEQ.jsym.equals(opName)) {
            return GEQ;
        }
        if (VHDLOp.LEQ.jsym.equals(opName)) {
            return LEQ;
        }
        if (VHDLOp.NEQ.jsym.equals(opName)) {
            return NEQ;
        }
        if (VHDLOp.PLUS.jsym.equals(opName)) {
            return PLUS;
        }
        if (VHDLOp.MINUS.jsym.equals(opName)) {
            return MINUS;
        }
        if (VHDLOp.MUL.jsym.equals(opName)) {
            return MUL;
        }
        if (VHDLOp.DIV.jsym.equals(opName)) {
            return DIV;
        }
        if (VHDLOp.MOD.jsym.equals(opName)) {
            return MOD;
        }
        if (VHDLOp.LSHIFT.jsym.equals(opName)) {
            return LSHIFT;
        }
        if (VHDLOp.LOGIC_RSHIFT.jsym.equals(opName)) {
            return LOGIC_RSHIFT;
        }
        if (VHDLOp.ARITH_RSHIFT.jsym.equals(opName)) {
            return ARITH_RSHIFT;
        }
        if (VHDLOp.LNOT.jsym.equals(opName)) {
            return LNOT;
        }
        if (VHDLOp.LAND.jsym.equals(opName)) {
            return LAND;
        }
        if (VHDLOp.LOR.jsym.equals(opName)) {
            return LOR;
        }
        if (VHDLOp.OR.jsym.equals(opName)) {
            return OR;
        }
        if (VHDLOp.XOR.jsym.equals(opName)) {
            return XOR;
        }
        if (VHDLOp.AND.jsym.equals(opName)) {
            return AND;
        }
        if (VHDLOp.NOT.jsym.equals(opName)) {
            return NOT;
        }
        if (VHDLOp.INC.jsym.equals(opName)) {
            return INC;
        }
        throw new RuntimeException("Unsupported operator:" + opName);
    }
}

