/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.opt;

import java.util.ArrayList;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.opt.GraphLog;

public class DataDependencyGraph {
    private ArrayList<Item> items = new ArrayList();
    private ArrayList<Item> rootItems = new ArrayList();
    private ArrayList<Item> readyItems = new ArrayList();
    private GraphLog log;

    public DataDependencyGraph(String id) {
        this.log = new GraphLog(String.valueOf(id) + ".ddg");
    }

    public void addNewItemSequentially(VHDLStatement stmt) {
        Item item = new Item(stmt);
        ArrayList<VHDLIdent> src = stmt.getSrcIdent();
        ArrayList<VHDLIdent> dest = stmt.getDestIdent();
        boolean flag = false;
        for (Item i : this.items) {
            if (!this.isParent(i, src, dest)) continue;
            flag = true;
            item.parents.add(i);
            i.children.add(item);
        }
        if (!flag) {
            this.rootItems.add(item);
            this.readyItems.add(item);
        }
        this.log.add(item.stmt.toString());
        for (Item parent : item.parents) {
            this.log.add(parent.stmt.toString(), item.stmt.toString());
        }
        this.items.add(item);
    }

    private boolean isParent(Item candidate, ArrayList<VHDLIdent> src, ArrayList<VHDLIdent> dest) {
        if (candidate.dest == null) {
            return false;
        }
        if (src != null) {
            for (VHDLIdent i0 : src) {
                for (VHDLIdent i1 : candidate.dest) {
                    if (!i0.sym.equals(i1.sym)) continue;
                    return true;
                }
            }
        }
        if (dest != null) {
            for (VHDLIdent i0 : dest) {
                for (VHDLIdent i1 : candidate.dest) {
                    if (!i0.sym.equals(i1.sym)) continue;
                    return true;
                }
            }
        }
        if (dest != null) {
            for (VHDLIdent i0 : dest) {
                if (candidate.src == null) {
                    return false;
                }
                for (VHDLIdent i1 : candidate.src) {
                    if (!i0.sym.equals(i1.sym)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ArrayList<Item> getReadyItems() {
        return this.readyItems;
    }

    public boolean isReady(Item i) {
        for (Item parent : i.parents) {
            if (parent.isDone()) continue;
            return false;
        }
        return true;
    }

    public void updateReadyItems() {
        for (Item i : this.readyItems) {
            i.setDone(true);
        }
        ArrayList<Item> tmp = new ArrayList<Item>();
        for (Item item : this.readyItems) {
            for (Item i : item.children) {
                if (!this.isReady(i) || i.isDone() || tmp.contains(i)) continue;
                tmp.add(i);
            }
        }
        this.readyItems = tmp;
    }

    public void reset() {
        this.readyItems = this.rootItems;
        for (Item i : this.items) {
            i.setDone(false);
        }
    }

    public class Item {
        final VHDLStatement stmt;
        final ArrayList<VHDLIdent> src;
        final ArrayList<VHDLIdent> dest;
        final ArrayList<Item> parents;
        final ArrayList<Item> children;
        private boolean flag;

        public Item(VHDLStatement stmt) {
            this.stmt = stmt;
            this.parents = new ArrayList();
            this.children = new ArrayList();
            this.src = stmt.getSrcIdent();
            this.dest = stmt.getDestIdent();
            this.flag = false;
        }

        public VHDLStatement getStatement() {
            return this.stmt;
        }

        public void setDone(boolean flag) {
            this.flag = flag;
        }

        public boolean isDone() {
            return this.flag;
        }
    }
}

