/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.List;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.JavaRockComponentInstance;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLNewComponentInstance;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.tools.CompileState;
import net.wasamon.javarock.tools.JavaEntry;
import net.wasamon.javarock.tools.types.ComponentType;
import openjdk.com.sun.tools.javac.code.Symbol;
import openjdk.com.sun.tools.javac.comp.AttrContext;
import openjdk.com.sun.tools.javac.comp.Env;
import openjdk.com.sun.tools.javac.tree.JCTree;

public enum Manager {
    INSTANCE;

    private final Hashtable<String, JavaRockComponentIface> entries = new Hashtable();
    Hashtable<String, JavaRockComponentIface> additional = new Hashtable();
    private CompileState state;

    private boolean isAnnotationDecl(JCTree.JCModifiers mods) {
        return (mods.flags & 0x2000L) == 8192L;
    }

    private boolean isInterfaceDecl(JCTree.JCModifiers mods) {
        return (mods.flags & 0x200L) == 512L;
    }

    private boolean isImplemented(List<JCTree.JCExpression> implementing, String key) {
        for (JCTree.JCExpression expr : implementing) {
            if (expr instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident = (JCTree.JCIdent)expr;
                if (!ident.sym.toString().equals(key)) continue;
                return true;
            }
            if (expr instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)expr;
                if (!fa.sym.toString().equals(key)) continue;
                return true;
            }
            System.out.printf("unknown: %s (%s)\n", expr, expr.getClass());
        }
        return false;
    }

    private JavaRockComponentIface loadVHDLComponentIface(ComponentType type) {
        Object obj = null;
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(type.ident);
            Constructor<?> ct = clazz.getConstructor(String[].class);
            obj = ct.newInstance(new Object[]{type.getArgs()});
            if (!(obj instanceof JavaRockComponentIface)) {
                System.err.printf("unsupported type: %s (%s)", obj, obj.getClass());
                System.exit(0);
            }
            JavaRockComponentIface iface = (JavaRockComponentIface)obj;
            this.additional.put(type.ident, iface);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (JavaRockComponentIface)obj;
    }

    public JavaRockComponentIface getComponentIface(ComponentType type) {
        JavaRockComponentIface iface = this.entries.get(type.ident);
        if (iface == null) {
            iface = this.additional.get(type.ident);
        }
        if (iface == null) {
            iface = this.loadVHDLComponentIface(type);
        }
        if (iface == null) {
            System.err.printf("[%s] source not found: %s\n", ((Object)((Object)this)).getClass(), type.ident);
            System.exit(0);
        }
        return iface;
    }

    public void genNewEntry(Env<AttrContext> env, JCTree.JCClassDecl decl) {
        if (this.isAnnotationDecl(decl.mods)) {
            return;
        }
        if (this.isInterfaceDecl(decl.mods)) {
            return;
        }
        if (this.isImplemented(decl.implementing, "net.wasamon.javarock.model.JavaRockComponentIface")) {
            return;
        }
        Hashtable<String, String> importTable = new Hashtable<String, String>();
        for (Symbol s : ((AttrContext)env.outer.info).getLocalElements()) {
            importTable.put(s.name.toString(), s.toString());
        }
        VHDLModule module = JavaEntry.INSTANCE.buildVHDLModule(decl, this.isImplemented(decl.implementing, "java.lang.Runnable"), importTable);
        this.entries.put(decl.sym.toString(), module);
    }

    public void bypassAll() {
        this.setCompileState(CompileState.BYPASS);
        System.out.println("pass: bypass");
        for (JavaRockComponentIface m : this.entries.values()) {
            for (VHDLPort port : m.getPortArrayList()) {
                if (port.kind != VHDLPort.Kind.EXTERNAL) continue;
                for (JavaRockComponentInstance owner : m.getOwnerList()) {
                    if (!(owner instanceof VHDLNewComponentInstance)) continue;
                    ((VHDLNewComponentInstance)owner).addBypassPort(port);
                }
            }
        }
        for (JavaRockComponentIface m : this.additional.values()) {
            for (VHDLPort port : m.getPortArrayList()) {
                if (port.kind != VHDLPort.Kind.EXTERNAL) continue;
                for (JavaRockComponentInstance owner : m.getOwnerList()) {
                    if (!(owner instanceof VHDLNewComponentInstance)) continue;
                    ((VHDLNewComponentInstance)owner).addBypassPort(port);
                }
            }
        }
    }

    public void parepareAll() {
        this.setCompileState(CompileState.PREPARE);
        System.out.println("pass: prepare");
        for (JavaRockComponentIface m : this.entries.values()) {
            m.prepare();
        }
    }

    public void connectionAll() {
        this.setCompileState(CompileState.CONNECT);
        System.out.println("pass: connection");
        for (JavaRockComponentIface m : this.entries.values()) {
            m.connect();
        }
    }

    public void linkageAll() {
        this.setCompileState(CompileState.LINK);
        System.out.println("pass: linkage");
        for (JavaRockComponentIface m : this.entries.values()) {
            m.link();
        }
    }

    public void optimizationAll() {
        this.setCompileState(CompileState.OPTIMIZE);
        System.out.println("pass: optimization");
        for (JavaRockComponentIface m : this.entries.values()) {
            if (!(m instanceof VHDLModule)) continue;
            ((VHDLModule)m).optimize();
        }
    }

    public void generateAll() {
        this.setCompileState(CompileState.GENERATE);
        System.out.println("pass: generate");
        for (JavaRockComponentIface m : this.entries.values()) {
            try {
                File dest = new File(String.valueOf(m.getName().toLowerCase().replace(".", "_")) + ".vhd");
                PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(dest)), true);
                m.generate(writer, 0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setCompileState(CompileState s) {
        this.state = s;
    }

    public boolean isCompileStatePass(CompileState s) {
        return this.state.isAfter(s);
    }

    public boolean isCompileState(CompileState s) {
        return this.state.isSame(s);
    }
}

