/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.comp;

import openjdk.com.sun.tools.javac.code.Attribute;
import openjdk.com.sun.tools.javac.code.Kinds;
import openjdk.com.sun.tools.javac.code.Symbol;
import openjdk.com.sun.tools.javac.code.Symtab;
import openjdk.com.sun.tools.javac.code.Type;
import openjdk.com.sun.tools.javac.code.Types;
import openjdk.com.sun.tools.javac.comp.Attr;
import openjdk.com.sun.tools.javac.comp.AttrContext;
import openjdk.com.sun.tools.javac.comp.Check;
import openjdk.com.sun.tools.javac.comp.ConstFold;
import openjdk.com.sun.tools.javac.comp.Env;
import openjdk.com.sun.tools.javac.comp.Resolve;
import openjdk.com.sun.tools.javac.tree.JCTree;
import openjdk.com.sun.tools.javac.tree.TreeInfo;
import openjdk.com.sun.tools.javac.tree.TreeMaker;
import openjdk.com.sun.tools.javac.util.Context;
import openjdk.com.sun.tools.javac.util.List;
import openjdk.com.sun.tools.javac.util.ListBuffer;
import openjdk.com.sun.tools.javac.util.Log;
import openjdk.com.sun.tools.javac.util.Names;
import openjdk.com.sun.tools.javac.util.Pair;

public class Annotate {
    protected static final Context.Key<Annotate> annotateKey = new Context.Key();
    final Attr attr;
    final TreeMaker make;
    final Log log;
    final Symtab syms;
    final Names names;
    final Resolve rs;
    final Types types;
    final ConstFold cfolder;
    final Check chk;
    private int enterCount = 0;
    ListBuffer<Annotator> q = new ListBuffer();

    public static Annotate instance(Context context) {
        Annotate instance = context.get(annotateKey);
        if (instance == null) {
            instance = new Annotate(context);
        }
        return instance;
    }

    protected Annotate(Context context) {
        context.put(annotateKey, this);
        this.attr = Attr.instance(context);
        this.make = TreeMaker.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.rs = Resolve.instance(context);
        this.types = Types.instance(context);
        this.cfolder = ConstFold.instance(context);
        this.chk = Check.instance(context);
    }

    public void later(Annotator a) {
        this.q.append(a);
    }

    public void earlier(Annotator a) {
        this.q.prepend(a);
    }

    public void enterStart() {
        ++this.enterCount;
    }

    public void enterDone() {
        --this.enterCount;
        this.flush();
    }

    public void flush() {
        if (this.enterCount != 0) {
            return;
        }
        ++this.enterCount;
        try {
            while (this.q.nonEmpty()) {
                this.q.next().enterAnnotation();
            }
        }
        finally {
            --this.enterCount;
        }
    }

    Attribute.Compound enterAnnotation(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env) {
        Type at = a.annotationType.type != null ? a.annotationType.type : this.attr.attribType(a.annotationType, env);
        a.type = this.chk.checkType(a.annotationType.pos(), at, expected);
        if (a.type.isErroneous()) {
            return new Attribute.Compound(a.type, List.<Pair<Symbol.MethodSymbol, Attribute>>nil());
        }
        if ((a.type.tsym.flags() & 0x2000L) == 0L) {
            this.log.error(a.annotationType.pos(), "not.annotation.type", a.type.toString());
            return new Attribute.Compound(a.type, List.<Pair<Symbol.MethodSymbol, Attribute>>nil());
        }
        List<JCTree.JCExpression> args = a.args;
        if (args.length() == 1 && ((JCTree.JCExpression)args.head).getTag() != 30) {
            args.head = this.make.at(((JCTree.JCExpression)args.head).pos).Assign(this.make.Ident(this.names.value), (JCTree.JCExpression)args.head);
        }
        ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> buf = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
        List<JCTree.JCExpression> tl = args;
        while (tl.nonEmpty()) {
            JCTree.JCExpression t = (JCTree.JCExpression)tl.head;
            if (t.getTag() != 30) {
                this.log.error(t.pos(), "annotation.value.must.be.name.value", new Object[0]);
            } else {
                JCTree.JCAssign assign = (JCTree.JCAssign)t;
                if (assign.lhs.getTag() != 35) {
                    this.log.error(t.pos(), "annotation.value.must.be.name.value", new Object[0]);
                } else {
                    Symbol method;
                    JCTree.JCIdent left = (JCTree.JCIdent)assign.lhs;
                    left.sym = method = this.rs.resolveQualifiedMethod(left.pos(), env, a.type, left.name, List.<Type>nil(), null);
                    left.type = method.type;
                    if (method.owner != a.type.tsym) {
                        this.log.error(left.pos(), "no.annotation.member", left.name, a.type);
                    }
                    Type result = method.type.getReturnType();
                    Attribute value = this.enterAttributeValue(result, assign.rhs, env);
                    if (!method.type.isErroneous()) {
                        buf.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)method, value));
                    }
                    t.type = result;
                }
            }
            tl = tl.tail;
        }
        return new Attribute.Compound(a.type, buf.toList());
    }

    Attribute enterAttributeValue(Type expected, JCTree.JCExpression tree, Env<AttrContext> env) {
        try {
            expected.tsym.complete();
        }
        catch (Symbol.CompletionFailure e) {
            this.log.error(tree.pos(), "cant.resolve", Kinds.kindName(e.sym), e.sym);
            return new Attribute.Error(expected);
        }
        if (expected.isPrimitive() || this.types.isSameType(expected, this.syms.stringType)) {
            Type result = this.attr.attribExpr(tree, env, expected);
            if (result.isErroneous()) {
                return new Attribute.Error(expected);
            }
            if (result.constValue() == null) {
                this.log.error(tree.pos(), "attribute.value.must.be.constant", new Object[0]);
                return new Attribute.Error(expected);
            }
            result = this.cfolder.coerce(result, expected);
            return new Attribute.Constant(expected, result.constValue());
        }
        if (expected.tsym == this.syms.classType.tsym) {
            Type result = this.attr.attribExpr(tree, env, expected);
            if (result.isErroneous()) {
                return new Attribute.Error(expected);
            }
            if (TreeInfo.name(tree) != this.names._class) {
                this.log.error(tree.pos(), "annotation.value.must.be.class.literal", new Object[0]);
                return new Attribute.Error(expected);
            }
            return new Attribute.Class(this.types, ((JCTree.JCFieldAccess)tree).selected.type);
        }
        if ((expected.tsym.flags() & 0x2000L) != 0L) {
            if (tree.getTag() != 44) {
                this.log.error(tree.pos(), "annotation.value.must.be.annotation", new Object[0]);
                expected = this.syms.errorType;
            }
            return this.enterAnnotation((JCTree.JCAnnotation)tree, expected, env);
        }
        if (expected.tag == 11) {
            if (tree.getTag() != 28) {
                tree = this.make.at(tree.pos).NewArray(null, List.<JCTree.JCExpression>nil(), List.of(tree));
            }
            JCTree.JCNewArray na = (JCTree.JCNewArray)tree;
            if (na.elemtype != null) {
                this.log.error(na.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
                return new Attribute.Error(expected);
            }
            ListBuffer<Attribute> buf = new ListBuffer<Attribute>();
            List<JCTree.JCExpression> l = na.elems;
            while (l.nonEmpty()) {
                buf.append(this.enterAttributeValue(this.types.elemtype(expected), (JCTree.JCExpression)l.head, env));
                l = l.tail;
            }
            na.type = expected;
            return new Attribute.Array(expected, buf.toArray(new Attribute[buf.length()]));
        }
        if (expected.tag == 10 && (expected.tsym.flags() & 0x4000L) != 0L) {
            this.attr.attribExpr(tree, env, expected);
            Symbol sym = TreeInfo.symbol(tree);
            if (sym == null || TreeInfo.nonstaticSelect(tree) || sym.kind != 4 || (sym.flags() & 0x4000L) == 0L) {
                this.log.error(tree.pos(), "enum.annotation.must.be.enum.constant", new Object[0]);
                return new Attribute.Error(expected);
            }
            Symbol.VarSymbol enumerator = (Symbol.VarSymbol)sym;
            return new Attribute.Enum(expected, enumerator);
        }
        if (!expected.isErroneous()) {
            this.log.error(tree.pos(), "annotation.value.not.allowable.type", new Object[0]);
        }
        return new Attribute.Error(this.attr.attribExpr(tree, env, expected));
    }

    public static interface Annotator {
        public void enterAnnotation();

        public String toString();
    }
}

