/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.jvm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import openjdk.com.sun.tools.javac.code.Attribute;
import openjdk.com.sun.tools.javac.code.Scope;
import openjdk.com.sun.tools.javac.code.Source;
import openjdk.com.sun.tools.javac.code.Symbol;
import openjdk.com.sun.tools.javac.code.Symtab;
import openjdk.com.sun.tools.javac.code.Type;
import openjdk.com.sun.tools.javac.code.Types;
import openjdk.com.sun.tools.javac.file.BaseFileObject;
import openjdk.com.sun.tools.javac.jvm.CRTable;
import openjdk.com.sun.tools.javac.jvm.ClassFile;
import openjdk.com.sun.tools.javac.jvm.Code;
import openjdk.com.sun.tools.javac.jvm.Pool;
import openjdk.com.sun.tools.javac.jvm.Target;
import openjdk.com.sun.tools.javac.jvm.UninitializedType;
import openjdk.com.sun.tools.javac.main.OptionName;
import openjdk.com.sun.tools.javac.util.Assert;
import openjdk.com.sun.tools.javac.util.ByteBuffer;
import openjdk.com.sun.tools.javac.util.Context;
import openjdk.com.sun.tools.javac.util.List;
import openjdk.com.sun.tools.javac.util.ListBuffer;
import openjdk.com.sun.tools.javac.util.Log;
import openjdk.com.sun.tools.javac.util.Name;
import openjdk.com.sun.tools.javac.util.Names;
import openjdk.com.sun.tools.javac.util.Options;
import openjdk.com.sun.tools.javac.util.Pair;

public class ClassWriter
extends ClassFile {
    protected static final Context.Key<ClassWriter> classWriterKey = new Context.Key();
    private final Symtab syms;
    private final Options options;
    private boolean verbose;
    private boolean scramble;
    private boolean scrambleAll;
    private boolean retrofit;
    private boolean emitSourceFile;
    private boolean genCrt;
    boolean debugstackmap;
    private Target target;
    private Source source;
    private Types types;
    static final int DATA_BUF_SIZE = 65520;
    static final int POOL_BUF_SIZE = 131056;
    ByteBuffer databuf = new ByteBuffer(65520);
    ByteBuffer poolbuf = new ByteBuffer(131056);
    ByteBuffer sigbuf = new ByteBuffer();
    Pool pool;
    Set<Symbol.ClassSymbol> innerClasses;
    ListBuffer<Symbol.ClassSymbol> innerClassesQueue;
    private final Log log;
    private final Names names;
    private final JavaFileManager fileManager;
    static final int SAME_FRAME_SIZE = 64;
    static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
    static final int SAME_FRAME_EXTENDED = 251;
    static final int FULL_FRAME = 255;
    static final int MAX_LOCAL_LENGTH_DIFF = 4;
    private final boolean dumpClassModifiers;
    private final boolean dumpFieldModifiers;
    private final boolean dumpInnerClassModifiers;
    private final boolean dumpMethodModifiers;
    private static final String[] flagName = new String[]{"PUBLIC", "PRIVATE", "PROTECTED", "STATIC", "FINAL", "SUPER", "VOLATILE", "TRANSIENT", "NATIVE", "INTERFACE", "ABSTRACT", "STRICTFP"};
    AttributeWriter awriter = new AttributeWriter();

    public static ClassWriter instance(Context context) {
        ClassWriter instance = context.get(classWriterKey);
        if (instance == null) {
            instance = new ClassWriter(context);
        }
        return instance;
    }

    private ClassWriter(Context context) {
        context.put(classWriterKey, this);
        this.log = Log.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.options = Options.instance(context);
        this.target = Target.instance(context);
        this.source = Source.instance(context);
        this.types = Types.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.verbose = this.options.isSet(OptionName.VERBOSE);
        this.scramble = this.options.isSet("-scramble");
        this.scrambleAll = this.options.isSet("-scrambleAll");
        this.retrofit = this.options.isSet("-retrofit");
        this.genCrt = this.options.isSet(OptionName.XJCOV);
        this.debugstackmap = this.options.isSet("debugstackmap");
        this.emitSourceFile = this.options.isUnset(OptionName.G_CUSTOM) || this.options.isSet(OptionName.G_CUSTOM, "source");
        String dumpModFlags = this.options.get("dumpmodifiers");
        this.dumpClassModifiers = dumpModFlags != null && dumpModFlags.indexOf(99) != -1;
        this.dumpFieldModifiers = dumpModFlags != null && dumpModFlags.indexOf(102) != -1;
        this.dumpInnerClassModifiers = dumpModFlags != null && dumpModFlags.indexOf(105) != -1;
        this.dumpMethodModifiers = dumpModFlags != null && dumpModFlags.indexOf(109) != -1;
    }

    public static String flagNames(long flags) {
        StringBuilder sbuf = new StringBuilder();
        int i = 0;
        long f = flags & 0xFFFL;
        while (f != 0L) {
            if ((f & 1L) != 0L) {
                sbuf.append(" ");
                sbuf.append(flagName[i]);
            }
            f >>= 1;
            ++i;
        }
        return sbuf.toString();
    }

    void putChar(ByteBuffer buf, int op, int x) {
        buf.elems[op] = (byte)(x >> 8 & 0xFF);
        buf.elems[op + 1] = (byte)(x & 0xFF);
    }

    void putInt(ByteBuffer buf, int adr, int x) {
        buf.elems[adr] = (byte)(x >> 24 & 0xFF);
        buf.elems[adr + 1] = (byte)(x >> 16 & 0xFF);
        buf.elems[adr + 2] = (byte)(x >> 8 & 0xFF);
        buf.elems[adr + 3] = (byte)(x & 0xFF);
    }

    void assembleSig(Type type) {
        block0 : switch (type.tag) {
            case 1: {
                this.sigbuf.appendByte(66);
                break;
            }
            case 3: {
                this.sigbuf.appendByte(83);
                break;
            }
            case 2: {
                this.sigbuf.appendByte(67);
                break;
            }
            case 4: {
                this.sigbuf.appendByte(73);
                break;
            }
            case 5: {
                this.sigbuf.appendByte(74);
                break;
            }
            case 6: {
                this.sigbuf.appendByte(70);
                break;
            }
            case 7: {
                this.sigbuf.appendByte(68);
                break;
            }
            case 8: {
                this.sigbuf.appendByte(90);
                break;
            }
            case 9: {
                this.sigbuf.appendByte(86);
                break;
            }
            case 10: {
                this.sigbuf.appendByte(76);
                this.assembleClassSig(type);
                this.sigbuf.appendByte(59);
                break;
            }
            case 11: {
                Type.ArrayType at = (Type.ArrayType)type;
                this.sigbuf.appendByte(91);
                this.assembleSig(at.elemtype);
                break;
            }
            case 12: {
                Type.MethodType mt = (Type.MethodType)type;
                this.sigbuf.appendByte(40);
                this.assembleSig(mt.argtypes);
                this.sigbuf.appendByte(41);
                this.assembleSig(mt.restype);
                if (!this.hasTypeVar(mt.thrown)) break;
                List<Type> l = mt.thrown;
                while (l.nonEmpty()) {
                    this.sigbuf.appendByte(94);
                    this.assembleSig((Type)l.head);
                    l = l.tail;
                }
                break;
            }
            case 15: {
                Type.WildcardType ta = (Type.WildcardType)type;
                switch (ta.kind) {
                    case SUPER: {
                        this.sigbuf.appendByte(45);
                        this.assembleSig(ta.type);
                        break block0;
                    }
                    case EXTENDS: {
                        this.sigbuf.appendByte(43);
                        this.assembleSig(ta.type);
                        break block0;
                    }
                    case UNBOUND: {
                        this.sigbuf.appendByte(42);
                        break block0;
                    }
                }
                throw new AssertionError((Object)ta.kind);
            }
            case 14: {
                this.sigbuf.appendByte(84);
                this.sigbuf.appendName(type.tsym.name);
                this.sigbuf.appendByte(59);
                break;
            }
            case 16: {
                Type.ForAll ft = (Type.ForAll)type;
                this.assembleParamsSig(ft.tvars);
                this.assembleSig(ft.qtype);
                break;
            }
            case 22: 
            case 23: {
                this.assembleSig(this.types.erasure(((UninitializedType)type).qtype));
                break;
            }
            default: {
                throw new AssertionError((Object)("typeSig " + type.tag));
            }
        }
    }

    boolean hasTypeVar(List<Type> l) {
        while (l.nonEmpty()) {
            if (((Type)l.head).tag == 14) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    void assembleClassSig(Type type) {
        Type.ClassType ct = (Type.ClassType)type;
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)ct.tsym;
        this.enterInner(c);
        Type outer = ct.getEnclosingType();
        if (outer.allparams().nonEmpty()) {
            boolean rawOuter = c.owner.kind == 16 || c.name == this.names.empty;
            this.assembleClassSig(rawOuter ? this.types.erasure(outer) : outer);
            this.sigbuf.appendByte(46);
            Assert.check(c.flatname.startsWith(c.owner.enclClass().flatname));
            this.sigbuf.appendName(rawOuter ? c.flatname.subName(c.owner.enclClass().flatname.getByteLength() + 1, c.flatname.getByteLength()) : c.name);
        } else {
            this.sigbuf.appendBytes(ClassWriter.externalize(c.flatname));
        }
        if (((List)ct.getTypeArguments()).nonEmpty()) {
            this.sigbuf.appendByte(60);
            this.assembleSig((List<Type>)ct.getTypeArguments());
            this.sigbuf.appendByte(62);
        }
    }

    void assembleSig(List<Type> types) {
        List<Type> ts = types;
        while (ts.nonEmpty()) {
            this.assembleSig((Type)ts.head);
            ts = ts.tail;
        }
    }

    void assembleParamsSig(List<Type> typarams) {
        this.sigbuf.appendByte(60);
        List<Type> ts = typarams;
        while (ts.nonEmpty()) {
            Type.TypeVar tvar = (Type.TypeVar)ts.head;
            this.sigbuf.appendName(tvar.tsym.name);
            List<Type> bounds = this.types.getBounds(tvar);
            if ((((Type)bounds.head).tsym.flags() & 0x200L) != 0L) {
                this.sigbuf.appendByte(58);
            }
            List<Type> l = bounds;
            while (l.nonEmpty()) {
                this.sigbuf.appendByte(58);
                this.assembleSig((Type)l.head);
                l = l.tail;
            }
            ts = ts.tail;
        }
        this.sigbuf.appendByte(62);
    }

    Name typeSig(Type type) {
        Assert.check(this.sigbuf.length == 0);
        this.assembleSig(type);
        Name n = this.sigbuf.toName(this.names);
        this.sigbuf.reset();
        return n;
    }

    public Name xClassName(Type t) {
        if (t.tag == 10) {
            return this.names.fromUtf(ClassWriter.externalize(t.tsym.flatName()));
        }
        if (t.tag == 11) {
            return this.typeSig(this.types.erasure(t));
        }
        throw new AssertionError((Object)"xClassName");
    }

    void writePool(Pool pool) throws PoolOverflow, StringOverflow {
        int poolCountIdx = this.poolbuf.length;
        this.poolbuf.appendChar(0);
        int i = 1;
        while (i < pool.pp) {
            Object value = pool.pool[i];
            Assert.checkNonNull(value);
            if (value instanceof Pool.Method) {
                value = ((Pool.Method)value).m;
            } else if (value instanceof Pool.Variable) {
                value = ((Pool.Variable)value).v;
            }
            if (value instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol m = (Symbol.MethodSymbol)value;
                this.poolbuf.appendByte((m.owner.flags() & 0x200L) != 0L ? 11 : 10);
                this.poolbuf.appendChar(pool.put(m.owner));
                this.poolbuf.appendChar(pool.put(this.nameType(m)));
            } else if (value instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol v = (Symbol.VarSymbol)value;
                this.poolbuf.appendByte(9);
                this.poolbuf.appendChar(pool.put(v.owner));
                this.poolbuf.appendChar(pool.put(this.nameType(v)));
            } else if (value instanceof Name) {
                this.poolbuf.appendByte(1);
                byte[] bs = ((Name)value).toUtf();
                this.poolbuf.appendChar(bs.length);
                this.poolbuf.appendBytes(bs, 0, bs.length);
                if (bs.length > 65535) {
                    throw new StringOverflow(value.toString());
                }
            } else if (value instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)value;
                if (c.owner.kind == 2) {
                    pool.put(c.owner);
                }
                this.poolbuf.appendByte(7);
                if (c.type.tag == 11) {
                    this.poolbuf.appendChar(pool.put(this.typeSig(c.type)));
                } else {
                    this.poolbuf.appendChar(pool.put(this.names.fromUtf(ClassWriter.externalize(c.flatname))));
                    this.enterInner(c);
                }
            } else if (value instanceof ClassFile.NameAndType) {
                ClassFile.NameAndType nt = (ClassFile.NameAndType)value;
                this.poolbuf.appendByte(12);
                this.poolbuf.appendChar(pool.put(nt.name));
                this.poolbuf.appendChar(pool.put(this.typeSig(nt.type)));
            } else if (value instanceof Integer) {
                this.poolbuf.appendByte(3);
                this.poolbuf.appendInt((Integer)value);
            } else if (value instanceof Long) {
                this.poolbuf.appendByte(5);
                this.poolbuf.appendLong((Long)value);
                ++i;
            } else if (value instanceof Float) {
                this.poolbuf.appendByte(4);
                this.poolbuf.appendFloat(((Float)value).floatValue());
            } else if (value instanceof Double) {
                this.poolbuf.appendByte(6);
                this.poolbuf.appendDouble((Double)value);
                ++i;
            } else if (value instanceof String) {
                this.poolbuf.appendByte(8);
                this.poolbuf.appendChar(pool.put(this.names.fromString((String)value)));
            } else if (value instanceof Type) {
                Type type = (Type)value;
                if (type.tag == 10) {
                    this.enterInner((Symbol.ClassSymbol)type.tsym);
                }
                this.poolbuf.appendByte(7);
                this.poolbuf.appendChar(pool.put(this.xClassName(type)));
            } else {
                Assert.error("writePool " + value);
            }
            ++i;
        }
        if (pool.pp > 65535) {
            throw new PoolOverflow();
        }
        this.putChar(this.poolbuf, poolCountIdx, pool.pp);
    }

    Name fieldName(Symbol sym) {
        if (this.scramble && (sym.flags() & 2L) != 0L || this.scrambleAll && (sym.flags() & 5L) == 0L) {
            return this.names.fromString("_$" + sym.name.getIndex());
        }
        return sym.name;
    }

    ClassFile.NameAndType nameType(Symbol sym) {
        return new ClassFile.NameAndType(this.fieldName(sym), this.retrofit ? sym.erasure(this.types) : sym.externalType(this.types));
    }

    int writeAttr(Name attrName) {
        this.databuf.appendChar(this.pool.put(attrName));
        this.databuf.appendInt(0);
        return this.databuf.length;
    }

    void endAttr(int index) {
        this.putInt(this.databuf, index - 4, this.databuf.length - index);
    }

    int beginAttrs() {
        this.databuf.appendChar(0);
        return this.databuf.length;
    }

    void endAttrs(int index, int count) {
        this.putChar(this.databuf, index - 2, count);
    }

    int writeEnclosingMethodAttribute(Symbol.ClassSymbol c) {
        if (!this.target.hasEnclosingMethodAttribute() || c.owner.kind != 16 && c.name != this.names.empty) {
            return 0;
        }
        int alenIdx = this.writeAttr(this.names.EnclosingMethod);
        Symbol.ClassSymbol enclClass = c.owner.enclClass();
        Symbol.MethodSymbol enclMethod = c.owner.type == null || c.owner.kind != 16 ? null : (Symbol.MethodSymbol)c.owner;
        this.databuf.appendChar(this.pool.put(enclClass));
        this.databuf.appendChar(enclMethod == null ? 0 : this.pool.put(this.nameType(c.owner)));
        this.endAttr(alenIdx);
        return 1;
    }

    int writeFlagAttrs(long flags) {
        int alenIdx;
        int acount = 0;
        if ((flags & 0x20000L) != 0L) {
            alenIdx = this.writeAttr(this.names.Deprecated);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((flags & 0x4000L) != 0L && !this.target.useEnumFlag()) {
            alenIdx = this.writeAttr(this.names.Enum);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((flags & 0x1000L) != 0L && !this.target.useSyntheticFlag()) {
            alenIdx = this.writeAttr(this.names.Synthetic);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((flags & 0x80000000L) != 0L && !this.target.useBridgeFlag()) {
            alenIdx = this.writeAttr(this.names.Bridge);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((flags & 0x400000000L) != 0L && !this.target.useVarargsFlag()) {
            alenIdx = this.writeAttr(this.names.Varargs);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((flags & 0x2000L) != 0L && !this.target.useAnnotationFlag()) {
            alenIdx = this.writeAttr(this.names.Annotation);
            this.endAttr(alenIdx);
            ++acount;
        }
        return acount;
    }

    int writeMemberAttrs(Symbol sym) {
        int acount = this.writeFlagAttrs(sym.flags());
        long flags = sym.flags();
        if (this.source.allowGenerics() && (flags & 0x80001000L) != 4096L && (flags & 0x20000000L) == 0L && (!this.types.isSameType(sym.type, sym.erasure(this.types)) || this.hasTypeVar(sym.type.getThrownTypes()))) {
            int alenIdx = this.writeAttr(this.names.Signature);
            this.databuf.appendChar(this.pool.put(this.typeSig(sym.type)));
            this.endAttr(alenIdx);
            ++acount;
        }
        return acount += this.writeJavaAnnotations((List<Attribute.Compound>)sym.getAnnotationMirrors());
    }

    int writeParameterAttrs(Symbol.MethodSymbol m) {
        ListBuffer<Attribute.Compound> buf;
        boolean hasVisible = false;
        boolean hasInvisible = false;
        if (m.params != null) {
            for (Symbol.VarSymbol s : m.params) {
                for (Attribute.Compound a : s.getAnnotationMirrors()) {
                    switch (this.types.getRetention(a)) {
                        case SOURCE: {
                            break;
                        }
                        case CLASS: {
                            hasInvisible = true;
                            break;
                        }
                        case RUNTIME: {
                            hasVisible = true;
                        }
                    }
                }
            }
        }
        int attrCount = 0;
        if (hasVisible) {
            int attrIndex = this.writeAttr(this.names.RuntimeVisibleParameterAnnotations);
            this.databuf.appendByte(m.params.length());
            for (Symbol.VarSymbol s : m.params) {
                buf = new ListBuffer<Attribute.Compound>();
                for (Attribute.Compound a : s.getAnnotationMirrors()) {
                    if (this.types.getRetention(a) != Attribute.RetentionPolicy.RUNTIME) continue;
                    buf.append(a);
                }
                this.databuf.appendChar(buf.length());
                for (Attribute.Compound a : buf) {
                    this.writeCompoundAttribute(a);
                }
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        if (hasInvisible) {
            int attrIndex = this.writeAttr(this.names.RuntimeInvisibleParameterAnnotations);
            this.databuf.appendByte(m.params.length());
            for (Symbol.VarSymbol s : m.params) {
                buf = new ListBuffer();
                for (Attribute.Compound a : s.getAnnotationMirrors()) {
                    if (this.types.getRetention(a) != Attribute.RetentionPolicy.CLASS) continue;
                    buf.append(a);
                }
                this.databuf.appendChar(buf.length());
                for (Attribute.Compound a : buf) {
                    this.writeCompoundAttribute(a);
                }
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        return attrCount;
    }

    int writeJavaAnnotations(List<Attribute.Compound> attrs) {
        if (attrs.isEmpty()) {
            return 0;
        }
        ListBuffer<Attribute.Compound> visibles = new ListBuffer<Attribute.Compound>();
        ListBuffer<Attribute.Compound> invisibles = new ListBuffer<Attribute.Compound>();
        for (Attribute.Compound a : attrs) {
            switch (this.types.getRetention(a)) {
                case SOURCE: {
                    break;
                }
                case CLASS: {
                    invisibles.append(a);
                    break;
                }
                case RUNTIME: {
                    visibles.append(a);
                }
            }
        }
        int attrCount = 0;
        if (visibles.length() != 0) {
            int attrIndex = this.writeAttr(this.names.RuntimeVisibleAnnotations);
            this.databuf.appendChar(visibles.length());
            for (Attribute.Compound a : visibles) {
                this.writeCompoundAttribute(a);
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        if (invisibles.length() != 0) {
            int attrIndex = this.writeAttr(this.names.RuntimeInvisibleAnnotations);
            this.databuf.appendChar(invisibles.length());
            for (Attribute.Compound a : invisibles) {
                this.writeCompoundAttribute(a);
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        return attrCount;
    }

    void writeCompoundAttribute(Attribute.Compound c) {
        this.databuf.appendChar(this.pool.put(this.typeSig(c.type)));
        this.databuf.appendChar(c.values.length());
        for (Pair<Symbol.MethodSymbol, Attribute> p : c.values) {
            this.databuf.appendChar(this.pool.put(((Symbol.MethodSymbol)p.fst).name));
            ((Attribute)p.snd).accept(this.awriter);
        }
    }

    void enterInner(Symbol.ClassSymbol c) {
        if (c.type.isCompound()) {
            throw new AssertionError((Object)("Unexpected intersection type: " + c.type));
        }
        try {
            c.complete();
        }
        catch (Symbol.CompletionFailure ex) {
            System.err.println("error: " + c + ": " + ex.getMessage());
            throw ex;
        }
        if (c.type.tag != 10) {
            return;
        }
        if (!(this.pool == null || c.owner.enclClass() == null || this.innerClasses != null && this.innerClasses.contains(c))) {
            this.enterInner(c.owner.enclClass());
            this.pool.put(c);
            this.pool.put(c.name);
            if (this.innerClasses == null) {
                this.innerClasses = new HashSet<Symbol.ClassSymbol>();
                this.innerClassesQueue = new ListBuffer();
                this.pool.put(this.names.InnerClasses);
            }
            this.innerClasses.add(c);
            this.innerClassesQueue.append(c);
        }
    }

    void writeInnerClasses() {
        int alenIdx = this.writeAttr(this.names.InnerClasses);
        this.databuf.appendChar(this.innerClassesQueue.length());
        List<Symbol.ClassSymbol> l = this.innerClassesQueue.toList();
        while (l.nonEmpty()) {
            Symbol.ClassSymbol inner = (Symbol.ClassSymbol)l.head;
            char flags = (char)this.adjustFlags(inner.flags_field);
            if ((flags & 0x200) != 0) {
                flags = (char)(flags | 0x400);
            }
            if (inner.name.isEmpty()) {
                flags = (char)(flags & 0xFFFFFFEF);
            }
            if (this.dumpInnerClassModifiers) {
                this.log.errWriter.println("INNERCLASS  " + inner.name);
                this.log.errWriter.println("---" + ClassWriter.flagNames(flags));
            }
            this.databuf.appendChar(this.pool.get(inner));
            this.databuf.appendChar(inner.owner.kind == 2 ? this.pool.get(inner.owner) : 0);
            this.databuf.appendChar(!inner.name.isEmpty() ? this.pool.get(inner.name) : 0);
            this.databuf.appendChar(flags);
            l = l.tail;
        }
        this.endAttr(alenIdx);
    }

    void writeField(Symbol.VarSymbol v) {
        int flags = this.adjustFlags(v.flags());
        this.databuf.appendChar(flags);
        if (this.dumpFieldModifiers) {
            this.log.errWriter.println("FIELD  " + this.fieldName(v));
            this.log.errWriter.println("---" + ClassWriter.flagNames(v.flags()));
        }
        this.databuf.appendChar(this.pool.put(this.fieldName(v)));
        this.databuf.appendChar(this.pool.put(this.typeSig(v.erasure(this.types))));
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (v.getConstValue() != null) {
            int alenIdx = this.writeAttr(this.names.ConstantValue);
            this.databuf.appendChar(this.pool.put(v.getConstValue()));
            this.endAttr(alenIdx);
            ++acount;
        }
        this.endAttrs(acountIdx, acount += this.writeMemberAttrs(v));
    }

    void writeMethod(Symbol.MethodSymbol m) {
        int alenIdx;
        List<Type> thrown;
        int flags = this.adjustFlags(m.flags());
        this.databuf.appendChar(flags);
        if (this.dumpMethodModifiers) {
            this.log.errWriter.println("METHOD  " + this.fieldName(m));
            this.log.errWriter.println("---" + ClassWriter.flagNames(m.flags()));
        }
        this.databuf.appendChar(this.pool.put(this.fieldName(m)));
        this.databuf.appendChar(this.pool.put(this.typeSig(m.externalType(this.types))));
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (m.code != null) {
            int alenIdx2 = this.writeAttr(this.names.Code);
            this.writeCode(m.code);
            m.code = null;
            this.endAttr(alenIdx2);
            ++acount;
        }
        if ((thrown = m.erasure(this.types).getThrownTypes()).nonEmpty()) {
            alenIdx = this.writeAttr(this.names.Exceptions);
            this.databuf.appendChar(thrown.length());
            List<Type> l = thrown;
            while (l.nonEmpty()) {
                this.databuf.appendChar(this.pool.put(((Type)l.head).tsym));
                l = l.tail;
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        if (m.defaultValue != null) {
            alenIdx = this.writeAttr(this.names.AnnotationDefault);
            m.defaultValue.accept(this.awriter);
            this.endAttr(alenIdx);
            ++acount;
        }
        acount += this.writeMemberAttrs(m);
        this.endAttrs(acountIdx, acount += this.writeParameterAttrs(m));
    }

    void writeCode(Code code) {
        int i;
        this.databuf.appendChar(code.max_stack);
        this.databuf.appendChar(code.max_locals);
        this.databuf.appendInt(code.cp);
        this.databuf.appendBytes(code.code, 0, code.cp);
        this.databuf.appendChar(code.catchInfo.length());
        List<Object> l = code.catchInfo.toList();
        while (l.nonEmpty()) {
            int i2 = 0;
            while (i2 < ((char[])l.head).length) {
                this.databuf.appendChar(((char[])l.head)[i2]);
                ++i2;
            }
            l = l.tail;
        }
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (code.lineInfo.nonEmpty()) {
            int alenIdx = this.writeAttr(this.names.LineNumberTable);
            this.databuf.appendChar(code.lineInfo.length());
            List<Object> l2 = code.lineInfo.reverse();
            while (l2.nonEmpty()) {
                i = 0;
                while (i < ((char[])l2.head).length) {
                    this.databuf.appendChar(((char[])l2.head)[i]);
                    ++i;
                }
                l2 = l2.tail;
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        if (this.genCrt && code.crt != null) {
            CRTable crt = code.crt;
            int alenIdx = this.writeAttr(this.names.CharacterRangeTable);
            int crtIdx = this.beginAttrs();
            int crtEntries = crt.writeCRT(this.databuf, code.lineMap, this.log);
            this.endAttrs(crtIdx, crtEntries);
            this.endAttr(alenIdx);
            ++acount;
        }
        int nGenericVars = 0;
        if (code.varBufferSize > 0) {
            int alenIdx = this.writeAttr(this.names.LocalVariableTable);
            this.databuf.appendChar(code.varBufferSize);
            i = 0;
            while (i < code.varBufferSize) {
                Code.LocalVar var = code.varBuffer[i];
                Assert.check(var.start_pc >= '\u0000' && var.start_pc <= code.cp);
                this.databuf.appendChar(var.start_pc);
                Assert.check(var.length >= '\u0000' && var.start_pc + var.length <= code.cp);
                this.databuf.appendChar(var.length);
                Symbol.VarSymbol sym = var.sym;
                this.databuf.appendChar(this.pool.put(sym.name));
                Type vartype = sym.erasure(this.types);
                if (this.needsLocalVariableTypeEntry(sym.type)) {
                    ++nGenericVars;
                }
                this.databuf.appendChar(this.pool.put(this.typeSig(vartype)));
                this.databuf.appendChar(var.reg);
                ++i;
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        if (nGenericVars > 0) {
            int alenIdx = this.writeAttr(this.names.LocalVariableTypeTable);
            this.databuf.appendChar(nGenericVars);
            int count = 0;
            int i3 = 0;
            while (i3 < code.varBufferSize) {
                Code.LocalVar var = code.varBuffer[i3];
                Symbol.VarSymbol sym = var.sym;
                if (this.needsLocalVariableTypeEntry(sym.type)) {
                    ++count;
                    this.databuf.appendChar(var.start_pc);
                    this.databuf.appendChar(var.length);
                    this.databuf.appendChar(this.pool.put(sym.name));
                    this.databuf.appendChar(this.pool.put(this.typeSig(sym.type)));
                    this.databuf.appendChar(var.reg);
                }
                ++i3;
            }
            Assert.check(count == nGenericVars);
            this.endAttr(alenIdx);
            ++acount;
        }
        if (code.stackMapBufferSize > 0) {
            if (this.debugstackmap) {
                System.out.println("Stack map for " + code.meth);
            }
            int alenIdx = this.writeAttr(code.stackMap.getAttributeName(this.names));
            this.writeStackMap(code);
            this.endAttr(alenIdx);
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
    }

    private boolean needsLocalVariableTypeEntry(Type t) {
        return !this.types.isSameType(t, this.types.erasure(t)) && !t.isCompound();
    }

    void writeStackMap(Code code) {
        int nframes = code.stackMapBufferSize;
        if (this.debugstackmap) {
            System.out.println(" nframes = " + nframes);
        }
        this.databuf.appendChar(nframes);
        switch (code.stackMap) {
            case CLDC: {
                int i = 0;
                while (i < nframes) {
                    if (this.debugstackmap) {
                        System.out.print("  " + i + ":");
                    }
                    Code.StackMapFrame frame = code.stackMapBuffer[i];
                    if (this.debugstackmap) {
                        System.out.print(" pc=" + frame.pc);
                    }
                    this.databuf.appendChar(frame.pc);
                    int localCount = 0;
                    int j = 0;
                    while (j < frame.locals.length) {
                        ++localCount;
                        j += this.target.generateEmptyAfterBig() ? 1 : Code.width(frame.locals[j]);
                    }
                    if (this.debugstackmap) {
                        System.out.print(" nlocals=" + localCount);
                    }
                    this.databuf.appendChar(localCount);
                    j = 0;
                    while (j < frame.locals.length) {
                        if (this.debugstackmap) {
                            System.out.print(" local[" + j + "]=");
                        }
                        this.writeStackMapType(frame.locals[j]);
                        j += this.target.generateEmptyAfterBig() ? 1 : Code.width(frame.locals[j]);
                    }
                    int stackCount = 0;
                    int j2 = 0;
                    while (j2 < frame.stack.length) {
                        ++stackCount;
                        j2 += this.target.generateEmptyAfterBig() ? 1 : Code.width(frame.stack[j2]);
                    }
                    if (this.debugstackmap) {
                        System.out.print(" nstack=" + stackCount);
                    }
                    this.databuf.appendChar(stackCount);
                    j2 = 0;
                    while (j2 < frame.stack.length) {
                        if (this.debugstackmap) {
                            System.out.print(" stack[" + j2 + "]=");
                        }
                        this.writeStackMapType(frame.stack[j2]);
                        j2 += this.target.generateEmptyAfterBig() ? 1 : Code.width(frame.stack[j2]);
                    }
                    if (this.debugstackmap) {
                        System.out.println();
                    }
                    ++i;
                }
                break;
            }
            case JSR202: {
                Assert.checkNull(code.stackMapBuffer);
                int i = 0;
                while (i < nframes) {
                    if (this.debugstackmap) {
                        System.out.print("  " + i + ":");
                    }
                    StackMapTableFrame frame = code.stackMapTableBuffer[i];
                    frame.write(this);
                    if (this.debugstackmap) {
                        System.out.println();
                    }
                    ++i;
                }
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected stackmap format value");
            }
        }
    }

    void writeStackMapType(Type t) {
        if (t == null) {
            if (this.debugstackmap) {
                System.out.print("empty");
            }
            this.databuf.appendByte(0);
        } else {
            switch (t.tag) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    if (this.debugstackmap) {
                        System.out.print("int");
                    }
                    this.databuf.appendByte(1);
                    break;
                }
                case 6: {
                    if (this.debugstackmap) {
                        System.out.print("float");
                    }
                    this.databuf.appendByte(2);
                    break;
                }
                case 7: {
                    if (this.debugstackmap) {
                        System.out.print("double");
                    }
                    this.databuf.appendByte(3);
                    break;
                }
                case 5: {
                    if (this.debugstackmap) {
                        System.out.print("long");
                    }
                    this.databuf.appendByte(4);
                    break;
                }
                case 17: {
                    if (this.debugstackmap) {
                        System.out.print("null");
                    }
                    this.databuf.appendByte(5);
                    break;
                }
                case 10: 
                case 11: {
                    if (this.debugstackmap) {
                        System.out.print("object(" + t + ")");
                    }
                    this.databuf.appendByte(7);
                    this.databuf.appendChar(this.pool.put(t));
                    break;
                }
                case 14: {
                    if (this.debugstackmap) {
                        System.out.print("object(" + this.types.erasure((Type)t).tsym + ")");
                    }
                    this.databuf.appendByte(7);
                    this.databuf.appendChar(this.pool.put(this.types.erasure((Type)t).tsym));
                    break;
                }
                case 22: {
                    if (this.debugstackmap) {
                        System.out.print("uninit_this");
                    }
                    this.databuf.appendByte(6);
                    break;
                }
                case 23: {
                    UninitializedType uninitType = (UninitializedType)t;
                    this.databuf.appendByte(8);
                    if (this.debugstackmap) {
                        System.out.print("uninit_object@" + uninitType.offset);
                    }
                    this.databuf.appendChar(uninitType.offset);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    void writeFields(Scope.Entry e) {
        List<Symbol.VarSymbol> vars = List.nil();
        Scope.Entry i = e;
        while (i != null) {
            if (i.sym.kind == 4) {
                vars = vars.prepend((Symbol.VarSymbol)i.sym);
            }
            i = i.sibling;
        }
        while (vars.nonEmpty()) {
            this.writeField((Symbol.VarSymbol)vars.head);
            vars = vars.tail;
        }
    }

    void writeMethods(Scope.Entry e) {
        List<Symbol.MethodSymbol> methods = List.nil();
        Scope.Entry i = e;
        while (i != null) {
            if (i.sym.kind == 16 && (i.sym.flags() & 0x2000000000L) == 0L) {
                methods = methods.prepend((Symbol.MethodSymbol)i.sym);
            }
            i = i.sibling;
        }
        while (methods.nonEmpty()) {
            this.writeMethod((Symbol.MethodSymbol)methods.head);
            methods = methods.tail;
        }
    }

    public JavaFileObject writeClass(Symbol.ClassSymbol c) throws IOException, PoolOverflow, StringOverflow {
        JavaFileObject outFile = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, c.flatname.toString(), JavaFileObject.Kind.CLASS, c.sourcefile);
        OutputStream out = outFile.openOutputStream();
        try {
            this.writeClassFile(out, c);
            if (this.verbose) {
                this.log.printVerbose("wrote.file", outFile);
            }
            out.close();
            out = null;
        }
        finally {
            if (out != null) {
                out.close();
                outFile.delete();
                outFile = null;
            }
        }
        return outFile;
    }

    public void writeClassFile(OutputStream out, Symbol.ClassSymbol c) throws IOException, PoolOverflow, StringOverflow {
        Assert.check((c.flags() & 0x1000000L) == 0L);
        this.databuf.reset();
        this.poolbuf.reset();
        this.sigbuf.reset();
        this.pool = c.pool;
        this.innerClasses = null;
        this.innerClassesQueue = null;
        Type supertype = this.types.supertype(c.type);
        List<Type> interfaces = this.types.interfaces(c.type);
        List<Type> typarams = c.type.getTypeArguments();
        int flags = this.adjustFlags(c.flags());
        if ((flags & 4) != 0) {
            flags |= 1;
        }
        if (((flags = flags & 0x7E11 & 0xFFFFF7FF) & 0x200) == 0) {
            flags |= 0x20;
        }
        if (c.isInner() && c.name.isEmpty()) {
            flags &= 0xFFFFFFEF;
        }
        if (this.dumpClassModifiers) {
            this.log.errWriter.println();
            this.log.errWriter.println("CLASSFILE  " + c.getQualifiedName());
            this.log.errWriter.println("---" + ClassWriter.flagNames(flags));
        }
        this.databuf.appendChar(flags);
        this.databuf.appendChar(this.pool.put(c));
        this.databuf.appendChar(supertype.tag == 10 ? this.pool.put(supertype.tsym) : 0);
        this.databuf.appendChar(interfaces.length());
        List<Type> l = interfaces;
        while (l.nonEmpty()) {
            this.databuf.appendChar(this.pool.put(((Type)l.head).tsym));
            l = l.tail;
        }
        int fieldsCount = 0;
        int methodsCount = 0;
        Scope.Entry e = c.members().elems;
        while (e != null) {
            switch (e.sym.kind) {
                case 4: {
                    ++fieldsCount;
                    break;
                }
                case 16: {
                    if ((e.sym.flags() & 0x2000000000L) != 0L) break;
                    ++methodsCount;
                    break;
                }
                case 2: {
                    this.enterInner((Symbol.ClassSymbol)e.sym);
                    break;
                }
                default: {
                    Assert.error();
                }
            }
            e = e.sibling;
        }
        if (c.trans_local != null) {
            for (Symbol.ClassSymbol local : c.trans_local) {
                this.enterInner(local);
            }
        }
        this.databuf.appendChar(fieldsCount);
        this.writeFields(c.members().elems);
        this.databuf.appendChar(methodsCount);
        this.writeMethods(c.members().elems);
        int acountIdx = this.beginAttrs();
        int acount = 0;
        boolean sigReq = typarams.length() != 0 || supertype.allparams().length() != 0;
        List<Type> l2 = interfaces;
        while (!sigReq && l2.nonEmpty()) {
            sigReq = ((Type)l2.head).allparams().length() != 0;
            l2 = l2.tail;
        }
        if (sigReq) {
            Assert.check(this.source.allowGenerics());
            int alenIdx = this.writeAttr(this.names.Signature);
            if (typarams.length() != 0) {
                this.assembleParamsSig(typarams);
            }
            this.assembleSig(supertype);
            List<Type> l3 = interfaces;
            while (l3.nonEmpty()) {
                this.assembleSig((Type)l3.head);
                l3 = l3.tail;
            }
            this.databuf.appendChar(this.pool.put(this.sigbuf.toName(this.names)));
            this.sigbuf.reset();
            this.endAttr(alenIdx);
            ++acount;
        }
        if (c.sourcefile != null && this.emitSourceFile) {
            int alenIdx = this.writeAttr(this.names.SourceFile);
            String simpleName = BaseFileObject.getSimpleName(c.sourcefile);
            this.databuf.appendChar(c.pool.put(this.names.fromString(simpleName)));
            this.endAttr(alenIdx);
            ++acount;
        }
        if (this.genCrt) {
            int alenIdx = this.writeAttr(this.names.SourceID);
            this.databuf.appendChar(c.pool.put(this.names.fromString(Long.toString(this.getLastModified(c.sourcefile)))));
            this.endAttr(alenIdx);
            ++acount;
            alenIdx = this.writeAttr(this.names.CompilationID);
            this.databuf.appendChar(c.pool.put(this.names.fromString(Long.toString(System.currentTimeMillis()))));
            this.endAttr(alenIdx);
            ++acount;
        }
        acount += this.writeFlagAttrs(c.flags());
        acount += this.writeJavaAnnotations((List<Attribute.Compound>)c.getAnnotationMirrors());
        acount += this.writeEnclosingMethodAttribute(c);
        this.poolbuf.appendInt(-889275714);
        this.poolbuf.appendChar(this.target.minorVersion);
        this.poolbuf.appendChar(this.target.majorVersion);
        this.writePool(c.pool);
        if (this.innerClasses != null) {
            this.writeInnerClasses();
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
        this.poolbuf.appendBytes(this.databuf.elems, 0, this.databuf.length);
        out.write(this.poolbuf.elems, 0, this.poolbuf.length);
        c.pool = null;
        this.pool = null;
    }

    int adjustFlags(long flags) {
        int result = (int)flags;
        if ((flags & 0x1000L) != 0L && !this.target.useSyntheticFlag()) {
            result &= 0xFFFFEFFF;
        }
        if ((flags & 0x4000L) != 0L && !this.target.useEnumFlag()) {
            result &= 0xFFFFBFFF;
        }
        if ((flags & 0x2000L) != 0L && !this.target.useAnnotationFlag()) {
            result &= 0xFFFFDFFF;
        }
        if ((flags & 0x80000000L) != 0L && this.target.useBridgeFlag()) {
            result |= 0x40;
        }
        if ((flags & 0x400000000L) != 0L && this.target.useVarargsFlag()) {
            result |= 0x80;
        }
        return result;
    }

    long getLastModified(FileObject filename) {
        long mod = 0L;
        try {
            mod = filename.getLastModified();
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)("CRT: couldn't get source file modification date: " + e.getMessage()));
        }
        return mod;
    }

    class AttributeWriter
    implements Attribute.Visitor {
        AttributeWriter() {
        }

        @Override
        public void visitConstant(Attribute.Constant _value) {
            Object value = _value.value;
            switch (_value.type.tag) {
                case 1: {
                    ClassWriter.this.databuf.appendByte(66);
                    break;
                }
                case 2: {
                    ClassWriter.this.databuf.appendByte(67);
                    break;
                }
                case 3: {
                    ClassWriter.this.databuf.appendByte(83);
                    break;
                }
                case 4: {
                    ClassWriter.this.databuf.appendByte(73);
                    break;
                }
                case 5: {
                    ClassWriter.this.databuf.appendByte(74);
                    break;
                }
                case 6: {
                    ClassWriter.this.databuf.appendByte(70);
                    break;
                }
                case 7: {
                    ClassWriter.this.databuf.appendByte(68);
                    break;
                }
                case 8: {
                    ClassWriter.this.databuf.appendByte(90);
                    break;
                }
                case 10: {
                    Assert.check(value instanceof String);
                    ClassWriter.this.databuf.appendByte(115);
                    value = ClassWriter.this.names.fromString(value.toString());
                    break;
                }
                default: {
                    throw new AssertionError(_value.type);
                }
            }
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(value));
        }

        @Override
        public void visitEnum(Attribute.Enum e) {
            ClassWriter.this.databuf.appendByte(101);
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(ClassWriter.this.typeSig(e.value.type)));
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(e.value.name));
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            ClassWriter.this.databuf.appendByte(99);
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(ClassWriter.this.typeSig(clazz.type)));
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            ClassWriter.this.databuf.appendByte(64);
            ClassWriter.this.writeCompoundAttribute(compound);
        }

        @Override
        public void visitError(Attribute.Error x) {
            throw new AssertionError(x);
        }

        @Override
        public void visitArray(Attribute.Array array) {
            ClassWriter.this.databuf.appendByte(91);
            ClassWriter.this.databuf.appendChar(array.values.length);
            Attribute[] attributeArray = array.values;
            int n = array.values.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute a = attributeArray[n2];
                a.accept(this);
                ++n2;
            }
        }
    }

    public static class PoolOverflow
    extends Exception {
        private static final long serialVersionUID = 0L;
    }

    static abstract class StackMapTableFrame {
        StackMapTableFrame() {
        }

        abstract int getFrameType();

        void write(ClassWriter writer) {
            int frameType = this.getFrameType();
            writer.databuf.appendByte(frameType);
            if (writer.debugstackmap) {
                System.out.print(" frame_type=" + frameType);
            }
        }

        static StackMapTableFrame getInstance(Code.StackMapFrame this_frame, int prev_pc, Type[] prev_locals, Types types) {
            Type[] locals = this_frame.locals;
            Type[] stack = this_frame.stack;
            int offset_delta = this_frame.pc - prev_pc - 1;
            if (stack.length == 1) {
                if (locals.length == prev_locals.length && StackMapTableFrame.compare(prev_locals, locals, types) == 0) {
                    return new SameLocals1StackItemFrame(offset_delta, stack[0]);
                }
            } else if (stack.length == 0) {
                int diff_length = StackMapTableFrame.compare(prev_locals, locals, types);
                if (diff_length == 0) {
                    return new SameFrame(offset_delta);
                }
                if (-4 < diff_length && diff_length < 0) {
                    Type[] local_diff = new Type[-diff_length];
                    int i = prev_locals.length;
                    int j = 0;
                    while (i < locals.length) {
                        local_diff[j] = locals[i];
                        ++i;
                        ++j;
                    }
                    return new AppendFrame(251 - diff_length, offset_delta, local_diff);
                }
                if (diff_length > 0 && diff_length < 4) {
                    return new ChopFrame(251 - diff_length, offset_delta);
                }
            }
            return new FullFrame(offset_delta, locals, stack);
        }

        static boolean isInt(Type t) {
            return t.tag < 4 || t.tag == 8;
        }

        static boolean isSameType(Type t1, Type t2, Types types) {
            if (t1 == null) {
                return t2 == null;
            }
            if (t2 == null) {
                return false;
            }
            if (StackMapTableFrame.isInt(t1) && StackMapTableFrame.isInt(t2)) {
                return true;
            }
            if (t1.tag == 22) {
                return t2.tag == 22;
            }
            if (t1.tag == 23) {
                if (t2.tag == 23) {
                    return ((UninitializedType)t1).offset == ((UninitializedType)t2).offset;
                }
                return false;
            }
            if (t2.tag == 22 || t2.tag == 23) {
                return false;
            }
            return types.isSameType(t1, t2);
        }

        static int compare(Type[] arr1, Type[] arr2, Types types) {
            int diff_length = arr1.length - arr2.length;
            if (diff_length > 4 || diff_length < -4) {
                return Integer.MAX_VALUE;
            }
            int len = diff_length > 0 ? arr2.length : arr1.length;
            int i = 0;
            while (i < len) {
                if (!StackMapTableFrame.isSameType(arr1[i], arr2[i], types)) {
                    return Integer.MAX_VALUE;
                }
                ++i;
            }
            return diff_length;
        }

        static class AppendFrame
        extends StackMapTableFrame {
            final int frameType;
            final int offsetDelta;
            final Type[] locals;

            AppendFrame(int frameType, int offsetDelta, Type[] locals) {
                this.frameType = frameType;
                this.offsetDelta = offsetDelta;
                this.locals = locals;
            }

            @Override
            int getFrameType() {
                return this.frameType;
            }

            @Override
            void write(ClassWriter writer) {
                super.write(writer);
                writer.databuf.appendChar(this.offsetDelta);
                if (writer.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                }
                int i = 0;
                while (i < this.locals.length) {
                    if (writer.debugstackmap) {
                        System.out.print(" locals[" + i + "]=");
                    }
                    writer.writeStackMapType(this.locals[i]);
                    ++i;
                }
            }
        }

        static class ChopFrame
        extends StackMapTableFrame {
            final int frameType;
            final int offsetDelta;

            ChopFrame(int frameType, int offsetDelta) {
                this.frameType = frameType;
                this.offsetDelta = offsetDelta;
            }

            @Override
            int getFrameType() {
                return this.frameType;
            }

            @Override
            void write(ClassWriter writer) {
                super.write(writer);
                writer.databuf.appendChar(this.offsetDelta);
                if (writer.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                }
            }
        }

        static class FullFrame
        extends StackMapTableFrame {
            final int offsetDelta;
            final Type[] locals;
            final Type[] stack;

            FullFrame(int offsetDelta, Type[] locals, Type[] stack) {
                this.offsetDelta = offsetDelta;
                this.locals = locals;
                this.stack = stack;
            }

            @Override
            int getFrameType() {
                return 255;
            }

            @Override
            void write(ClassWriter writer) {
                super.write(writer);
                writer.databuf.appendChar(this.offsetDelta);
                writer.databuf.appendChar(this.locals.length);
                if (writer.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                    System.out.print(" nlocals=" + this.locals.length);
                }
                int i = 0;
                while (i < this.locals.length) {
                    if (writer.debugstackmap) {
                        System.out.print(" locals[" + i + "]=");
                    }
                    writer.writeStackMapType(this.locals[i]);
                    ++i;
                }
                writer.databuf.appendChar(this.stack.length);
                if (writer.debugstackmap) {
                    System.out.print(" nstack=" + this.stack.length);
                }
                i = 0;
                while (i < this.stack.length) {
                    if (writer.debugstackmap) {
                        System.out.print(" stack[" + i + "]=");
                    }
                    writer.writeStackMapType(this.stack[i]);
                    ++i;
                }
            }
        }

        static class SameFrame
        extends StackMapTableFrame {
            final int offsetDelta;

            SameFrame(int offsetDelta) {
                this.offsetDelta = offsetDelta;
            }

            @Override
            int getFrameType() {
                return this.offsetDelta < 64 ? this.offsetDelta : 251;
            }

            @Override
            void write(ClassWriter writer) {
                super.write(writer);
                if (this.getFrameType() == 251) {
                    writer.databuf.appendChar(this.offsetDelta);
                    if (writer.debugstackmap) {
                        System.out.print(" offset_delta=" + this.offsetDelta);
                    }
                }
            }
        }

        static class SameLocals1StackItemFrame
        extends StackMapTableFrame {
            final int offsetDelta;
            final Type stack;

            SameLocals1StackItemFrame(int offsetDelta, Type stack) {
                this.offsetDelta = offsetDelta;
                this.stack = stack;
            }

            @Override
            int getFrameType() {
                return this.offsetDelta < 64 ? 64 + this.offsetDelta : 247;
            }

            @Override
            void write(ClassWriter writer) {
                super.write(writer);
                if (this.getFrameType() == 247) {
                    writer.databuf.appendChar(this.offsetDelta);
                    if (writer.debugstackmap) {
                        System.out.print(" offset_delta=" + this.offsetDelta);
                    }
                }
                if (writer.debugstackmap) {
                    System.out.print(" stack[0]=");
                }
                writer.writeStackMapType(this.stack);
            }
        }
    }

    public static class StringOverflow
    extends Exception {
        private static final long serialVersionUID = 0L;
        public final String value;

        public StringOverflow(String s) {
            this.value = s;
        }
    }
}

