/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.nio;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import openjdk.com.sun.tools.javac.file.Paths;
import openjdk.com.sun.tools.javac.main.OptionName;
import openjdk.com.sun.tools.javac.nio.PathFileManager;
import openjdk.com.sun.tools.javac.nio.PathFileObject;
import openjdk.com.sun.tools.javac.util.BaseFileManager;
import openjdk.com.sun.tools.javac.util.Context;
import openjdk.com.sun.tools.javac.util.List;
import openjdk.com.sun.tools.javac.util.ListBuffer;

public class JavacPathFileManager
extends BaseFileManager
implements PathFileManager {
    protected FileSystem defaultFileSystem;
    private boolean inited = false;
    private Map<JavaFileManager.Location, PathsForLocation> pathsForLocation;
    private Paths searchPaths;
    private Map<Path, FileSystem> fileSystems;

    public JavacPathFileManager(Context context, boolean register, Charset charset) {
        super(charset);
        if (register) {
            context.put(JavaFileManager.class, this);
        }
        this.pathsForLocation = new HashMap<JavaFileManager.Location, PathsForLocation>();
        this.fileSystems = new HashMap<Path, FileSystem>();
        this.setContext(context);
    }

    @Override
    protected void setContext(Context context) {
        super.setContext(context);
        this.searchPaths = Paths.instance(context);
    }

    @Override
    public FileSystem getDefaultFileSystem() {
        if (this.defaultFileSystem == null) {
            this.defaultFileSystem = FileSystems.getDefault();
        }
        return this.defaultFileSystem;
    }

    @Override
    public void setDefaultFileSystem(FileSystem fs) {
        this.defaultFileSystem = fs;
    }

    @Override
    public void flush() throws IOException {
        this.contentCache.clear();
    }

    @Override
    public void close() throws IOException {
        for (FileSystem fs : this.fileSystems.values()) {
            fs.close();
        }
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        JavacPathFileManager.nullCheck(location);
        Iterable<? extends Path> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        ListBuffer<URL> lb = new ListBuffer<URL>();
        for (Path path2 : path) {
            try {
                lb.append(path2.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.getClassLoader(lb.toArray(new URL[lb.size()]));
    }

    @Override
    public boolean isDefaultBootClassPath() {
        return this.searchPaths.isDefaultBootClassPath();
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.getLocation(location) != null;
    }

    @Override
    public Iterable<? extends Path> getLocation(JavaFileManager.Location location) {
        JavacPathFileManager.nullCheck(location);
        this.lazyInitSearchPaths();
        PathsForLocation path = this.pathsForLocation.get(location);
        if (path == null && !this.pathsForLocation.containsKey(location)) {
            this.setDefaultForLocation(location);
            path = this.pathsForLocation.get(location);
        }
        return path;
    }

    private Path getOutputLocation(JavaFileManager.Location location) {
        Iterable<? extends Path> paths = this.getLocation(location);
        return paths == null ? null : paths.iterator().next();
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends Path> searchPath) throws IOException {
        JavacPathFileManager.nullCheck(location);
        this.lazyInitSearchPaths();
        if (searchPath == null) {
            this.setDefaultForLocation(location);
        } else {
            if (location.isOutputLocation()) {
                this.checkOutputPath(searchPath);
            }
            PathsForLocation pl = new PathsForLocation();
            for (Path path : searchPath) {
                pl.add(path);
            }
            this.pathsForLocation.put(location, pl);
        }
    }

    private void checkOutputPath(Iterable<? extends Path> searchPath) throws IOException {
        Iterator<? extends Path> pathIter = searchPath.iterator();
        if (!pathIter.hasNext()) {
            throw new IllegalArgumentException("empty path for directory");
        }
        Path path = pathIter.next();
        if (pathIter.hasNext()) {
            throw new IllegalArgumentException("path too long for directory");
        }
        if (!JavacPathFileManager.isDirectory(path)) {
            throw new IOException(path + ": not a directory");
        }
    }

    private void setDefaultForLocation(JavaFileManager.Location locn) {
        Collection<File> files = null;
        if (locn instanceof StandardLocation) {
            switch ((StandardLocation)locn) {
                case CLASS_PATH: {
                    files = this.searchPaths.userClassPath();
                    break;
                }
                case PLATFORM_CLASS_PATH: {
                    files = this.searchPaths.bootClassPath();
                    break;
                }
                case SOURCE_PATH: {
                    files = this.searchPaths.sourcePath();
                    break;
                }
                case CLASS_OUTPUT: {
                    String arg = this.options.get(OptionName.D);
                    files = arg == null ? null : Collections.singleton(new File(arg));
                    break;
                }
                case SOURCE_OUTPUT: {
                    String arg = this.options.get(OptionName.S);
                    files = arg == null ? null : Collections.singleton(new File(arg));
                }
            }
        }
        PathsForLocation pl = new PathsForLocation();
        if (files != null) {
            for (File f : files) {
                pl.add(f.toPath());
            }
        }
        this.pathsForLocation.put(locn, pl);
    }

    private void lazyInitSearchPaths() {
        if (!this.inited) {
            this.setDefaultForLocation(StandardLocation.PLATFORM_CLASS_PATH);
            this.setDefaultForLocation(StandardLocation.CLASS_PATH);
            this.setDefaultForLocation(StandardLocation.SOURCE_PATH);
            this.inited = true;
        }
    }

    @Override
    public Path getPath(FileObject fo) {
        JavacPathFileManager.nullCheck(fo);
        if (!(fo instanceof PathFileObject)) {
            throw new IllegalArgumentException();
        }
        return ((PathFileObject)fo).getPath();
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        JavacPathFileManager.nullCheck(a);
        JavacPathFileManager.nullCheck(b);
        if (!(a instanceof PathFileObject)) {
            throw new IllegalArgumentException("Not supported: " + a);
        }
        if (!(b instanceof PathFileObject)) {
            throw new IllegalArgumentException("Not supported: " + b);
        }
        return ((PathFileObject)a).isSameFile((PathFileObject)b);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        JavacPathFileManager.nullCheck(packageName);
        JavacPathFileManager.nullCheck(kinds);
        Iterable<? extends Path> paths = this.getLocation(location);
        if (paths == null) {
            return List.nil();
        }
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        for (Path path : paths) {
            this.list(path, packageName, kinds, recurse, results);
        }
        return results.toList();
    }

    private void list(Path path, String packageName, final Set<JavaFileObject.Kind> kinds, boolean recurse, final ListBuffer<JavaFileObject> results) throws IOException {
        Path packageDir;
        Path pathDir;
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (JavacPathFileManager.isDirectory(path)) {
            pathDir = path;
        } else {
            FileSystem fs = this.getFileSystem(path);
            if (fs == null) {
                return;
            }
            pathDir = fs.getRootDirectories().iterator().next();
        }
        String sep = path.getFileSystem().getSeparator();
        Path path2 = packageDir = packageName.isEmpty() ? pathDir : pathDir.resolve(packageName.replace(".", sep));
        if (!Files.exists(packageDir, new LinkOption[0])) {
            return;
        }
        int maxDepth = recurse ? Integer.MAX_VALUE : 1;
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(packageDir, opts, maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Path name = dir.getFileName();
                if (name == null || SourceVersion.isIdentifier(name.toString())) {
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (attrs.isRegularFile() && kinds.contains((Object)JavacPathFileManager.getKind(file.getFileName().toString()))) {
                    PathFileObject fe = PathFileObject.createDirectoryPathFileObject(JavacPathFileManager.this, file, pathDir);
                    results.append(fe);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Iterable<? extends Path> paths) {
        ArrayList<PathFileObject> result = paths instanceof Collection ? new ArrayList(((Collection)paths).size()) : new ArrayList<PathFileObject>();
        for (Path path : paths) {
            result.add(PathFileObject.createSimplePathFileObject(this, JavacPathFileManager.nullCheck(path)));
        }
        return result;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... paths) {
        return this.getJavaFileObjectsFromPaths(Arrays.asList(JavacPathFileManager.nullCheck(paths)));
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.getFileForInput(location, JavacPathFileManager.getRelativePath(className, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.getFileForInput(location, JavacPathFileManager.getRelativePath(packageName, relativeName));
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, String relativePath) throws IOException {
        for (Path path : this.getLocation(location)) {
            Path file;
            if (JavacPathFileManager.isDirectory(path)) {
                Path f = JavacPathFileManager.resolve(path, relativePath);
                if (!Files.exists(f, new LinkOption[0])) continue;
                return PathFileObject.createDirectoryPathFileObject(this, f, path);
            }
            FileSystem fs = this.getFileSystem(path);
            if (fs == null || !Files.exists(file = JavacPathFileManager.getPath(fs, relativePath), new LinkOption[0])) continue;
            return PathFileObject.createJarPathFileObject(this, file);
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return this.getFileForOutput(location, JavacPathFileManager.getRelativePath(className, kind), sibling);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.getFileForOutput(location, JavacPathFileManager.getRelativePath(packageName, relativeName), sibling);
    }

    private JavaFileObject getFileForOutput(JavaFileManager.Location location, String relativePath, FileObject sibling) {
        Path dir = this.getOutputLocation(location);
        if (dir == null) {
            if (location == StandardLocation.CLASS_OUTPUT) {
                Path siblingDir = null;
                if (sibling != null && sibling instanceof PathFileObject) {
                    siblingDir = ((PathFileObject)sibling).getPath().getParent();
                }
                return PathFileObject.createSiblingPathFileObject(this, siblingDir.resolve(JavacPathFileManager.getBaseName(relativePath)), relativePath);
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                dir = this.getOutputLocation(StandardLocation.CLASS_OUTPUT);
            }
        }
        if (dir != null) {
            Path file = JavacPathFileManager.resolve(dir, relativePath);
            return PathFileObject.createDirectoryPathFileObject(this, file, dir);
        }
        Path file = JavacPathFileManager.getPath(this.getDefaultFileSystem(), relativePath);
        return PathFileObject.createSimplePathFileObject(this, file);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject fo) {
        JavacPathFileManager.nullCheck(fo);
        Iterable<? extends Path> paths = this.getLocation(location);
        if (paths == null) {
            return null;
        }
        if (!(fo instanceof PathFileObject)) {
            throw new IllegalArgumentException(fo.getClass().getName());
        }
        return ((PathFileObject)fo).inferBinaryName(paths);
    }

    private FileSystem getFileSystem(Path p) throws IOException {
        FileSystem fs = this.fileSystems.get(p);
        if (fs == null) {
            fs = FileSystems.newFileSystem(p, null);
            this.fileSystems.put(p, fs);
        }
        return fs;
    }

    private static String getRelativePath(String className, JavaFileObject.Kind kind) {
        return String.valueOf(className.replace(".", "/")) + kind.extension;
    }

    private static String getRelativePath(String packageName, String relativeName) {
        return String.valueOf(packageName.replace(".", "/")) + relativeName;
    }

    private static String getBaseName(String relativePath) {
        int lastSep = relativePath.lastIndexOf("/");
        return relativePath.substring(lastSep + 1);
    }

    private static boolean isDirectory(Path path) throws IOException {
        BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        return attrs.isDirectory();
    }

    private static Path getPath(FileSystem fs, String relativePath) {
        return fs.getPath(relativePath.replace("/", fs.getSeparator()), new String[0]);
    }

    private static Path resolve(Path base, String relativePath) {
        FileSystem fs = base.getFileSystem();
        Path rp = fs.getPath(relativePath.replace("/", fs.getSeparator()), new String[0]);
        return base.resolve(rp);
    }

    private static class PathsForLocation
    extends LinkedHashSet<Path> {
        private static final long serialVersionUID = 6788510222394486733L;

        private PathsForLocation() {
        }
    }
}

