/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.processing;

import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import openjdk.com.sun.tools.javac.model.JavacElements;
import openjdk.com.sun.tools.javac.processing.JavacProcessingEnvironment;
import openjdk.com.sun.tools.javac.tree.JCTree;
import openjdk.com.sun.tools.javac.util.Context;
import openjdk.com.sun.tools.javac.util.JCDiagnostic;
import openjdk.com.sun.tools.javac.util.Log;
import openjdk.com.sun.tools.javac.util.Pair;

public class JavacMessager
implements Messager {
    Log log;
    JavacProcessingEnvironment processingEnv;
    int errorCount = 0;
    int warningCount = 0;

    JavacMessager(Context context, JavacProcessingEnvironment processingEnv) {
        this.log = Log.instance(context);
        this.processingEnv = processingEnv;
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg) {
        this.printMessage(kind, msg, null, null, null);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e) {
        this.printMessage(kind, msg, e, null, null);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a) {
        this.printMessage(kind, msg, e, a, null);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a, AnnotationValue v) {
        JavaFileObject oldSource = null;
        JavaFileObject newSource = null;
        JCDiagnostic.DiagnosticPosition pos = null;
        JavacElements elemUtils = this.processingEnv.getElementUtils();
        Pair<JCTree, JCTree.JCCompilationUnit> treeTop = elemUtils.getTreeAndTopLevel(e, a, v);
        if (treeTop != null && (newSource = ((JCTree.JCCompilationUnit)treeTop.snd).sourcefile) != null) {
            oldSource = this.log.useSource(newSource);
            pos = ((JCTree)treeTop.fst).pos();
        }
        try {
            switch (kind) {
                case ERROR: {
                    ++this.errorCount;
                    boolean prev = this.log.multipleErrors;
                    this.log.multipleErrors = true;
                    try {
                        this.log.error(pos, "proc.messager", msg.toString());
                        break;
                    }
                    finally {
                        this.log.multipleErrors = prev;
                    }
                }
                case WARNING: {
                    ++this.warningCount;
                    this.log.warning(pos, "proc.messager", msg.toString());
                    break;
                }
                case MANDATORY_WARNING: {
                    ++this.warningCount;
                    this.log.mandatoryWarning(pos, "proc.messager", msg.toString());
                    break;
                }
                default: {
                    this.log.note(pos, "proc.messager", msg.toString());
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            if (oldSource != null) {
                this.log.useSource(oldSource);
            }
            throw throwable;
        }
        if (oldSource != null) {
            this.log.useSource(oldSource);
        }
    }

    public void printError(String msg) {
        this.printMessage(Diagnostic.Kind.ERROR, msg);
    }

    public void printWarning(String msg) {
        this.printMessage(Diagnostic.Kind.WARNING, msg);
    }

    public void printNotice(String msg) {
        this.printMessage(Diagnostic.Kind.NOTE, msg);
    }

    public boolean errorRaised() {
        return this.errorCount > 0;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public void newRound(Context context) {
        this.log = Log.instance(context);
        this.errorCount = 0;
    }

    public String toString() {
        return "javac Messager";
    }
}

