/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.sym;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import openjdk.com.sun.tools.javac.Main;
import openjdk.com.sun.tools.javac.api.JavacTaskImpl;
import openjdk.com.sun.tools.javac.code.Attribute;
import openjdk.com.sun.tools.javac.code.Scope;
import openjdk.com.sun.tools.javac.code.Symbol;
import openjdk.com.sun.tools.javac.code.Symtab;
import openjdk.com.sun.tools.javac.code.Type;
import openjdk.com.sun.tools.javac.jvm.ClassReader;
import openjdk.com.sun.tools.javac.jvm.ClassWriter;
import openjdk.com.sun.tools.javac.jvm.Pool;
import openjdk.com.sun.tools.javac.processing.JavacProcessingEnvironment;
import openjdk.com.sun.tools.javac.util.List;
import openjdk.com.sun.tools.javac.util.Pair;

@SupportedOptions(value={"openjdk.com.sun.tools.javac.sym.Jar", "openjdk.com.sun.tools.javac.sym.Dest"})
@SupportedAnnotationTypes(value={"*"})
public class CreateSymbols
extends AbstractProcessor {
    static Set<String> getLegacyPackages() {
        ResourceBundle legacyBundle = ResourceBundle.getBundle("openjdk.com.sun.tools.javac.resources.legacy");
        HashSet<String> keys = new HashSet<String>();
        Enumeration<String> e = legacyBundle.getKeys();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        return keys;
    }

    @Override
    public boolean process(Set<? extends TypeElement> tes, RoundEnvironment renv) {
        try {
            if (renv.processingOver()) {
                this.createSymbols();
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause == null) {
                cause = t;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, cause.getLocalizedMessage());
        }
        return true;
    }

    void createSymbols() throws IOException {
        Set<String> legacy = CreateSymbols.getLegacyPackages();
        Set<String> legacyProprietary = CreateSymbols.getLegacyPackages();
        HashSet<String> documented = new HashSet<String>();
        Set<Symbol.PackageSymbol> packages = ((JavacProcessingEnvironment)this.processingEnv).getSpecifiedPackages();
        String jarName = this.processingEnv.getOptions().get("openjdk.com.sun.tools.javac.sym.Jar");
        if (jarName == null) {
            throw new RuntimeException("Must use -Aopenjdk.com.sun.tools.javac.sym.Jar=LOCATION_OF_JAR");
        }
        String destName = this.processingEnv.getOptions().get("openjdk.com.sun.tools.javac.sym.Dest");
        if (destName == null) {
            throw new RuntimeException("Must use -Aopenjdk.com.sun.tools.javac.sym.Dest=LOCATION_OF_JAR");
        }
        for (Symbol.PackageSymbol psym : packages) {
            String name = psym.getQualifiedName().toString();
            legacyProprietary.remove(name);
            documented.add(name);
        }
        JavaCompiler tool = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fm = tool.getStandardFileManager(null, null, null);
        JavaFileManager.Location jarLocation = StandardLocation.locationFor(jarName);
        File jarFile = new File(jarName);
        fm.setLocation(jarLocation, List.of(jarFile));
        fm.setLocation(StandardLocation.CLASS_PATH, List.nil());
        fm.setLocation(StandardLocation.SOURCE_PATH, List.nil());
        ArrayList<File> bootClassPath = new ArrayList<File>();
        bootClassPath.add(jarFile);
        for (File file : fm.getLocation(StandardLocation.PLATFORM_CLASS_PATH)) {
            if (new File(file.getName()).equals(new File("rt.jar"))) continue;
            bootClassPath.add(file);
        }
        System.err.println("Using boot class path = " + bootClassPath);
        fm.setLocation(StandardLocation.PLATFORM_CLASS_PATH, bootClassPath);
        File destDir = new File(destName);
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new RuntimeException("Could not create " + destDir);
        }
        fm.setLocation(StandardLocation.CLASS_OUTPUT, List.of(destDir));
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> crisp = new HashSet<String>();
        List<String> options = List.of("-XDdev");
        JavacTaskImpl task = (JavacTaskImpl)tool.getTask(null, fm, null, options, null, null);
        openjdk.com.sun.tools.javac.main.JavaCompiler compiler = openjdk.com.sun.tools.javac.main.JavaCompiler.instance(task.getContext());
        ClassReader reader = ClassReader.instance(task.getContext());
        ClassWriter writer = ClassWriter.instance(task.getContext());
        Symtab syms = Symtab.instance(task.getContext());
        Attribute.Compound proprietary = new Attribute.Compound(syms.proprietaryType, List.<Pair<Symbol.MethodSymbol, Attribute>>nil());
        Type.moreInfo = true;
        Pool pool = new Pool();
        for (JavaFileObject file : fm.list(jarLocation, "", EnumSet.of(JavaFileObject.Kind.CLASS), true)) {
            String className = fm.inferBinaryName(jarLocation, file);
            int index = className.lastIndexOf(46);
            String pckName = index == -1 ? "" : className.substring(0, index);
            boolean addLegacyAnnotation = false;
            if (documented.contains(pckName)) {
                if (!legacy.contains(pckName)) {
                    crisp.add(pckName);
                }
            } else if (legacyProprietary.contains(pckName)) {
                addLegacyAnnotation = true;
            } else {
                hashSet.add(pckName);
                continue;
            }
            Symbol.TypeSymbol sym = (Symbol.TypeSymbol)compiler.resolveIdent(className);
            if (sym.kind != 2) {
                if (className.indexOf(36) >= 0) continue;
                System.err.println("Ignoring (other) " + className + " : " + sym);
                System.err.println("   " + sym.getClass().getSimpleName() + " " + sym.type);
                continue;
            }
            sym.complete();
            if (((Symbol)sym.getEnclosingElement()).getKind() != ElementKind.PACKAGE) {
                System.err.println("Ignoring (bad) " + sym.getQualifiedName());
                continue;
            }
            Symbol.ClassSymbol cs = (Symbol.ClassSymbol)sym;
            if (addLegacyAnnotation) {
                cs.attributes_field = cs.attributes_field == null ? List.of(proprietary) : cs.attributes_field.prepend(proprietary);
            }
            this.writeClass(pool, cs, writer);
        }
    }

    void writeClass(Pool pool, Symbol.ClassSymbol cs, ClassWriter writer) throws IOException {
        try {
            pool.reset();
            cs.pool = pool;
            writer.writeClass(cs);
            Scope.Entry e = cs.members().elems;
            while (e != null) {
                if (e.sym.kind == 2) {
                    Symbol.ClassSymbol nestedClass = (Symbol.ClassSymbol)e.sym;
                    nestedClass.complete();
                    this.writeClass(pool, nestedClass, writer);
                }
                e = e.sibling;
            }
        }
        catch (ClassWriter.StringOverflow ex) {
            throw new RuntimeException(ex);
        }
        catch (ClassWriter.PoolOverflow ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public static void main(String ... args) {
        String rt_jar = args[0];
        String dest = args[1];
        args = new String[]{"-Xbootclasspath:" + rt_jar, "-XDprocess.packages", "-proc:only", "-processor", "openjdk.com.sun.tools.javac.sym.CreateSymbols", "-Aopenjdk.com.sun.tools.javac.sym.Jar=" + rt_jar, "-Aopenjdk.com.sun.tools.javac.sym.Dest=" + dest, "java.applet", "java.awt", "java.awt.color", "java.awt.datatransfer", "java.awt.dnd", "java.awt.event", "java.awt.font", "java.awt.geom", "java.awt.im", "java.awt.im.spi", "java.awt.image", "java.awt.image.renderable", "java.awt.print", "java.beans", "java.beans.beancontext", "java.io", "java.lang", "java.lang.annotation", "java.lang.instrument", "java.lang.management", "java.lang.ref", "java.lang.reflect", "java.math", "java.net", "java.nio", "java.nio.channels", "java.nio.channels.spi", "java.nio.charset", "java.nio.charset.spi", "java.rmi", "java.rmi.activation", "java.rmi.dgc", "java.rmi.registry", "java.rmi.server", "java.security", "java.security.acl", "java.security.cert", "java.security.interfaces", "java.security.spec", "java.sql", "java.text", "java.text.spi", "java.util", "java.util.concurrent", "java.util.concurrent.atomic", "java.util.concurrent.locks", "java.util.jar", "java.util.logging", "java.util.prefs", "java.util.regex", "java.util.spi", "java.util.zip", "javax.accessibility", "javax.activation", "javax.activity", "javax.annotation", "javax.annotation.processing", "javax.crypto", "javax.crypto.interfaces", "javax.crypto.spec", "javax.imageio", "javax.imageio.event", "javax.imageio.metadata", "javax.imageio.plugins.jpeg", "javax.imageio.plugins.bmp", "javax.imageio.spi", "javax.imageio.stream", "javax.jws", "javax.jws.soap", "javax.lang.model", "javax.lang.model.element", "javax.lang.model.type", "javax.lang.model.util", "javax.management", "javax.management.loading", "javax.management.monitor", "javax.management.relation", "javax.management.openmbean", "javax.management.timer", "javax.management.modelmbean", "javax.management.remote", "javax.management.remote.rmi", "javax.naming", "javax.naming.directory", "javax.naming.event", "javax.naming.ldap", "javax.naming.spi", "javax.net", "javax.net.ssl", "javax.print", "javax.print.attribute", "javax.print.attribute.standard", "javax.print.event", "javax.rmi", "javax.rmi.CORBA", "javax.rmi.ssl", "javax.script", "javax.security.auth", "javax.security.auth.callback", "javax.security.auth.kerberos", "javax.security.auth.login", "javax.security.auth.spi", "javax.security.auth.x500", "javax.security.cert", "javax.security.sasl", "javax.sound.sampled", "javax.sound.sampled.spi", "javax.sound.midi", "javax.sound.midi.spi", "javax.sql", "javax.sql.rowset", "javax.sql.rowset.serial", "javax.sql.rowset.spi", "javax.swing", "javax.swing.border", "javax.swing.colorchooser", "javax.swing.filechooser", "javax.swing.event", "javax.swing.table", "javax.swing.text", "javax.swing.text.html", "javax.swing.text.html.parser", "javax.swing.text.rtf", "javax.swing.tree", "javax.swing.undo", "javax.swing.plaf", "javax.swing.plaf.basic", "javax.swing.plaf.metal", "javax.swing.plaf.multi", "javax.swing.plaf.synth", "javax.tools", "javax.transaction", "javax.transaction.xa", "javax.xml.parsers", "javax.xml.bind", "javax.xml.bind.annotation", "javax.xml.bind.annotation.adapters", "javax.xml.bind.attachment", "javax.xml.bind.helpers", "javax.xml.bind.util", "javax.xml.soap", "javax.xml.ws", "javax.xml.ws.handler", "javax.xml.ws.handler.soap", "javax.xml.ws.http", "javax.xml.ws.soap", "javax.xml.ws.spi", "javax.xml.transform", "javax.xml.transform.sax", "javax.xml.transform.dom", "javax.xml.transform.stax", "javax.xml.transform.stream", "javax.xml", "javax.xml.crypto", "javax.xml.crypto.dom", "javax.xml.crypto.dsig", "javax.xml.crypto.dsig.dom", "javax.xml.crypto.dsig.keyinfo", "javax.xml.crypto.dsig.spec", "javax.xml.datatype", "javax.xml.validation", "javax.xml.namespace", "javax.xml.xpath", "javax.xml.stream", "javax.xml.stream.events", "javax.xml.stream.util", "org.ietf.jgss", "org.omg.CORBA", "org.omg.CORBA.DynAnyPackage", "org.omg.CORBA.ORBPackage", "org.omg.CORBA.TypeCodePackage", "org.omg.stub.java.rmi", "org.omg.CORBA.portable", "org.omg.CORBA_2_3", "org.omg.CORBA_2_3.portable", "org.omg.CosNaming", "org.omg.CosNaming.NamingContextExtPackage", "org.omg.CosNaming.NamingContextPackage", "org.omg.SendingContext", "org.omg.PortableServer", "org.omg.PortableServer.CurrentPackage", "org.omg.PortableServer.POAPackage", "org.omg.PortableServer.POAManagerPackage", "org.omg.PortableServer.ServantLocatorPackage", "org.omg.PortableServer.portable", "org.omg.PortableInterceptor", "org.omg.PortableInterceptor.ORBInitInfoPackage", "org.omg.Messaging", "org.omg.IOP", "org.omg.IOP.CodecFactoryPackage", "org.omg.IOP.CodecPackage", "org.omg.Dynamic", "org.omg.DynamicAny", "org.omg.DynamicAny.DynAnyPackage", "org.omg.DynamicAny.DynAnyFactoryPackage", "org.w3c.dom", "org.w3c.dom.events", "org.w3c.dom.bootstrap", "org.w3c.dom.ls", "org.xml.sax", "org.xml.sax.ext", "org.xml.sax.helpers", "openjdk.com.sun.java.browser.dom", "org.w3c.dom", "org.w3c.dom.bootstrap", "org.w3c.dom.ls", "org.w3c.dom.ranges", "org.w3c.dom.traversal", "org.w3c.dom.html", "org.w3c.dom.stylesheets", "org.w3c.dom.css", "org.w3c.dom.events", "org.w3c.dom.views", "openjdk.com.sun.management", "openjdk.com.sun.security.auth", "openjdk.com.sun.security.auth.callback", "openjdk.com.sun.security.auth.login", "openjdk.com.sun.security.auth.module", "openjdk.com.sun.security.jgss", "openjdk.com.sun.net.httpserver", "openjdk.com.sun.net.httpserver.spi", "javax.smartcardio"};
        Main.compile(args);
    }
}

