package net.wasamon.blokus.javarock;
import net.wasamon.javarock.libraries.VHDLSimpleLibrary;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLGenericParameter;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
public class BlokusPatternSymTable extends VHDLSimpleLibrary implements JavaRockComponentIface{
  public byte[] data = new byte[]{
(byte)0x61, (byte)0x62, (byte)0x63, (byte)0x64, (byte)0x65, (byte)0x66, (byte)0x67, (byte)0x68, (byte)0x69, (byte)0x6a, (byte)0x6b, (byte)0x6c, (byte)0x6d, (byte)0x6e, (byte)0x6f, (byte)0x70, (byte)0x71, (byte)0x72, (byte)0x73, (byte)0x74, (byte)0x75
};
  public BlokusPatternSymTable(String... args){
    super("vhdl_block_pattern_sym_table", args);
    ports.add(new VHDLPort(this, "clk",     VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "reset",   VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_raddr", VHDLTypeBuilder.getStdLogicVector(31, 0), VHDLPort.Dir.IN));
    ports.add(new VHDLPort(this, "data_rdata", VHDLTypeBuilder.getStdLogicVector(7, 0), VHDLPort.Dir.OUT));
  }
}
