package net.wasamon.blokus.javarock;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JPanel;

import net.wasamon.blokus.Board;

public class BoardPanel extends JPanel{
	
	private final int WIDTH = 640;
	private final int HEIGHT = 640;
	
	private final int MARGIN = 5;
	private final int SIZE = 40;
	
	private BlokusBoard board;
	
	private final Color SKYBLUE = new Color(150, 150, 250);
	
	public BoardPanel(BlokusBoard b){
		super();
		this.setPreferredSize(new Dimension(WIDTH, HEIGHT));
		this.board = b;
	}
	
	private int posX(int x){
		return x * SIZE + MARGIN;
	}

	private int posY(int y){
		return y * SIZE + MARGIN;
	}
	
	private void paintBoard(Graphics g){
		for(int i = 0; i <= Board.ROWS; i++){
			g.drawLine(MARGIN, MARGIN + i * SIZE, MARGIN + SIZE * Board.COLS, MARGIN + i * SIZE);
		}
		for(int i = 0; i <= Board.COLS; i++){
			g.drawLine(MARGIN + i * SIZE, MARGIN, MARGIN + i * SIZE, MARGIN + Board.ROWS * SIZE);
		}
	}
	
	private void paintPlayer(Graphics g){
		for(int i = 0; i < Board.COLS; i++){
			for(int j = 0; j < Board.ROWS; j++){
				int c = board.get(i, j);
				if(c == Board.BLUE){
					g.setColor(SKYBLUE);
					g.fillRect(posX(i), posY(j), SIZE, SIZE);
				}else if(c == Board.ORANGE){
					g.setColor(Color.ORANGE);
					g.fillRect(posX(i), posY(j), SIZE, SIZE);
				}
				g.setColor(Color.BLACK);
				if(c != Board.NONE){
					g.drawChars(new char[]{(char)(board.getSym(i, j))}, 0, 1, posX(i)+6, posY(j) + 16);
				}
			}
		}
	}
	
	public void paintComponent(Graphics g){
		super.paintComponent(g);
		paintPlayer(g);
		paintBoard(g);
	}
	
}