library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;
entity net_wasamon_blokus_javarock_rs232c is
  port (
    notify_method_busy : OUT std_logic;
    write_method_busy : OUT std_logic;
    tx_dout : OUT std_logic;
    read_method_busy : OUT std_logic;
    output_port_read : OUT std_logic_vector(7 downto 0);
    rx_din : IN std_logic;
    notify_method_request : IN std_logic;
    input_port_write_data : IN std_logic_vector(7 downto 0);
    write_method_request : IN std_logic;
    reset : IN std_logic;
    read_method_request : IN std_logic;
    clk : IN std_logic
  );
end net_wasamon_blokus_javarock_rs232c;

architecture RTL of net_wasamon_blokus_javarock_rs232c is
  component rs232c_rx
    generic (
      sys_clk : integer := 14000000;
      rate : integer := 9600
    );
    port (
      clk : IN std_logic;
      reset : IN std_logic;
      din : IN std_logic;
      rd : OUT std_logic;
      dout : OUT std_logic_vector(7 downto 0)
    );
  end component;
  component rs232c_tx
    generic (
      sys_clk : integer := 14000000;
      rate : integer := 9600
    );
    port (
      clk : IN std_logic;
      reset : IN std_logic;
      wr : IN std_logic;
      din : IN std_logic_vector(7 downto 0);
      dout : OUT std_logic;
      ready : OUT std_logic
    );
  end component;
  constant rx_sys_clk : integer := 100000000;
  constant tx_sys_clk : integer := 100000000;
  constant tx_rate : integer := 115200;
  constant rx_rate : integer := 115200;
  signal tx_wr_field_wdata_reset : std_logic := '0';
  signal tx_wr_field_wdata_reset_strobe : std_logic := '0';
  signal tx_wr_field_wdata_writer_write_method_state : std_logic := '0';
  signal tx_wr_field_wdata_writer_strobe_write_method_state : std_logic := '0';
  signal tx_wr_field_rdata : std_logic := '0';
  signal tx_wr_field_wdata : std_logic := '0';
  signal rx_dout_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal rx_dout_field_wdata_reset_strobe : std_logic := '0';
  signal rx_dout_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal rx_dout_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal this_wait_method_request_field_wdata_reset : std_logic := '0';
  signal this_wait_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_wait_method_request_field_rdata : std_logic := '0';
  signal this_wait_method_request_field_wdata : std_logic := '0';
  signal rx_rd_field_wdata_reset : std_logic := '0';
  signal rx_rd_field_wdata_reset_strobe : std_logic := '0';
  signal rx_rd_field_rdata : std_logic := '0';
  signal rx_rd_field_wdata : std_logic := '0';
  signal tx_din_field_wdata_reset : std_logic_vector(7 downto 0) := (others => '0');
  signal tx_din_field_wdata_reset_strobe : std_logic := '0';
  signal tx_din_field_wdata_writer_write_method_state : std_logic_vector(7 downto 0) := (others => '0');
  signal tx_din_field_wdata_writer_strobe_write_method_state : std_logic := '0';
  signal tx_din_field_rdata : std_logic_vector(7 downto 0) := (others => '0');
  signal tx_din_field_wdata : std_logic_vector(7 downto 0) := (others => '0');
  signal tx_ready_field_wdata_reset : std_logic := '0';
  signal tx_ready_field_wdata_reset_strobe : std_logic := '0';
  signal tx_ready_field_rdata : std_logic := '0';
  signal tx_ready_field_wdata : std_logic := '0';
  signal this_read_method_request : std_logic := '0';
  signal this_wait_method_busy : std_logic := '0';
  signal this_notify_method_request : std_logic := '0';
  signal write_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_read_read_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal wait_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_read_read_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_read_read_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal read_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal this_notify_method_busy : std_logic := '0';
  signal this_write_method_busy : std_logic := '0';
  signal d_notify_flag : std_logic := '0';
  signal this_input_port_write_data : std_logic_vector(7 downto 0) := (others => '0');
  signal notify_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_wait_wait_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_write_write_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal notify_flag : std_logic := '0';
  signal state_counter_write_write_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_write_method_request : std_logic := '0';
  signal this_read_method_busy : std_logic := '0';
  signal state_counter_notify_notify_0 : std_logic_vector(31 downto 0) := (others => '0');
begin
  U_tx : rs232c_tx
  generic map(
    sys_clk => tx_sys_clk,
    rate => tx_rate
  )
  port map(
    clk => clk,
    reset => reset,
    wr => tx_wr_field_rdata,
    din => tx_din_field_rdata,
    dout => tx_dout,
    ready => tx_ready_field_wdata
  );
  U_rx : rs232c_rx
  generic map(
    sys_clk => rx_sys_clk,
    rate => rx_rate
  )
  port map(
    clk => clk,
    reset => reset,
    din => rx_din,
    rd => rx_rd_field_wdata,
    dout => rx_dout_field_wdata
  );
  this_notify_method_request <= notify_method_request;
  notify_method_busy <= this_notify_method_busy;
  this_read_method_request <= read_method_request;
  read_method_busy <= this_read_method_busy;
  this_input_port_write_data <= conv_std_logic_vector(conv_integer(input_port_write_data), this_input_port_write_data'length);
  this_write_method_request <= write_method_request;
  write_method_busy <= this_write_method_busy;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        tx_wr_field_wdata <= tx_wr_field_wdata_reset;
      elsif (tx_wr_field_wdata_reset_strobe = '1') then
        tx_wr_field_wdata <= tx_wr_field_wdata_reset;
      elsif (tx_wr_field_wdata_writer_strobe_write_method_state = '1') then
        tx_wr_field_wdata <= tx_wr_field_wdata_writer_write_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        tx_wr_field_wdata_reset_strobe <= '1';
      else
        tx_wr_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(write_method_state) = 4 or conv_integer(write_method_state) = 5) then
        tx_wr_field_wdata_writer_strobe_write_method_state <= '1';
      else
        tx_wr_field_wdata_writer_strobe_write_method_state <= '0';
      end if;
    end if;
  end process;
  tx_wr_field_rdata <= tx_wr_field_wdata_reset when (reset = '1') else
        tx_wr_field_wdata_reset when (tx_wr_field_wdata_reset_strobe = '1') else
        tx_wr_field_wdata_writer_write_method_state when (tx_wr_field_wdata_writer_strobe_write_method_state = '1') else
        tx_wr_field_wdata;
  
  rx_dout_field_rdata <= rx_dout_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      elsif (this_wait_method_request_field_wdata_reset_strobe = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata_reset_strobe <= '1';
      else
        this_wait_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  this_wait_method_request_field_rdata <= this_wait_method_request_field_wdata_reset when (reset = '1') else
        this_wait_method_request_field_wdata_reset when (this_wait_method_request_field_wdata_reset_strobe = '1') else
        this_wait_method_request_field_wdata;
  
  rx_rd_field_rdata <= rx_rd_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        tx_din_field_wdata <= tx_din_field_wdata_reset;
      elsif (tx_din_field_wdata_reset_strobe = '1') then
        tx_din_field_wdata <= tx_din_field_wdata_reset;
      elsif (tx_din_field_wdata_writer_strobe_write_method_state = '1') then
        tx_din_field_wdata <= tx_din_field_wdata_writer_write_method_state;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        tx_din_field_wdata_reset_strobe <= '1';
      else
        tx_din_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(write_method_state) = 3) then
        tx_din_field_wdata_writer_strobe_write_method_state <= '1';
      else
        tx_din_field_wdata_writer_strobe_write_method_state <= '0';
      end if;
    end if;
  end process;
  tx_din_field_rdata <= tx_din_field_wdata_reset when (reset = '1') else
        tx_din_field_wdata_reset when (tx_din_field_wdata_reset_strobe = '1') else
        tx_din_field_wdata_writer_write_method_state when (tx_din_field_wdata_writer_strobe_write_method_state = '1') else
        tx_din_field_wdata;
  
  tx_ready_field_rdata <= tx_ready_field_wdata;
  process(clk) --notify
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        notify_flag <= '0';
        this_notify_method_busy <= '0';
        notify_method_state <= (others => '0');
        state_counter_notify_notify_0 <= (others => '0');
      else
        case conv_integer(notify_method_state) is
          when 0 =>
            if(this_notify_method_request = '1') then
              this_notify_method_busy <= '1';
              notify_method_state <= notify_method_state + 1;
            else
              this_notify_method_busy <= '0';
            end if;
          when 1 =>
            if(this_notify_method_request = '0') then
              notify_method_state <= notify_method_state + 1;
            end if;
          when 2 => 
            notify_flag <= '1';
            notify_method_state <= notify_method_state + 1;
          when 3 => 
            notify_flag <= '0';
            notify_method_state <= notify_method_state + 1;
          when 4 =>
            this_notify_method_busy <= '0';
            notify_method_state <= (others => '0');
          when others => notify_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --notify
  process(clk) --write
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_write_write_0 <= (others => '0');
        state_counter_write_write_1 <= (others => '0');
        this_write_method_busy <= '0';
        write_method_state <= (others => '0');
        tx_din_field_wdata_reset <= (others => '0');
        tx_wr_field_wdata_reset <= '0';
      else
        case conv_integer(write_method_state) is
          when 0 =>
            if(this_write_method_request = '1') then
              this_write_method_busy <= '1';
              write_method_state <= write_method_state + 1;
            else
              this_write_method_busy <= '0';
            end if;
          when 1 =>
            if(this_write_method_request = '0') then
              write_method_state <= write_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(state_counter_write_write_1) is
              when 0 => state_counter_write_write_1 <= state_counter_write_write_1 + 1;
              when 1 =>
                if (tx_ready_field_rdata = '0') then
                  state_counter_write_write_1 <= state_counter_write_write_1 + 1;
                else
                  write_method_state <= write_method_state + 1;
                  state_counter_write_write_1 <= (others => '0');
                end if;
              when 2 =>
                state_counter_write_write_1 <= (others => '0');
              when others => state_counter_write_write_1 <= (others => '0');
            end case;
          when 3 => 
            tx_din_field_wdata_writer_write_method_state <= conv_std_logic_vector(conv_integer(input_port_write_data), tx_din_field_wdata'length);
            write_method_state <= write_method_state + 1;
          when 4 => 
            tx_wr_field_wdata_writer_write_method_state <= '1';
            write_method_state <= write_method_state + 1;
          when 5 => 
            tx_wr_field_wdata_writer_write_method_state <= '0';
            write_method_state <= write_method_state + 1;
          when 6 =>
            this_write_method_busy <= '0';
            write_method_state <= (others => '0');
          when others => write_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --write
  process(clk) --read
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_read_read_0 <= (others => '0');
        state_counter_read_read_1 <= (others => '0');
        state_counter_read_read_2 <= (others => '0');
        this_read_method_busy <= '0';
        read_method_state <= (others => '0');
        output_port_read <= (others => '0');
      else
        case conv_integer(read_method_state) is
          when 0 =>
            if(this_read_method_request = '1') then
              this_read_method_busy <= '1';
              read_method_state <= read_method_state + 1;
            else
              this_read_method_busy <= '0';
            end if;
          when 1 =>
            if(this_read_method_request = '0') then
              read_method_state <= read_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(state_counter_read_read_1) is
              when 0 => state_counter_read_read_1 <= state_counter_read_read_1 + 1;
              when 1 =>
                if (rx_rd_field_rdata /= '0') then
                  state_counter_read_read_1 <= state_counter_read_read_1 + 1;
                else
                  read_method_state <= read_method_state + 1;
                  state_counter_read_read_1 <= (others => '0');
                end if;
              when 2 =>
                state_counter_read_read_1 <= (others => '0');
              when others => state_counter_read_read_1 <= (others => '0');
            end case;
          when 3 => 
            case conv_integer(state_counter_read_read_2) is
              when 0 => state_counter_read_read_2 <= state_counter_read_read_2 + 1;
              when 1 =>
                if (rx_rd_field_rdata /= '1') then
                  state_counter_read_read_2 <= state_counter_read_read_2 + 1;
                else
                  read_method_state <= read_method_state + 1;
                  state_counter_read_read_2 <= (others => '0');
                end if;
              when 2 =>
                state_counter_read_read_2 <= (others => '0');
              when others => state_counter_read_read_2 <= (others => '0');
            end case;
          when 4 => 
            output_port_read <= conv_std_logic_vector(conv_integer(rx_dout_field_rdata), output_port_read'length);
            read_method_state <= (others => '0');
          when 5 =>
            this_read_method_busy <= '0';
            read_method_state <= (others => '0');
          when others => read_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --read
  process(clk) --wait
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        d_notify_flag <= '0';
        this_wait_method_busy <= '0';
        wait_method_state <= (others => '0');
        state_counter_wait_wait_0 <= (others => '0');
      else
        case conv_integer(wait_method_state) is
          when 0 =>
            if(this_wait_method_request_field_rdata = '1') then
              this_wait_method_busy <= '1';
              wait_method_state <= wait_method_state + 1;
            else
              this_wait_method_busy <= '0';
            end if;
          when 1 =>
            if(this_wait_method_request_field_rdata = '0') then
              wait_method_state <= wait_method_state + 1;
            end if;
          when 2 => 
            if (d_notify_flag = '0' and notify_flag = '1') then
              wait_method_state <= wait_method_state + 1;
            else
              d_notify_flag <= notify_flag;
            end if;
          when 3 =>
            this_wait_method_busy <= '0';
            wait_method_state <= (others => '0');
          when others => wait_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --wait
end RTL;
