library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;

entity top is
  port (
    CLK     : IN  std_logic;
    RESET   : IN  std_logic;
    UART_TX : OUT std_logic;
    UART_RX : IN  std_logic;
    LED     : out std_logic_vector(7 downto 0)
  );
end top;

architecture RTL of top is

  component net_wasamon_blokus_javarock_gameagent
    port (
      notify_method_busy    : OUT std_logic;
      output_port_led_out   : OUT std_logic_vector(31 downto 0);
      io_obj_tx_dout        : OUT std_logic;
      notify_method_request : IN  std_logic;
      io_obj_rx_din         : IN  std_logic;
      reset                 : IN  std_logic;
      player_code_input     : IN  std_logic_vector(31 downto 0);
      clk                   : IN  std_logic
      );
  end component;
  
  constant TEAM_CODE : std_logic_vector(31 downto 0) := X"00000031";

  signal CLK100M : std_logic;
  
  signal sReset  : std_logic := '1';
  signal reset_d : std_logic_vector(5 downto 0) := (others => '1');

  signal led_out : std_logic_vector(31 downto 0);

begin  -- RTL

  CLK100M <= CLK;

  LED <= led_out(7 downto 0);
  
  process (CLK100M, RESET)
  begin  -- process
    if RESET = '0' then
      reset_d <= (others => '1');
    elsif CLK100M'event and CLK100M = '1' then  -- rising clock edge
      reset_d <= reset_d(4 downto 0) & '0';
    end if;
  end process;
  sReset <= reset_d(5);

  U : net_wasamon_blokus_javarock_gameagent
    port map(
      notify_method_busy    => open,
      io_obj_tx_dout        => UART_TX,
      notify_method_request => '0',
      io_obj_rx_din         => UART_RX,
      reset                 => sRESET,
      player_code_input     => TEAM_CODE,
      clk                   => CLK100M,
      output_port_led_out   => led_out
      );

end RTL;

