package net.wasamon.blokus.javarock;

import net.wasamon.javarock.rt.auto;
import net.wasamon.javarock.rt.combination;
import net.wasamon.javarock.rt.javarockhdl;
import net.wasamon.javarock.rt.unsynthesizable;

@javarockhdl
public class GameAgent {
	
	private final IO io = new IO(); 
	
	private final SimplePlayer player = new SimplePlayer();
	
	private final INPUT32 player_code = new INPUT32();
	private final LED led = new LED();
	
	private byte codeH, codeL;
	private int turn_code;
	
	private final byte[] buffer = new byte[8];
	
	private void init(){
		int v = player_code.value;
		codeH = (byte)((v >>> 8) & 0x000000FF);
		codeL = (byte)(v & 0x000000FF);
		player.init();
	}
	
	private void doInitialization(){
		while(true){
			byte c = io.getchar();
			if(c == '0'){
				break;
			}
		}
		io.putchar((byte)'1'); // RESPONSE CODE
		io.putchar(codeH);
		io.putchar(codeL);
	}
	
	private byte toStr(int v){
		if(v < 10){
			return (byte)(v + '0');
		}else{
			return (byte)((v-10) + 'a');
		}
	}
	
	private int toInt(byte x){
		if('0' <= x && x <= '9'){
			return x - '0';
		}else if('a' <= x && x <= 'f'){
			return (x - 'a') + 10;
		}else if('A' <= x && x <= 'F'){
			return (x - 'A') + 10;
		}else{ // error!!
			return -1;
		}
	}
	
	private void sendResponse(int code){
		byte x, y, id, rot;
		if(code == -1){
			io.putchar((byte)'0');
			io.putchar((byte)'0');
			io.putchar((byte)'0');
			io.putchar((byte)'0');
		}else{
			x   = toStr(((code >>> 24) & 0x000000FF) + 1); // convert value into 1-origin
			y   = toStr(((code >>> 16) & 0x000000FF) + 1); // convert value into 1-origin
			id  = (byte)(((code >>> 8) & 0x000000FF) + 'a');
			rot = toStr(code & 0x000000FF);
			io.putchar(x);
			io.putchar(y);
			io.putchar(id);
			io.putchar(rot);
		}
		return;
	}
	
	private int doFirstMove(){
		byte c;
		int code, pos = 0;
		c = io.getchar();
		if(c != '2'){
			// Error !!
		}
		c = io.getchar();
		if(c == '5'){
			player.setTurnCode(1);
			turn_code = 1;
			pos = 5;
		}else if(c == 'A'){
			player.setTurnCode(2);
			turn_code = 2;
			pos = 10;
		}else{
			// Error !!
		}
		code = player.getFirstMoveCode(pos-1, pos-1); // convert value into 0-origin
		return code;
	}
	
	private boolean waitResponseCode(byte expected, int args){
		byte c;
		c = io.getchar();
		if(c == '9'){ return false;	} // The game has been terminated.
		if(c != expected){
			// Error !!
		}
		for(int i = 0; i < args; i++){
			c = io.getchar();
			buffer[i] = c;
		}
		return true;
	}
	
	private void parseAndApply(int offset){
		int x, y, id, rot;
		x   = toInt(buffer[offset+0]);
		y   = toInt(buffer[offset+1]);
		id  = buffer[offset+2] - 'a';
		rot = toInt(buffer[offset+3]);
		if(x > 0 && y > 0){ // if x == 0 || y == 0, invalid move or pass 
			player.setOpponentMove(x-1, y-1, id, rot);  // convert value into 0-origin
		}
	}

	private void game(){
		int code;
		boolean flag = true;
		init();
		doInitialization();
		code = doFirstMove();
		sendResponse(code);
		if(turn_code == 2){ // receive response code "4"
			flag = waitResponseCode((byte)'4', 8);
			parseAndApply(0);
			parseAndApply(4);
		}else{ // receive response code "3"
			flag = waitResponseCode((byte)'3', 4);
			parseAndApply(0);
		}
		// game main routine
		while(flag){
			code = player.getNextMove();
			sendResponse(code);
			flag = waitResponseCode((byte)'3', 4);
			parseAndApply(0);
		}
		return;
	}
	
	@auto
	public void fpga_main(){
			led.start();
		while(true){
			game();
		}
	}
	
	@combination
	public int led_out(){
		return led.value;
	}
	
	@unsynthesizable
	public SimplePlayer getPlayer(){
		return player;
	}

}
