package net.wasamon.blokus.javarock.tools;


public class BlokusDuoPatternGen extends RomGenerator{
	
	public static final int MAX_NUM_OF_POINTS = 5;
	public static final int NUM_OF_PATTERNS = 8;
	
	public BlokusDuoPatternGen(int width, int num){
		super("BlokusPatternTable", "vhdl_block_pattern_table", width, num);
	}
	
	private static String convBitVector(int v){
		String s = "";
		switch(v){
		case 0:  s = "000"; break;
		case 1:  s = "001"; break;
		case 2:  s = "010"; break;
		case -1: s = "111"; break;
		case -2: s = "110"; break;
		default:
			System.err.println("[Error]: " + v + " is out-of-bound.");
			System.exit(0);
		}
		
		return s;
	}
	
	private static String convBitVector(Point[] p){
		String s = "";
		String sep = "";
		for(int i = 0; i < MAX_NUM_OF_POINTS; i++){
			if(i < p.length){
				s += sep + "\"" + "00" + convBitVector(p[i].x) + convBitVector(p[i].y) + "\"";
			}else{
				s += sep + "\"11111111\""; // invalid mark
			}
			sep = ", ";
		}
		return s;
	}
	
	public static void main(String... args){
		Player p = new Player();
		String contents = "";
		String sep = "";
		for(BlokusObject o: p.obj){
			for(int i = 0; i < NUM_OF_PATTERNS; i++){
				contents += sep + convBitVector(o.getPattern(i));
				sep = ",\n";
			}
		}
		BlokusDuoPatternGen gen = new BlokusDuoPatternGen(8, ('u'-'a'+1) * MAX_NUM_OF_POINTS * NUM_OF_PATTERNS);
		gen.genVHDL(contents);
		gen.genJava("net.wasamon.blokus.javarock", contents);
		
	}
	

}
