package net.wasamon.blokus.javarock.tools;


public class BlokusObject {
	
	private final String name;
	private final BlokusPattern[] patterns;
	
	public BlokusObject(String name, Point[] points){
		this.name = name;
		patterns = new BlokusPattern[8];

		patterns[0] = new BlokusPattern(points, 1,  0, false);
		patterns[1] = new BlokusPattern(points, 1,  0, true );
		patterns[2] = new BlokusPattern(points, 0,  1, false);
		patterns[3] = new BlokusPattern(points, 0,  1, true );
		patterns[4] = new BlokusPattern(points, -1, 0, false);
		patterns[5] = new BlokusPattern(points, -1, 0, true );
		patterns[6] = new BlokusPattern(points, 0, -1, false);
		patterns[7] = new BlokusPattern(points, 0, -1, true );
		
		System.out.println(name);
		for(BlokusPattern p: patterns){
			System.out.println(" " + p);
		}
	}

	public Point[] getPattern(int index){
		return patterns[index].pattern;
	}
	
	public String getName(){
		return name;
	}
	
	public String getBasePattern(){
		return patterns[0].toString();
	}


}

class BlokusPattern{
	
	Point[] pattern;
	
	public BlokusPattern(Point[] points, int rotX, int rotY, boolean mirror){
		pattern = new Point[points.length];
		for(int i = 0; i < points.length; i++){
			int x = points[i].x * rotX - points[i].y * rotY;
			int y = points[i].x * rotY + points[i].y * rotX;
			pattern[i] = new Point(mirror ? -x : x, y);
		}
	}
	
	public String toString(){
		String s = "";
		for(Point p: pattern){
			s += " (" + p.x + ", " + p.y + ")";
		}
		return s;
	}
	
	
}
