/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mailer.driver;

import java.io.IOException;
import java.util.Properties;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.driver.MessageData;

public class IMAPClient {
    private final String protocol = "imap";
    private Session session;
    private Store store;
    private static IMAPClient instance = new IMAPClient();
    private ClientData currentClientData;
    private Folder currentFolder;
    MessageData lastData;
    int currentId = -1;

    public static IMAPClient getInstance() {
        return instance;
    }

    private IMAPClient() {
        Properties props = System.getProperties();
        this.session = Session.getDefaultInstance((Properties)props, null);
    }

    public Store getStore(ClientData data) throws MessagingException {
        if (this.store == null) {
            this.store = this.session.getStore("imap");
        }
        if (!data.equals(this.currentClientData)) {
            this.store.close();
            this.currentClientData = data;
        }
        if (!this.store.isConnected()) {
            this.store.connect(this.currentClientData.host, this.currentClientData.port, this.currentClientData.user, this.currentClientData.password);
        }
        return this.store;
    }

    public Message[] getFolderMessages(Folder folder) throws MessagingException {
        Message[] msgs = folder.getMessages();
        FetchProfile fp = new FetchProfile();
        fp.add(FetchProfile.Item.ENVELOPE);
        fp.add(FetchProfile.Item.FLAGS);
        fp.add("X-Mailer");
        folder.fetch(msgs, fp);
        return msgs;
    }

    public boolean isConnected() {
        return this.store.isConnected();
    }

    public Folder openFolder(ClientData data, String mbox) throws MessagingException {
        if (this.currentFolder == null || !this.currentFolder.getName().equals(mbox)) {
            Folder folder = this.getStore(data).getDefaultFolder();
            if (mbox == null) {
                mbox = "INBOX";
            }
            this.currentFolder = folder.getFolder(mbox);
        }
        if (!this.currentFolder.isOpen()) {
            try {
                this.currentFolder.open(2);
            }
            catch (MessagingException messagingException) {
                this.currentFolder.open(1);
            }
        }
        return this.currentFolder;
    }

    public void closeFolder(boolean flag) throws MessagingException {
        if (this.currentFolder.isOpen()) {
            this.currentFolder.close(flag);
        }
    }

    public void close(boolean flag) throws MessagingException {
        this.closeFolder(flag);
        this.store.close();
    }

    public String getFlagString(Message msg) throws MessagingException {
        StringBuffer sb = new StringBuffer();
        Flags flags = msg.getFlags();
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        boolean isSeenFlag = false;
        int i = 0;
        while (i < sf.length) {
            block16: {
                block11: {
                    Flags.Flag f;
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        f = sf[i];
                                        if (f != Flags.Flag.ANSWERED) break block10;
                                        sb.append("A");
                                        break block11;
                                    }
                                    if (f != Flags.Flag.DELETED) break block12;
                                    sb.append("D");
                                    break block11;
                                }
                                if (f != Flags.Flag.DRAFT) break block13;
                                sb.append("T");
                                break block11;
                            }
                            if (f != Flags.Flag.FLAGGED) break block14;
                            sb.append("F");
                            break block11;
                        }
                        if (f != Flags.Flag.RECENT) break block15;
                        sb.append("N");
                        break block11;
                    }
                    if (f != Flags.Flag.SEEN) break block16;
                    isSeenFlag = true;
                    sb.append(" ");
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                }
            }
            ++i;
        }
        if (!isSeenFlag) {
            sb.append("U");
        }
        String[] uf = flags.getUserFlags();
        int i2 = 0;
        while (i2 < uf.length) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i2]);
            ++i2;
        }
        return sb.toString();
    }

    public MessageData viewMessage(Folder folder, int id) throws MessagingException, IOException {
        Message m;
        if (!(this.lastData != null && id == this.currentId && folder.getName().equals(this.currentFolder.getName()) || (m = folder.getMessage(id)) == null)) {
            this.lastData = new MessageData(m);
        }
        return this.lastData;
    }
}

