/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mailer.editors;

import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import net.wasamon.mailer.driver.MessageData;
import net.wasamon.mailer.driver.SMTPClient;
import net.wasamon.mailer.editors.BaseMailerPage;
import net.wasamon.mailer.editors.ClientInfoPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SendMailPage
extends BaseMailerPage
implements SelectionListener {
    private Text toField;
    private Text fromField;
    private Text subjectField;
    private Text ccField;
    private Text bccField;
    private Button sendMailButton;
    private Button newMailButton;
    private Text msgText;
    private ClientInfoPage infoPage;

    public SendMailPage(Composite parent, Shell shell, int style, ClientInfoPage infoPage) {
        super(parent, shell, style);
        this.infoPage = infoPage;
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Composite ctrl = this.makeCtrlButtonGroup(this.composite);
        ctrl.setLayoutData((Object)new GridData(768));
        Composite field = this.makeField(this.composite);
        field.setLayoutData((Object)new GridData(768));
        this.msgText = new Text(this.composite, 2818);
        this.msgText.setEditable(true);
        this.msgText.setLayoutData((Object)new GridData(1808));
    }

    private Composite makeCtrlButtonGroup(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, true));
        this.sendMailButton = this.makeButton(c, this, "Send");
        this.newMailButton = this.makeButton(c, this, "New");
        return c;
    }

    private Composite makeField(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        this.toField = this.makeField(c, "To:");
        this.fromField = this.makeField(c, "From:");
        this.ccField = this.makeField(c, "Cc:");
        this.bccField = this.makeField(c, "Bcc:");
        this.subjectField = this.makeField(c, "Subject:");
        return c;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void sendMessage(String toAddr, String fromAddr, String subject, String ccAddr, String bccAddr, String mesg) throws MessagingException, UnsupportedEncodingException {
        MessageData data = new MessageData(toAddr, fromAddr, subject);
        if (!ccAddr.equals("")) {
            data.setCcAddr(ccAddr);
        }
        if (!bccAddr.equals("")) {
            data.setBccAddr(bccAddr);
        }
        System.out.println("cc = " + ccAddr);
        System.out.println("bcc = " + bccAddr);
        data.setMessage(mesg);
        SMTPClient.getInstance().sendMessage(this.infoPage.getSMTPClientData(), data);
    }

    public void makeNewDraft() {
        this.toField.setText("");
        this.fromField.setText(this.infoPage.getMailAddr());
        this.subjectField.setText("");
        this.ccField.setText("");
        this.msgText.setText("");
    }

    public void makeNewDraft(String toAddr, String ccAddr, String subject, String mesg) {
        this.toField.setText(toAddr);
        this.fromField.setText(this.infoPage.getMailAddr());
        this.subjectField.setText(subject);
        this.ccField.setText(ccAddr);
        this.msgText.setText(mesg);
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj != null) {
            if (obj == this.sendMailButton) {
                try {
                    this.sendMessage(this.toField.getText(), this.fromField.getText(), this.subjectField.getText(), this.ccField.getText(), this.bccField.getText(), this.msgText.getText());
                }
                catch (MessagingException ex) {
                    MessageDialog.openError((Shell)this.shell, (String)"Error", (String)("error sending message: " + ex.getMessage()));
                }
                catch (UnsupportedEncodingException ex) {
                    MessageDialog.openError((Shell)this.shell, (String)"Error", (String)("error sending message: " + ex.getMessage()));
                }
                this.toField.setText("");
            } else if (obj == this.newMailButton) {
                this.makeNewDraft();
            }
        }
    }
}

