/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mailer.driver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.ParseException;

public class MessageData {
    Address[] toAddr;
    Address fromAddr;
    Address[] ccAddr;
    Address[] bccAddr;
    String subject;
    String body;
    Date date;
    String xMailer;
    String plainMessage;

    public MessageData(Message mesg) throws MessagingException, IOException {
        this.dumpPart((Part)mesg);
    }

    public MessageData(String toAddr, String fromAddr, String subject) throws AddressException {
        this.toAddr = InternetAddress.parse((String)toAddr, (boolean)false);
        this.fromAddr = InternetAddress.parse((String)fromAddr, (boolean)false)[0];
        this.subject = subject;
        this.ccAddr = null;
        this.bccAddr = null;
        this.body = "";
    }

    public void setCcAddr(String addr) throws AddressException {
        this.ccAddr = InternetAddress.parse((String)addr, (boolean)false);
    }

    public void setBccAddr(String addr) throws AddressException {
        this.bccAddr = InternetAddress.parse((String)addr, (boolean)false);
    }

    public void setMessage(String mesg) {
        this.body = mesg;
    }

    public String getPlainMessage() {
        return this.plainMessage;
    }

    public String getMessage() {
        return this.body;
    }

    public String getToAddrStr() {
        return this.getAddressArrayAsStr(this.toAddr);
    }

    public String getCcAddrStr() {
        return this.getAddressArrayAsStr(this.ccAddr);
    }

    public String getFromAddrStr() {
        return this.fromAddr.toString();
    }

    public Date getDate() {
        return this.date;
    }

    public String getSubject() {
        return this.subject;
    }

    private String getAddressArrayAsStr(Address[] a) {
        String tmp = "";
        if (a == null) {
            return tmp;
        }
        int j = 0;
        while (j < a.length) {
            tmp = String.valueOf(tmp) + "," + a[j].toString();
            ++j;
        }
        if (tmp.length() > 1) {
            tmp = tmp.substring(1);
        }
        return tmp;
    }

    private void dumpEnvelope(Message m) throws MessagingException {
        this.fromAddr = m.getFrom()[0];
        this.toAddr = m.getRecipients(Message.RecipientType.TO);
        this.ccAddr = m.getRecipients(Message.RecipientType.CC);
        this.subject = m.getSubject();
        this.date = m.getSentDate();
        String[] hdrs = m.getHeader("X-Mailer");
        if (hdrs != null) {
            this.xMailer = hdrs[0];
        }
    }

    private void pr(StringBuffer buf, String str) {
        buf.append(String.valueOf(str) + "\n");
    }

    private void dumpPart(Part p) throws MessagingException, IOException {
        StringBuffer buf = new StringBuffer();
        this.dumpPart(buf, p);
        this.body = buf.toString();
    }

    private void dumpPart(StringBuffer buf, Part p) throws MessagingException, IOException {
        if (p instanceof Message) {
            this.dumpEnvelope((Message)p);
        }
        String ct = p.getContentType();
        try {
            this.pr(buf, "CONTENT-TYPE: " + new ContentType(ct).toString());
        }
        catch (ParseException parseException) {
            this.pr(buf, "BAD CONTENT-TYPE: " + ct);
        }
        String filename = p.getFileName();
        if (filename != null) {
            this.pr(buf, "FILENAME: " + filename);
        }
        if (p.isMimeType("text/plain")) {
            this.pr(buf, "---------------------------");
            this.plainMessage = (String)p.getContent();
            buf.append(this.plainMessage);
        } else if (p.isMimeType("multipart/*")) {
            this.pr(buf, "This is a Multipart");
            this.pr(buf, "---------------------------");
            Multipart mp = (Multipart)p.getContent();
            int count = mp.getCount();
            int i = 0;
            while (i < count) {
                this.dumpPart(buf, (Part)mp.getBodyPart(i));
                ++i;
            }
        } else if (p.isMimeType("message/rfc822")) {
            this.pr(buf, "This is a Nested Message");
            this.pr(buf, "---------------------------");
            this.dumpPart(buf, (Part)p.getContent());
        } else {
            Object o = p.getContent();
            if (o instanceof String) {
                this.pr(buf, "This is a string");
                this.pr(buf, "---------------------------");
                buf.append((String)o);
            } else if (o instanceof InputStream) {
                int c;
                this.pr(buf, "This is just an input stream");
                this.pr(buf, "---------------------------");
                InputStream is = (InputStream)o;
                while ((c = is.read()) != -1) {
                    buf.append(c);
                }
            } else {
                this.pr(buf, "This is an unknown type");
                this.pr(buf, "---------------------------");
                this.pr(buf, o.toString());
            }
            this.pr(buf, "---------------------------");
        }
        this.body = buf.toString();
    }

    public String getHeaderString() {
        StringBuffer sb = new StringBuffer();
        sb.append("To: " + this.getToAddrStr() + "\n");
        sb.append("Cc: " + this.getCcAddrStr() + "\n");
        sb.append("Subject: " + this.getSubject() + "\n");
        sb.append("Date: " + (this.date != null ? this.date.toString() : "UNKNOWN") + "\n");
        sb.append("X-Mailer: " + this.xMailer + "\n");
        return sb.toString();
    }
}

