/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.mailer.editors;

import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.editors.BaseMailerPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ClientInfoPage
extends BaseMailerPage {
    private Text hostField;
    private Text portField;
    private Text userField;
    private Text passwdField;
    private Text smtpHostField;
    private Text smtpPortField;
    private Text smtpUserField;
    private Text smtpPasswdField;
    private Text smtpMailAddrField;

    public ClientInfoPage(Composite parent, Shell shell, int style) {
        super(parent, shell, style);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Group imap = this.makeIMAPConfig(this.composite);
        imap.setLayoutData((Object)new GridData(768));
        Group smtp = this.makeSMTPConfig(this.composite);
        smtp.setLayoutData((Object)new GridData(768));
    }

    private Group makeIMAPConfig(Composite parent) {
        Group g = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        g.setText("IMAP coinfg");
        g.setLayout((Layout)layout);
        this.hostField = this.makeField((Composite)g, "Host");
        this.portField = this.makeField((Composite)g, "Port");
        this.portField.setText("143");
        this.userField = this.makeField((Composite)g, "User");
        this.passwdField = this.makeField((Composite)g, "Password");
        this.passwdField.setEchoChar('*');
        return g;
    }

    private Group makeSMTPConfig(Composite parent) {
        Group g = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        g.setText("SMTP coinfg");
        g.setLayout((Layout)layout);
        this.smtpHostField = this.makeField((Composite)g, "Host");
        this.smtpPortField = this.makeField((Composite)g, "Port");
        this.smtpPortField.setText("25");
        this.smtpUserField = this.makeField((Composite)g, "User");
        this.smtpPasswdField = this.makeField((Composite)g, "Password");
        this.smtpPasswdField.setEchoChar('*');
        this.smtpMailAddrField = this.makeField((Composite)g, "Address");
        return g;
    }

    public ClientData getIMAPClientData() {
        String user = this.userField.getText();
        String passwd = this.passwdField.getText();
        String host = this.hostField.getText();
        int port = -1;
        try {
            port = Integer.parseInt(this.userField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            port = -1;
        }
        return new ClientData(host, port, user, passwd);
    }

    public ClientData getSMTPClientData() {
        String user = this.smtpUserField.getText();
        String passwd = this.smtpPasswdField.getText();
        String host = this.smtpHostField.getText();
        int port = -1;
        try {
            port = Integer.parseInt(this.smtpUserField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            port = -1;
        }
        return new ClientData(host, port, user, passwd);
    }

    public String getMailAddr() {
        return this.smtpMailAddrField.getText();
    }
}

