package net.wasamon.mailer.composite;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

import javax.mail.MessagingException;

import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.driver.MessageData;
import net.wasamon.mailer.driver.SMTPClient;
import net.wasamon.mailer.views.MailConfigView;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;

public class SendMailComposite extends AbstractMailerComposite implements
		SelectionListener {

	private Text toField;

	private Text fromField;

	private Text subjectField;

	private Text attachField;

	private Button attachButton;

	private Text ccField;

	private Text bccField;

	private Button sendMailButton;

	private Button newMailButton;

	private Text msgText;

	private ArrayList<File> attachFileList;

	public SendMailComposite(Composite parent, IWorkbenchPartSite site,
			int style) {
		super(parent, site, style);
		composite.setLayout(new GridLayout(1, false));
		Composite ctrl = makeCtrlButtonGroup(composite);
		ctrl.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Composite field = makeField(composite);
		field.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		msgText = new Text(composite, SWT.MULTI | SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL);
		msgText.setEditable(true);
		msgText.setLayoutData(new GridData(GridData.FILL_BOTH));
	}

	private Composite makeCtrlButtonGroup(Composite parent) {
		Composite c = new Composite(parent, SWT.NONE);
		c.setLayout(new GridLayout(2, true));
		sendMailButton = makeButton(c, this, "Send");
		newMailButton = makeButton(c, this, "New");
		return c;
	}

	private Composite makeField(Composite parent) {
		Composite c = new Composite(parent, SWT.NONE);
		c.setLayout(new GridLayout(2, false));
		toField = makeField(c, "To:");
		fromField = makeField(c, "From:");
		ccField = makeField(c, "Cc:");
		bccField = makeField(c, "Bcc:");
		subjectField = makeField(c, "Subject:");
		makeAttachField(c);
		return c;
	}

	private void makeAttachField(Composite parent) {
		attachButton = new Button(parent, SWT.NONE);
		attachButton.setText("File");
		attachButton.addSelectionListener(this);
		attachField = new Text(parent, SWT.SINGLE | SWT.BORDER);
		attachField.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub

	}

	private void sendMessage(String toAddr, String fromAddr, String subject,
			String ccAddr, String bccAddr, String mesg,
			ArrayList<File> attachFiles) throws MessagingException,
			UnsupportedEncodingException {
		MessageData data = new MessageData(toAddr, fromAddr, subject);
		if (ccAddr.equals("") == false) {
			data.setCcAddr(ccAddr);
		}
		if (bccAddr.equals("") == false) {
			data.setBccAddr(bccAddr);
		}
		if(replyFlag){
			data.setReferences(references + " " + mesgID);
			data.setInReplyTo(mesgID);
		}
		data.setMessage(mesg);
		if (attachFiles != null && attachFiles.size() > 0) {
			data.setMultiPart(true);
			data.setAttachFileList(attachFiles);
		}
		SMTPClient.getInstance().sendMessage(getSMTPClientData(), data);
	}

	private ClientData getSMTPClientData() {
		MailConfigView view = (MailConfigView) (findViewPart("net.wasamon.mailer.views.mailConfigView"));
		if (view == null) {
			return null;
		} else {
			return view.getClientInfo().getSMTPClientData();
		}
	}

	public void makeNewDraft() {
		replyFlag = false;
		makeNewDraft("", "", "", "");
	}

	boolean replyFlag;
	String references;
	String mesgID;
	
	public void makeNewDraft(MessageData data) {
		String body = "";
		replyFlag = true;
		references = data.getReference();
		mesgID = data.getMessageID();
		try {
			body = convReplyBody(data.getFromAddrStr(), data.getDate(), data
					.getPlainMessage());
		} catch (IOException e) {
			
		}
		makeNewDraft(data.getFromAddrStr() + ", " + data.getToAddrStr(), data
				.getCcAddrStr(), convReplySubject(data.getSubject()), body);
	}

	public void makeNewDraft(String toAddr, String ccAddr, String subject,
			String mesg) {
		toField.setText(toAddr);
		fromField.setText(getSMTPClientData().myMailAddr);
		subjectField.setText(subject);
		ccField.setText(ccAddr);
		msgText.setText(mesg);
	}

	private void clearField() {
		toField.setText("");
		ccField.setText("");
		bccField.setText("");
		attachField.setText("");
		attachFileList = null;
	}

	public void widgetSelected(SelectionEvent e) {
		Object obj = e.getSource();
		if (obj == null) {

		} else if (obj == sendMailButton) {
			boolean flag = true;
			try {
				sendMessage(toField.getText(), fromField.getText(),
						subjectField.getText(), ccField.getText(), bccField
								.getText(), msgText.getText(), attachFileList);
			} catch (MessagingException ex) {
				flag = false;
				MessageDialog.openError(site.getShell(), "Error",
						"error sending message: " + ex.getMessage());
			} catch (UnsupportedEncodingException ex) {
				flag = false;
				MessageDialog.openError(site.getShell(), "Error",
						"error sending message: " + ex.getMessage());
			}
			if (flag == true) {
				clearField();
				MessageDialog.openInformation(site.getShell(), "Success",
						"success to sending mail.");
			}
		} else if (obj == newMailButton) {
			makeNewDraft();
		} else if (obj == attachButton) {
			doAttachFileAction();
		} else {

		}
	}

	private void addAttachFile(File f) {
		if (attachFileList == null) {
			attachFileList = new ArrayList<File>();
		}
		attachFileList.add(f);
		Iterator<File> i = attachFileList.iterator();
		String s = "";
		while (i.hasNext()) {
			s += "," + i.next().getName();
		}
		attachField.setText(s.substring(1));
	}

	public void doAttachFileAction() {
		FileDialog openDialog = new FileDialog(site.getShell(), SWT.OPEN);
		String openFile = openDialog.open();
		if (openFile != null) {
			openFile = openFile.trim();
			if (openFile.equals("") == false) {
				File f = new File(openFile);
				if (f.exists() == true) {
					addAttachFile(f);
				} else {
					MessageDialog.openError(site.getShell(), "Error",
							"no such file: " + openFile);
				}
			}
		}
	}

	private String convReplyBody(String from, Date d, String mesg)
			throws IOException {
		BufferedReader reader = new BufferedReader(new StringReader(mesg));
		String s = "\n\n\n";
		s += "at " + d + ",\n";
		s += from + " wrote:\n";
		String tmp = "";
		while ((tmp = reader.readLine()) != null) {
			s += "> " + tmp + "\n";
		}
		s += "\n";
		return s;
	}

	private String convReplySubject(String a) {
		if (a.startsWith("Re:") || a.startsWith("RE:")) {
			return a;
		} else {
			return "Re: " + a;
		}
	}

}
