package net.wasamon.mailer.composite;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;

import javax.mail.Message;
import javax.mail.MessagingException;

import net.wasamon.mailer.driver.ClientData;
import net.wasamon.mailer.driver.IMAPClient;
import net.wasamon.mailer.driver.MessageData;
import net.wasamon.mailer.views.MailConfigView;
import net.wasamon.mailer.views.MailMessageView;
import net.wasamon.mailer.views.MailSendView;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPartSite;

public class SummaryComposite extends AbstractMailerComposite implements SelectionListener {

	private Button updateButton;
	private Button replyMesgButton;
	
	private Table mailSummary;
	
	private StyledText text;
	
	private MessageData selectData;

	public SummaryComposite(Composite parent, IWorkbenchPartSite site, int style){
		super(parent, site, style);

		composite.setLayout(new GridLayout(1, false));
		
		makeButtonGroup(composite);

		mailSummary = new Table(composite, SWT.MULTI | SWT.FULL_SELECTION
				| SWT.BORDER);
		mailSummary.setHeaderVisible(true);
		mailSummary.addSelectionListener(this);
		mailSummary.setVisible(true);
		makeTableColumn(mailSummary, "#", 50);
		makeTableColumn(mailSummary, "F", 50);
		makeTableColumn(mailSummary, "Date", 150);
		makeTableColumn(mailSummary, "From", 150);
		makeTableColumn(mailSummary, "Subject", 250);
		mailSummary.setLayoutData(new GridData(GridData.FILL_BOTH));
		text = new StyledText(composite, SWT.H_SCROLL | SWT.V_SCROLL);
		text.setLayoutData(new GridData(GridData.FILL_BOTH));
	}

	private void makeButtonGroup(Composite parent){
		Composite c = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout(2, true);
		c.setLayout(layout);
		updateButton = makeButton(c, this, "Update");
		replyMesgButton = makeButton(c, this, "Reply");
	}
	
	private void makeTableColumn(Table table, String label, int width){
		TableColumn col = new TableColumn(table, SWT.LEFT);
		col.setText(label);
		col.setWidth(width);
	}
	
	private String folder;
	
	private ClientData getIMAPClientData(){
		MailConfigView view = (MailConfigView)(getViewPart("net.wasamon.mailer.views.mailConfigView"));
		if(view == null){
			return null;
		}else{
			return view.getClientInfo().getIMAPClientData();
		}
	}

	private SendMailComposite getSendMailComposite(){
		MailSendView view = (MailSendView)(getViewPart("net.wasamon.mailer.views.mailSendView"));
		if(view == null){
			return null;
		}else{
			return view.getSendMailComposite();
		}
	}
	
	private MessageComposite getMessageComposite(){
		MailMessageView view = (MailMessageView)(getViewPart("net.wasamon.mailer.views.mailMessageView"));
		if(view == null){
			return null;
		}else{
			return view.getMessageComposite(); 
		}
	}

	private void updateSummary() {
		try {
			IMAPClient imap = IMAPClient.getInstance();
			Message[] msg = imap.getFolderMessages(imap.openFolder(getIMAPClientData(), folder));
			mailSummary.removeAll();
			for (int i = 0; i < msg.length; i++) {
				makeMailSummaryItem(msg[i]);
			}
		} catch (MessagingException e) {
			MessageDialog.openError(
					site.getShell(),
					"Error",
					"I/O Exception: " + e.getMessage());
		}
	}
	
	public void setAndUpdate(String folder){
		this.folder = folder;
		updateSummary();
	}

	private void makeMailSummaryItem(Message msg) throws MessagingException {
		TableItem item = new TableItem(mailSummary, SWT.BORDER);
		String data[] = new String[5];
		data[0] = String.valueOf(msg.getMessageNumber());
		Date d = msg.getSentDate();
		data[1] = IMAPClient.getInstance().getFlagString(msg);
		data[2] = (d != null ? d.toString() : "UNKNOWN");
		data[3] = MessageData.getAddrStr(msg.getFrom()[0]);
		data[4] = msg.getSubject();
		item.setText(data);
		// Flags flags = m.getFlags();
		// Flags.Flag[] sf = flags.getSystemFlags(); // get the system flags
	}


	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
	}

	public void widgetSelected(SelectionEvent e) {
		Object obj = e.getSource();
		if(obj == null){
			
		}else if(obj == updateButton){
			updateSummary();
		}else if(obj == mailSummary){
			TableItem[] items = ((Table)obj).getSelection();
			if(items != null){
				selectData =
					getMessageComposite().viewMessage(						
							getIMAPClientData(),
							folder,
							Integer.parseInt(items[0].getText(0))
					);
				text.setText(selectData.getHeaderString() + selectData.getMessage());
			}
		}else if(obj == replyMesgButton){
			if(selectData != null){
				String body = "";
				try{
					body = convReplyBody(
							selectData.getFromAddrStr(), 
							selectData.getDate(),
							selectData.getPlainMessage());
				}catch(IOException ex){
					
				}
				getSendMailComposite().makeNewDraft(
						selectData.getFromAddrStr() + ", " + selectData.getToAddrStr(),
						selectData.getCcAddrStr(),
						convReplySubject(selectData.getSubject()),
						body);
			}
		}
	}
	
	private String convReplyBody(String from, Date d, String mesg) throws IOException{
		BufferedReader reader = new BufferedReader(new StringReader(mesg));
		String s = "\n\n\n";
		s += "at " + d + ",\n";
		s += from + " wrote:\n";
		String tmp = "";
		while((tmp = reader.readLine()) != null){
			s += "> " + tmp + "\n";
		}
		s += "\n";
		return s;
	}
	
	private String convReplySubject(String a){
		if(a.startsWith("Re:") || a.startsWith("RE:")){
			return a;
		}else{
			return "Re: " + a;
		}
	}
	
}