package net.wasamon.mailer.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public abstract class AbstractMailerComposite {

	protected final Composite composite;
	
	protected IWorkbenchPartSite site;
	
	public Composite getComposite() {
		return composite;
	}

	protected AbstractMailerComposite(Composite parent, IWorkbenchPartSite site, int style){
		composite = new Composite(parent, style);
		this.site = site;
	}
	
	protected Button makeButton(Composite parent, SelectionListener listener, String label){
		Button b = new Button(parent, SWT.NONE);
		b.setText(label);
		b.addSelectionListener(listener);
		return b;
	}
	

	protected Text makeField(Composite parent, String labelStr) {
		Label label = new Label(parent, SWT.NONE);
		label.setText(labelStr);
		Text field = new Text(parent, SWT.SINGLE | SWT.BORDER);
		field.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		return field;
	}

	protected IViewPart findViewPart(String id) {
		IWorkbenchPage workBenchPage = site.getWorkbenchWindow().getActivePage();
		return workBenchPage.findView(id);
	}

	protected IViewPart showViewPart(String id) {
		IWorkbenchPage workBenchPage = site.getWorkbenchWindow().getActivePage();
		try {
			return workBenchPage.showView(id);
		} catch (PartInitException e) {
			return null;
		}
	}

	
}
