package net.wasamon.mailer.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MessageData {

	Address[] toAddr;
	Address fromAddr;
	Address[] ccAddr;
	Address[] bccAddr;
	String subject;
	String body;
	Date date;
	String xMailer;
	String plainMessage;

	public MessageData(Message mesg) throws MessagingException, IOException{
		dumpPart(mesg);
	}
	
	public MessageData(String toAddr, String fromAddr, String subject) throws AddressException{
		this.toAddr = InternetAddress.parse(toAddr, false);
		this.fromAddr = InternetAddress.parse(fromAddr, false)[0];
		this.subject = subject;
		ccAddr = null;
		bccAddr = null;
		body = "";
	}
	
	public void setCcAddr(String addr) throws AddressException{
		ccAddr = InternetAddress.parse(addr, false);
	}
	public void setBccAddr(String addr) throws AddressException{
		bccAddr = InternetAddress.parse(addr, false);
	}
	public void setMessage(String mesg){
		this.body = mesg;
	}
	public String getPlainMessage(){
		return plainMessage;
	}
	public String getMessage(){
		return body;
	}
	
	public String getToAddrStr(){
		return getAddressArrayAsStr(toAddr);
	}
	public String getCcAddrStr(){
		return getAddressArrayAsStr(ccAddr);
	}

	public static String getAddrStr(Address a){
		String str = a.toString();
		if(str.startsWith("=?")){
			try{
				str = MimeUtility.decodeText(str);
			}catch(UnsupportedEncodingException e){
				str = a.toString();
			}
		}
		return str;
	}
	
	public String getFromAddrStr(){
		return getAddrStr(fromAddr);
	}

	public Date getDate(){
		return date;
	}
	
	public String getSubject(){
		return subject;
	}

	private String getAddressArrayAsStr(Address[] a){
		String tmp = "";
		if(a == null) return tmp;
		for (int j = 0; j < a.length; j++) {
			tmp += "," + getAddrStr(a[j]);
//			InternetAddress ia = (InternetAddress) a[j];
//			if (ia.isGroup()) {
//			InternetAddress[] aa = ia.getGroup(false);
//			for (int k = 0; k < aa.length; k++)
//			pr("  Group: " + aa[k].toString());
//			}
		}
		if(tmp.length() > 1){
			tmp = tmp.substring(1);
		}
		return tmp;
	}
	
	private void dumpEnvelope(Message m) throws MessagingException{
		// FROM
//		Address[] a;
//		if ((a = m.getFrom()) != null) {
//			for (int j = 0; j < a.length; j++)
//				pr("From: " + a[j].toString());
//		}
		fromAddr = m.getFrom()[0];
		// TO
		toAddr = m.getRecipients(Message.RecipientType.TO);
		// CC
		ccAddr = m.getRecipients(Message.RecipientType.CC);
		// SUBJECT
		subject = m.getSubject();
		// DATE
		date = m.getSentDate();
		// X-MAILER
		String[] hdrs = m.getHeader("X-Mailer");
		if (hdrs != null){
			xMailer = hdrs[0];
		}
	}

	private void pr(StringBuffer buf, String str){
		buf.append(str + "\n");
	}
	
	private void dumpPart(Part p) throws MessagingException, IOException {
		StringBuffer buf = new StringBuffer();
		dumpPart(buf, p);
		body = buf.toString();
	}	
	
	private void dumpPart(StringBuffer buf, Part p) throws MessagingException, IOException {
		if (p instanceof Message){
			dumpEnvelope((Message) p);
		}

		/**
		 * Dump input stream ..
		 * 
		 * InputStream is = p.getInputStream(); // If "is" is not already
		 * buffered, wrap a BufferedInputStream // around it. if (!(is
		 * instanceof BufferedInputStream)) is = new BufferedInputStream(is);
		 * int c; while ((c = is.read()) != -1) System.out.write(c);
		 * 
		 */

		String ct = p.getContentType();
		try {
			pr(buf, "CONTENT-TYPE: " + (new ContentType(ct)).toString());
		} catch (ParseException pex) {
			pr(buf, "BAD CONTENT-TYPE: " + ct);
		}
		String filename = p.getFileName();
		if (filename != null)
			pr(buf, "FILENAME: " + filename);

		/*
		 * Using isMimeType to determine the content type avoids fetching the
		 * actual content data until we need it.
		 */
		if (p.isMimeType("text/plain")) {
//			pr("This is plain text");
			pr(buf, "---------------------------");
			plainMessage = (String) p.getContent();
			buf.append(plainMessage);
		} else if (p.isMimeType("multipart/*")) {
			pr(buf, "This is a Multipart");
			pr(buf, "---------------------------");
			Multipart mp = (Multipart) p.getContent();
			int count = mp.getCount();
			for (int i = 0; i < count; i++)
				dumpPart(buf, mp.getBodyPart(i));
		} else if (p.isMimeType("message/rfc822")) {
			pr(buf, "This is a Nested Message");
			pr(buf, "---------------------------");
			dumpPart(buf, (Part) p.getContent());
		} else {
			Object o = p.getContent();
			if (o instanceof String) {
				pr(buf, "This is a string");
				pr(buf, "---------------------------");
				buf.append((String) o);
			} else if (o instanceof InputStream) {
				pr(buf, "This is just an input stream");
				pr(buf, "---------------------------");
				InputStream is = (InputStream) o;
				int c;
				while ((c = is.read()) != -1)
					buf.append(c);
			} else {
				pr(buf, "This is an unknown type");
				pr(buf, "---------------------------");
				pr(buf, o.toString());
			}
			pr(buf, "---------------------------");
		}
		body = buf.toString();
	}

	public String getHeaderString(){
		StringBuffer sb = new StringBuffer();
		sb.append("To: " + getToAddrStr() + "\n");
		sb.append("Cc: " + getCcAddrStr() + "\n");
		sb.append("From: " + getFromAddrStr() + "\n");
		sb.append("Subject: " + getSubject() + "\n");
		sb.append("Date: " + (date != null ? date.toString() : "UNKNOWN") + "\n");
		sb.append("X-Mailer: " + xMailer + "\n");
		return sb.toString();
	}
	
	
}
