/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl.type;

import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.type.StdLogic;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;

public class VHDLArrayType
implements JavaRockType {
    public final JavaRockType base;
    JavaRockType type;
    int length;

    public void setLength(int length) {
        this.length = length;
    }

    VHDLArrayType(JavaRockType base) {
        this.base = base;
        this.type = base;
    }

    @Override
    public String getDefaultValue() {
        return null;
    }

    public int getDepth() {
        return (int)Math.ceil(Math.log(this.length) / Math.log(2.0));
    }

    public JavaRockType getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public String getWidth() {
        if (this.type instanceof StdLogicVector) {
            StdLogicVector v = (StdLogicVector)this.type;
            return String.format("%s-%s+1", v.begin, v.end);
        }
        if (this.type instanceof StdLogic) {
            return String.valueOf(this.length);
        }
        return "unknown";
    }
}

