/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.classfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import openjdk.com.sun.tools.classfile.AccessFlags;
import openjdk.com.sun.tools.classfile.Attribute;
import openjdk.com.sun.tools.classfile.Attributes;
import openjdk.com.sun.tools.classfile.ClassReader;
import openjdk.com.sun.tools.classfile.ConstantPool;
import openjdk.com.sun.tools.classfile.ConstantPoolException;
import openjdk.com.sun.tools.classfile.Field;
import openjdk.com.sun.tools.classfile.Method;

public class ClassFile {
    public final int magic;
    public final int minor_version;
    public final int major_version;
    public final ConstantPool constant_pool;
    public final AccessFlags access_flags;
    public final int this_class;
    public final int super_class;
    public final int[] interfaces;
    public final Field[] fields;
    public final Method[] methods;
    public final Attributes attributes;

    public static ClassFile read(File file) throws IOException, ConstantPoolException {
        return ClassFile.read(file, new Attribute.Factory());
    }

    public static ClassFile read(File file, Attribute.Factory attributeFactory) throws IOException, ConstantPoolException {
        FileInputStream in = new FileInputStream(file);
        try {
            ClassFile classFile = new ClassFile(in, attributeFactory);
            return classFile;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static ClassFile read(InputStream in) throws IOException, ConstantPoolException {
        return new ClassFile(in, new Attribute.Factory());
    }

    public static ClassFile read(InputStream in, Attribute.Factory attributeFactory) throws IOException, ConstantPoolException {
        return new ClassFile(in, attributeFactory);
    }

    ClassFile(InputStream in, Attribute.Factory attributeFactory) throws IOException, ConstantPoolException {
        ClassReader cr = new ClassReader(this, in, attributeFactory);
        this.magic = cr.readInt();
        this.minor_version = cr.readUnsignedShort();
        this.major_version = cr.readUnsignedShort();
        this.constant_pool = new ConstantPool(cr);
        this.access_flags = new AccessFlags(cr);
        this.this_class = cr.readUnsignedShort();
        this.super_class = cr.readUnsignedShort();
        int interfaces_count = cr.readUnsignedShort();
        this.interfaces = new int[interfaces_count];
        int i = 0;
        while (i < interfaces_count) {
            this.interfaces[i] = cr.readUnsignedShort();
            ++i;
        }
        int fields_count = cr.readUnsignedShort();
        this.fields = new Field[fields_count];
        int i2 = 0;
        while (i2 < fields_count) {
            this.fields[i2] = new Field(cr);
            ++i2;
        }
        int methods_count = cr.readUnsignedShort();
        this.methods = new Method[methods_count];
        int i3 = 0;
        while (i3 < methods_count) {
            this.methods[i3] = new Method(cr);
            ++i3;
        }
        this.attributes = new Attributes(cr);
    }

    public ClassFile(int magic, int minor_version, int major_version, ConstantPool constant_pool, AccessFlags access_flags, int this_class, int super_class, int[] interfaces, Field[] fields, Method[] methods, Attributes attributes) {
        this.magic = magic;
        this.minor_version = minor_version;
        this.major_version = major_version;
        this.constant_pool = constant_pool;
        this.access_flags = access_flags;
        this.this_class = this_class;
        this.super_class = super_class;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
    }

    public String getName() throws ConstantPoolException {
        return this.constant_pool.getClassInfo(this.this_class).getName();
    }

    public String getSuperclassName() throws ConstantPoolException {
        return this.constant_pool.getClassInfo(this.super_class).getName();
    }

    public String getInterfaceName(int i) throws ConstantPoolException {
        return this.constant_pool.getClassInfo(this.interfaces[i]).getName();
    }

    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean isClass() {
        return !this.isInterface();
    }

    public boolean isInterface() {
        return this.access_flags.is(512);
    }

    public int byteLength() {
        return 8 + this.constant_pool.byteLength() + 2 + 2 + 2 + this.byteLength(this.interfaces) + this.byteLength(this.fields) + this.byteLength(this.methods) + this.attributes.byteLength();
    }

    private int byteLength(int[] indices) {
        return 2 + 2 * indices.length;
    }

    private int byteLength(Field[] fields) {
        int length = 2;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            length += f.byteLength();
            ++n2;
        }
        return length;
    }

    private int byteLength(Method[] methods) {
        int length = 2;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            length += m.byteLength();
            ++n2;
        }
        return length;
    }
}

