/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.main;

import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import openjdk.com.sun.tools.javac.main.Main;
import openjdk.com.sun.tools.javac.main.OptionName;
import openjdk.com.sun.tools.javac.util.Log;
import openjdk.com.sun.tools.javac.util.Options;

public interface JavacOption {
    public OptionKind getKind();

    public boolean hasArg();

    public boolean matches(String var1);

    public boolean process(Options var1, String var2, String var3);

    public boolean process(Options var1, String var2);

    public OptionName getName();

    public static enum ChoiceKind {
        ONEOF,
        ANYOF;

    }

    public static class HiddenOption
    extends Option {
        HiddenOption(OptionName name) {
            super(name, null, null);
        }

        HiddenOption(OptionName name, String argsNameKey) {
            super(name, argsNameKey, null);
        }

        @Override
        void help(PrintWriter out) {
        }

        @Override
        void xhelp(PrintWriter out) {
        }

        @Override
        public OptionKind getKind() {
            return OptionKind.HIDDEN;
        }
    }

    public static class Option
    implements JavacOption {
        OptionName name;
        String argsNameKey;
        String descrKey;
        boolean hasSuffix;
        ChoiceKind choiceKind;
        Map<String, Boolean> choices;

        Option(OptionName name, String argsNameKey, String descrKey) {
            this.name = name;
            this.argsNameKey = argsNameKey;
            this.descrKey = descrKey;
            char lastChar = name.optionName.charAt(name.optionName.length() - 1);
            this.hasSuffix = lastChar == ':' || lastChar == '=';
        }

        Option(OptionName name, String descrKey) {
            this(name, null, descrKey);
        }

        Option(OptionName name, String descrKey, ChoiceKind choiceKind, String ... choices) {
            this(name, descrKey, choiceKind, Option.createChoices(choices));
        }

        private static Map<String, Boolean> createChoices(String ... choices) {
            LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
            String[] stringArray = choices;
            int n = choices.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                map.put(c, false);
                ++n2;
            }
            return map;
        }

        Option(OptionName name, String descrKey, ChoiceKind choiceKind, Map<String, Boolean> choices) {
            this(name, null, descrKey);
            if (choiceKind == null || choices == null) {
                throw new NullPointerException();
            }
            this.choiceKind = choiceKind;
            this.choices = choices;
        }

        public String toString() {
            return this.name.optionName;
        }

        @Override
        public boolean hasArg() {
            return this.argsNameKey != null && !this.hasSuffix;
        }

        @Override
        public boolean matches(String option) {
            if (!this.hasSuffix) {
                return option.equals(this.name.optionName);
            }
            if (!option.startsWith(this.name.optionName)) {
                return false;
            }
            if (this.choices != null) {
                String arg = option.substring(this.name.optionName.length());
                if (this.choiceKind == ChoiceKind.ONEOF) {
                    return this.choices.keySet().contains(arg);
                }
                String[] stringArray = arg.split(",+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String a = stringArray[n2];
                    if (!this.choices.keySet().contains(a)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        void help(PrintWriter out) {
            String s = "  " + this.helpSynopsis();
            out.print(s);
            int j = Math.min(s.length(), 28);
            while (j < 29) {
                out.print(" ");
                ++j;
            }
            Log.printLines(out, Main.getLocalizedString(this.descrKey, new Object[0]));
        }

        String helpSynopsis() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.name);
            if (this.argsNameKey == null) {
                if (this.choices != null) {
                    String sep = "{";
                    for (Map.Entry<String, Boolean> e : this.choices.entrySet()) {
                        if (e.getValue().booleanValue()) continue;
                        sb.append(sep);
                        sb.append(e.getKey());
                        sep = ",";
                    }
                    sb.append("}");
                }
            } else {
                if (!this.hasSuffix) {
                    sb.append(" ");
                }
                sb.append(Main.getLocalizedString(this.argsNameKey, new Object[0]));
            }
            return sb.toString();
        }

        void xhelp(PrintWriter out) {
        }

        @Override
        public boolean process(Options options, String option, String arg) {
            if (options != null) {
                if (this.choices != null) {
                    if (this.choiceKind == ChoiceKind.ONEOF) {
                        for (String s : this.choices.keySet()) {
                            options.remove(String.valueOf(option) + s);
                        }
                        String opt = String.valueOf(option) + arg;
                        options.put(opt, opt);
                        String nm = option.substring(0, option.length() - 1);
                        options.put(nm, arg);
                    } else {
                        String[] stringArray = arg.split(",+");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String a = stringArray[n2];
                            String opt = String.valueOf(option) + a;
                            options.put(opt, opt);
                            ++n2;
                        }
                    }
                }
                options.put(option, arg);
            }
            return false;
        }

        @Override
        public boolean process(Options options, String option) {
            if (this.hasSuffix) {
                return this.process(options, this.name.optionName, option.substring(this.name.optionName.length()));
            }
            return this.process(options, option, option);
        }

        @Override
        public OptionKind getKind() {
            return OptionKind.NORMAL;
        }

        @Override
        public OptionName getName() {
            return this.name;
        }
    }

    public static enum OptionKind {
        NORMAL,
        EXTENDED,
        HIDDEN;

    }

    public static class XOption
    extends Option {
        XOption(OptionName name, String argsNameKey, String descrKey) {
            super(name, argsNameKey, descrKey);
        }

        XOption(OptionName name, String descrKey) {
            this(name, null, descrKey);
        }

        XOption(OptionName name, String descrKey, ChoiceKind kind, String ... choices) {
            super(name, descrKey, kind, choices);
        }

        XOption(OptionName name, String descrKey, ChoiceKind kind, Map<String, Boolean> choices) {
            super(name, descrKey, kind, choices);
        }

        @Override
        void help(PrintWriter out) {
        }

        @Override
        void xhelp(PrintWriter out) {
            super.help(out);
        }

        @Override
        public OptionKind getKind() {
            return OptionKind.EXTENDED;
        }
    }
}

