/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.util;

import java.util.Random;
import openjdk.com.sun.tools.javac.util.Assert;

public class Bits {
    private static final int wordlen = 32;
    private static final int wordshift = 5;
    private static final int wordmask = 31;
    private int[] bits;

    public Bits() {
        this(new int[1]);
    }

    public Bits(int[] bits) {
        this.bits = bits;
    }

    public Bits(int start, int limit) {
        this();
        this.inclRange(start, limit);
    }

    private void sizeTo(int len) {
        if (this.bits.length < len) {
            int[] newbits = new int[len];
            System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
            this.bits = newbits;
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i] = 0;
            ++i;
        }
    }

    public Bits dup() {
        int[] newbits = new int[this.bits.length];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        return new Bits(newbits);
    }

    public void incl(int x) {
        Assert.check(x >= 0);
        this.sizeTo((x >>> 5) + 1);
        this.bits[x >>> 5] = this.bits[x >>> 5] | 1 << (x & 0x1F);
    }

    public void inclRange(int start, int limit) {
        this.sizeTo((limit >>> 5) + 1);
        int x = start;
        while (x < limit) {
            this.bits[x >>> 5] = this.bits[x >>> 5] | 1 << (x & 0x1F);
            ++x;
        }
    }

    public void excludeFrom(int start) {
        Bits temp = new Bits();
        temp.sizeTo(this.bits.length);
        temp.inclRange(0, start);
        this.andSet(temp);
    }

    public void excl(int x) {
        Assert.check(x >= 0);
        this.sizeTo((x >>> 5) + 1);
        this.bits[x >>> 5] = this.bits[x >>> 5] & ~(1 << (x & 0x1F));
    }

    public boolean isMember(int x) {
        return x >= 0 && x < this.bits.length << 5 && (this.bits[x >>> 5] & 1 << (x & 0x1F)) != 0;
    }

    public Bits andSet(Bits xs) {
        this.sizeTo(xs.bits.length);
        int i = 0;
        while (i < xs.bits.length) {
            this.bits[i] = this.bits[i] & xs.bits[i];
            ++i;
        }
        return this;
    }

    public Bits orSet(Bits xs) {
        this.sizeTo(xs.bits.length);
        int i = 0;
        while (i < xs.bits.length) {
            this.bits[i] = this.bits[i] | xs.bits[i];
            ++i;
        }
        return this;
    }

    public Bits diffSet(Bits xs) {
        int i = 0;
        while (i < this.bits.length) {
            if (i < xs.bits.length) {
                this.bits[i] = this.bits[i] & ~xs.bits[i];
            }
            ++i;
        }
        return this;
    }

    public Bits xorSet(Bits xs) {
        this.sizeTo(xs.bits.length);
        int i = 0;
        while (i < xs.bits.length) {
            this.bits[i] = this.bits[i] ^ xs.bits[i];
            ++i;
        }
        return this;
    }

    private static int trailingZeroBits(int x) {
        Assert.check(true);
        if (x == 0) {
            return 32;
        }
        int n = 1;
        if ((x & 0xFFFF) == 0) {
            n += 16;
            x >>>= 16;
        }
        if ((x & 0xFF) == 0) {
            n += 8;
            x >>>= 8;
        }
        if ((x & 0xF) == 0) {
            n += 4;
            x >>>= 4;
        }
        if ((x & 3) == 0) {
            n += 2;
            x >>>= 2;
        }
        return n - (x & 1);
    }

    public int nextBit(int x) {
        int windex = x >>> 5;
        if (windex >= this.bits.length) {
            return -1;
        }
        int word = this.bits[windex] & ~((1 << (x & 0x1F)) - 1);
        while (word == 0) {
            if (++windex >= this.bits.length) {
                return -1;
            }
            word = this.bits[windex];
        }
        return (windex << 5) + Bits.trailingZeroBits(word);
    }

    public String toString() {
        char[] digits = new char[this.bits.length * 32];
        int i = 0;
        while (i < this.bits.length * 32) {
            digits[i] = this.isMember(i) ? 49 : 48;
            ++i;
        }
        return new String(digits);
    }

    public static void main(String[] args) {
        Random r = new Random();
        Bits bits = new Bits();
        boolean dupCount = false;
        int i = 0;
        while (i < 125) {
            int k;
            while (bits.isMember(k = r.nextInt(250))) {
            }
            System.out.println("adding " + k);
            bits.incl(k);
            ++i;
        }
        int count = 0;
        int i2 = bits.nextBit(0);
        while (i2 >= 0) {
            System.out.println("found " + i2);
            ++count;
            i2 = bits.nextBit(i2 + 1);
        }
        if (count != 125) {
            throw new Error();
        }
    }
}

