/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.StateSignal;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScope;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSkip;
import net.wasamon.javarock.model.vhdl.VHDLStatement;

public class VHDLBlock
extends VHDLScope
implements VHDLItem,
VHDLScopeIface {
    private boolean isStepNext;
    private int last_count = 0;

    public VHDLBlock(VHDLProcess process, VHDLScopeIface parent) {
        super(process, parent);
    }

    @Override
    public void connect() {
        if (this.statements.size() == 0) {
            this.statements.add(new VHDLSkip());
        }
        for (VHDLStatement stmt : this.statements) {
            stmt.connect();
        }
        this.isStepNext = false;
        for (VHDLStatement stmt : this.statements) {
            this.isStepNext |= stmt.isStepNext();
        }
    }

    @Override
    public void link() {
        for (VHDLStatement stmt : this.statements) {
            stmt.link();
        }
        super.link();
        this.setStateLabelToStatemtns(1);
    }

    @Override
    public boolean isStepNext() {
        return this.isStepNext;
    }

    @Override
    public boolean isEndOfState() {
        return true;
    }

    protected void setStateLabelToStatemtns(int cnt_offset) {
        int cnt = cnt_offset;
        if (this.process.raw) {
            cnt = 0;
        }
        int i = 0;
        while (i < this.statements.size() - 1) {
            VHDLStatement stmt = (VHDLStatement)this.statements.get(i);
            stmt.setStateLabel(cnt);
            if (stmt.isEndOfState() && !stmt.isSkip()) {
                ++cnt;
            }
            ++i;
        }
        VHDLStatement stmt = (VHDLStatement)this.statements.get(this.statements.size() - 1);
        stmt.setStateLabel(cnt);
        if (stmt.isEndOfState() && !stmt.isSkip()) {
            ++cnt;
        }
        this.last_count = cnt;
    }

    public boolean genStateMachine(PrintWriter out, int offset, StateSignal state) {
        boolean isStateLabel = true;
        boolean isStepNext = true;
        int i = 0;
        while (i < this.statements.size() - 1) {
            VHDLStatement stmt = (VHDLStatement)this.statements.get(i);
            if (isStateLabel && !stmt.isSkip()) {
                this.writeln(out, String.format("when %d =>", stmt.getStateLabel()), offset + 2);
            }
            stmt.generate(out, offset + 4);
            isStateLabel = stmt.isEndOfState();
            if (isStateLabel && !stmt.isStepNext() && !stmt.isSkip()) {
                this.writeln(out, String.format("%s <= %s + 1;", state.value(), state.value()), offset + 4);
            }
            isStepNext = !stmt.isSkip() ? stmt.isStepNext() : isStepNext;
            ++i;
        }
        VHDLStatement stmt = (VHDLStatement)this.statements.get(this.statements.size() - 1);
        if (isStateLabel && !stmt.isSkip()) {
            this.writeln(out, String.format("when %d =>", stmt.getStateLabel()), offset + 2);
        }
        stmt.generate(out, offset + 4);
        isStepNext = !stmt.isSkip() ? stmt.isStepNext() : isStepNext;
        return isStepNext;
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        if (this.statements.size() == 0) {
            this.isStepNext = false;
            return;
        }
        if (this.process.sequential) {
            this.writeln(out, String.format("case conv_integer(%s) is", this.STATE_SIG.value()), offset);
            this.writeln(out, String.format("when 0 => %s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 2);
            boolean flag = this.genStateMachine(out, offset, this.STATE_SIG);
            if (flag) {
                this.writeln(out, String.format("when %d =>", this.last_count), offset + 2);
            }
            this.writeln(out, String.format("%s <= %s + 1;", this.getParent().get_state_sig().value(), this.getParent().get_state_sig().value()), offset + 4);
            this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIG.value()), offset + 4);
            this.writeln(out, String.format("when others => %s <= (others => '0');", this.STATE_SIG.value()), offset + 2);
            this.writeln(out, "end case;", offset);
            this.isStepNext = true;
        } else {
            for (VHDLStatement stmt : this.statements) {
                stmt.generate(out, offset + 2);
            }
        }
    }

    @Override
    public int state_count() {
        int sum = 0;
        for (VHDLStatement stmt : this.statements) {
            sum += stmt.state_count();
        }
        return sum;
    }

    @Override
    public boolean isSkip() {
        return this.statements.size() <= 0;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        return null;
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        return null;
    }
}

