/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.JavaRockComponentInstance;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.VHDLConstant;
import net.wasamon.javarock.model.vhdl.VHDLElement;
import net.wasamon.javarock.model.vhdl.VHDLFieldSignal;
import net.wasamon.javarock.model.vhdl.VHDLGenericParameter;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import net.wasamon.javarock.tools.Manager;
import net.wasamon.javarock.tools.types.CompiledComponentType;
import net.wasamon.javarock.tools.types.ComponentType;

public class VHDLNewComponentInstance
extends VHDLElement
implements VHDLItem,
JavaRockComponentInstance {
    final VHDLModule m;
    final ComponentType type;
    final String name;
    String[] args;
    final boolean fFieldSignal;
    private Hashtable<String, String> portmap = new Hashtable();
    private Hashtable<String, String> value = new Hashtable();

    public VHDLNewComponentInstance(VHDLModule m, ComponentType type, String name, boolean fFieldSignal) {
        this.m = m;
        this.type = type;
        this.name = name;
        this.fFieldSignal = fFieldSignal;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    private JavaRockType newReplacedGenericSignalType(StdLogicVector given) {
        StdLogicVector replaced = VHDLTypeBuilder.getStdLogicVector(given.begin, given.end);
        for (Map.Entry<String, String> set : this.value.entrySet()) {
            replaced.begin = replaced.begin.replace(set.getKey(), set.getValue());
            replaced.end = replaced.end.replace(set.getKey(), set.getValue());
        }
        return replaced;
    }

    private VHDLSignal addSignal(String name, JavaRockType given) {
        JavaRockType t = given instanceof StdLogicVector ? this.newReplacedGenericSignalType((StdLogicVector)given) : given;
        return this.m.addSignal(name, t, null, !this.fFieldSignal, false);
    }

    @Override
    public JavaRockComponentIface getComponentIface() {
        if (this.type instanceof CompiledComponentType) {
            return ((CompiledComponentType)this.type).component;
        }
        return Manager.INSTANCE.getComponentIface(this.type);
    }

    @Override
    public void connect() {
        JavaRockComponentIface component = this.getComponentIface();
        this.type.setComponentIface(component);
        component.addOwner(this);
        int i = 0;
        for (VHDLGenericParameter parameter : component.getGenericArrayList()) {
            String v = this.args[i++];
            VHDLConstant c = new VHDLConstant(this.m, String.valueOf(this.name) + "_" + parameter.ident, parameter.type, v);
            this.m.addConstantant(c);
            this.value.put(parameter.ident, v);
        }
        for (VHDLPort port : component.getPortArrayList()) {
            if (port.kind != VHDLPort.Kind.INTERNAL || port.name.equals("clk") || port.name.equals("reset")) continue;
            VHDLSignal s = this.addSignal(String.valueOf(this.name) + "_" + port.name, port.type);
            if (s instanceof VHDLFieldSignal) {
                if (port.dir == VHDLPort.Dir.OUT) {
                    this.portmap.put(port.name, ((VHDLFieldSignal)((Object)s)).getWriteSigName());
                    ((VHDLFieldSignal)((Object)s)).setReadOnly(true);
                    continue;
                }
                this.portmap.put(port.name, ((VHDLFieldSignal)((Object)s)).getReadSigName());
                continue;
            }
            this.portmap.put(port.name, s.name);
        }
    }

    @Override
    public void link() {
    }

    public void addBypassPort(VHDLPort port) {
        VHDLPort bypass = new VHDLPort(this.m, String.valueOf(this.name) + "_" + port.name, port.type, port.dir, VHDLPort.Kind.BYPASS);
        this.portmap.put(port.name, bypass.name);
        if (port.dir == VHDLPort.Dir.IN) {
            this.m.input.put(bypass.name, bypass);
        } else {
            this.m.output.put(bypass.name, bypass);
        }
        for (JavaRockComponentInstance owner : this.m.owners) {
            if (!(owner instanceof VHDLNewComponentInstance)) continue;
            ((VHDLNewComponentInstance)owner).addBypassPort(bypass);
        }
    }

    private void genGenericMap(JavaRockComponentIface component, PrintWriter out, int offset) {
        if (component.getGenericArrayList().size() == 0) {
            return;
        }
        this.writeln(out, String.format("generic map(", new Object[0]), offset);
        String sep = "";
        String pad = this.pad(offset + 2);
        for (VHDLGenericParameter generic : component.getGenericArrayList()) {
            this.write(out, String.format("%s%s%s => %s_%s", sep, pad, generic.ident, this.name, generic.ident));
            sep = ",\n";
        }
        this.write(out, "\n");
        this.writeln(out, ")", offset);
    }

    private void genPortMap(JavaRockComponentIface component, PrintWriter out, int offset) {
        if (component.getPortArrayList().size() == 0) {
            return;
        }
        this.writeln(out, String.format("port map(", new Object[0]), offset);
        String sep = "";
        String pad = this.pad(offset + 2);
        for (VHDLPort port : component.getPortArrayList()) {
            if (port.name.equals("clk") || port.name.equals("reset")) {
                this.write(out, String.format("%s%s%s => %s", sep, pad, port.name, port.name));
            } else {
                this.write(out, String.format("%s%s%s => %s", sep, pad, port.name, this.portmap.get(port.name)));
            }
            sep = ",\n";
        }
        this.write(out, "\n");
        this.writeln(out, ");", offset);
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        this.writeln(out, String.format("U_%s : %s", this.name, this.type.getComponentIface().getName()), offset);
        JavaRockComponentIface component = this.type instanceof CompiledComponentType ? ((CompiledComponentType)this.type).component : Manager.INSTANCE.getComponentIface(this.type);
        this.genGenericMap(component, out, offset);
        this.genPortMap(component, out, offset);
    }

    @Override
    public ComponentType getComponentType() {
        return this.type;
    }
}

