/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.StateSignal;
import net.wasamon.javarock.model.vhdl.VHDLArrayPort;
import net.wasamon.javarock.model.vhdl.VHDLBlock;
import net.wasamon.javarock.model.vhdl.VHDLElement;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLNonBlockAssignStmt;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.VHDLVariable;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import net.wasamon.javarock.tools.types.InstancePointer;

public class VHDLProcess
extends VHDLElement
implements VHDLScopeIface,
VHDLItem {
    VHDLBlock block;
    private final JavaRockType type;
    public final String base;
    private VHDLSignal outp;
    private final Hashtable<String, VHDLSignal> parameters = new Hashtable();
    private final Hashtable<String, VHDLSignal> subparameters = new Hashtable();
    private final ArrayList<VHDLSignal> parameters_list = new ArrayList();
    boolean sequential;
    private final Hashtable<String, VHDLIdent> sensitivities = new Hashtable();
    private final ArrayList<VHDLSignal> resets = new ArrayList();
    public final ArrayList<VHDLVariable> variables = new ArrayList();
    public final VHDLModule module;
    final boolean auto;
    private final ArrayList<Accessor> accessors = new ArrayList();
    private int scopeid;
    final boolean sync;
    final String BUSY_SIGNAL;
    final String REQ_SIGNAL;
    final StateSignal STATE_SIGNAL;
    final int state_base;
    boolean raw = false;
    boolean parallel;
    final boolean privateFlag;
    boolean no_wait = false;

    VHDLProcess(VHDLModule m, JavaRockType type, String base, boolean sync, int state_base, boolean auto2, boolean privateFlag) {
        this.module = m;
        this.base = base;
        this.sync = sync;
        this.state_base = state_base;
        this.auto = auto2;
        this.type = type;
        this.sequential = false;
        this.privateFlag = privateFlag;
        this.scopeid = 0;
        if (sync) {
            this.BUSY_SIGNAL = m.syncproc.getBusySignal();
            this.STATE_SIGNAL = m.syncproc.getStateSignal();
        } else {
            this.BUSY_SIGNAL = String.valueOf(base) + "_method_busy";
            this.STATE_SIGNAL = new StateSignal(String.valueOf(base) + "_method_state");
        }
        this.REQ_SIGNAL = String.valueOf(base) + "_method_request";
    }

    VHDLProcess(VHDLModule m, JavaRockType type, String base, boolean auto2, boolean privateFlag) {
        this(m, type, base, false, auto2 ? 0 : 1, auto2, privateFlag);
    }

    public String getScopeID() {
        int id = this.scopeid++;
        return String.format("%s_%d", this.base, id);
    }

    public int get_last_state() {
        return this.state_base + this.block.state_count() + (this.auto ? 0 : 1);
    }

    @Override
    public void connect() {
        this.block.connect();
    }

    @Override
    public void link() {
        this.block.link();
        int counter = this.state_base;
        if (!this.auto) {
            ++counter;
        }
        this.block.setStateLabelToStatemtns(counter);
    }

    public void optimize() {
        this.block.optimize();
    }

    private String getSensitivityListAsString() {
        String s = "";
        String sp = "";
        Enumeration<VHDLIdent> e = this.sensitivities.elements();
        while (e.hasMoreElements()) {
            VHDLIdent ident = e.nextElement();
            s = String.valueOf(s) + sp + ident;
            sp = ", ";
        }
        return s;
    }

    public void genVariableList(PrintWriter out, int offset) {
        for (VHDLVariable v : this.variables) {
            v.generate(out, offset + 2);
        }
    }

    public String getBusySignal() {
        return "this_" + this.BUSY_SIGNAL;
    }

    public String getReqSignal() {
        VHDLIdent id = this.getIdent("this_" + this.REQ_SIGNAL, VHDLExpr.TERM.RHS);
        return id.toString();
    }

    private void genStateMachinePrologue(PrintWriter out, int offset) {
        this.writeln(out, "when 0 =>", offset);
        this.writeln(out, String.format("if(%s = '1') then", this.getReqSignal()), offset + 2);
        this.writeln(out, String.format("%s <= '1';", this.getBusySignal()), offset + 4);
        this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIGNAL.value(), this.STATE_SIGNAL.value()), offset + 4);
        for (Accessor a : this.accessors) {
            this.writeln(out, String.format("elsif(%s = '1') then", a.req.name), offset + 2);
            this.writeln(out, String.format("%s <= '1';", this.getBusySignal()), offset + 4);
            this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIGNAL.value(), this.STATE_SIGNAL.value()), offset + 4);
        }
        this.writeln(out, "else", offset + 2);
        this.writeln(out, String.format("%s <= '0';", this.getBusySignal()), offset + 4);
        this.writeln(out, "end if;", offset + 2);
    }

    private void genStateMachineEpilogue(PrintWriter out, int offset) {
        if (this.block.statements.size() > 0 && ((VHDLStatement)this.block.statements.get(this.block.statements.size() - 1)).isEndOfState()) {
            this.writeln(out, String.format("when %d =>", this.get_last_state()), offset);
        }
        if (this.auto) {
            this.writeln(out, "null;", offset + 2);
        } else {
            this.writeln(out, String.format("%s <= '0';", this.getBusySignal()), offset + 2);
            this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIGNAL.value()), offset + 2);
        }
    }

    public void genStateMachine(PrintWriter out, int offset) {
        if (!this.auto) {
            this.writeln(out, String.format("when %d =>", this.state_base), offset);
            this.writeln(out, String.format("if(%s = '0') then", this.getReqSignal()), offset + 2);
            this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIGNAL.value(), this.STATE_SIGNAL.value()), offset + 4);
            for (Accessor a : this.accessors) {
                this.writeln(out, String.format("elsif(%s = '0') then", a.req.name), offset + 2);
                this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIGNAL.value(), this.STATE_SIGNAL.value()), offset + 4);
            }
            this.writeln(out, "end if;", offset + 2);
        }
        boolean isStateLabel = true;
        for (VHDLStatement stmt : this.block.statements) {
            if (isStateLabel && !stmt.isSkip()) {
                this.writeln(out, "when " + stmt.getStateLabel() + " => ", offset);
            }
            stmt.generate(out, offset + 2);
            isStateLabel = stmt.isEndOfState();
            if (!isStateLabel || stmt.isStepNext() || stmt.isSkip()) continue;
            this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIGNAL.value(), this.STATE_SIGNAL.value()), offset + 2);
        }
    }

    private String getProcessHeader() {
        String s = "";
        s = String.valueOf(s) + "process";
        s = this.sequential ? String.valueOf(s) + "(clk)" : String.valueOf(s) + "(" + this.getSensitivityListAsString() + ")";
        s = String.valueOf(s) + " --" + this.base;
        return s;
    }

    void genResetStmts(PrintWriter out, int offset) {
        for (VHDLSignal reset : this.resets) {
            this.writeln(out, reset.getResetStmt(), offset);
        }
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        this.writeln(out, this.getProcessHeader(), offset);
        this.genVariableList(out, offset + 2);
        this.writeln(out, "begin", offset);
        if (this.sequential) {
            this.writeln(out, "if (clk'event and clk = '1') then", offset += 2);
            this.writeln(out, "if (reset = '1') then", offset += 2);
            this.genResetStmts(out, offset + 2);
            this.writeln(out, "else", offset);
            offset += 2;
            if (this.parallel) {
                for (VHDLStatement stmt : this.block.statements) {
                    stmt.generate(out, offset + 2);
                }
            } else {
                this.writeln(out, String.format("case conv_integer(%s) is", this.STATE_SIGNAL.value()), offset);
                if (!this.auto) {
                    this.genStateMachinePrologue(out, offset + 2);
                }
                this.genStateMachine(out, offset + 2);
                this.genStateMachineEpilogue(out, offset + 2);
                this.writeln(out, String.format("when others => %s <= (others => '0');", this.STATE_SIGNAL.value()), offset + 2);
                this.writeln(out, "end case;", offset);
            }
            this.writeln(out, "end if;", offset -= 2);
            this.writeln(out, "end if;", offset -= 2);
            offset -= 2;
        } else {
            this.block.generate(out, offset);
        }
        this.writeln(out, "end process; --" + this.base, offset);
    }

    public void setSequentialFlag(boolean flag) {
        VHDLPort port;
        VHDLSignal sig;
        this.sequential = flag;
        if (!flag) {
            return;
        }
        if (!this.auto) {
            this.module.reqTable.put(this.base, this.REQ_SIGNAL);
            if (!this.privateFlag) {
                sig = this.module.addSignal("this_" + this.REQ_SIGNAL, VHDLTypeBuilder.getStdLogic(), null, true, false);
                port = new VHDLPort((JavaRockComponentIface)this.module, this.REQ_SIGNAL, (JavaRockType)VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.IN);
                this.module.input.put(this.REQ_SIGNAL, port);
                this.module.combinations.add(new VHDLNonBlockAssignStmt(this, (VHDLScopeIface)this, new VHDLIdent(sig, VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLIdent(port, VHDLExpr.TERM.RHS)));
            } else {
                this.module.addSignal("this_" + this.REQ_SIGNAL, VHDLTypeBuilder.getStdLogic(), null, false, false);
            }
        }
        if (!this.sync) {
            if (!this.auto) {
                this.module.busyTable.put(this.base, this.BUSY_SIGNAL);
                sig = this.module.addSignal("this_" + this.BUSY_SIGNAL, VHDLTypeBuilder.getStdLogic(), null, true, false);
                if (!this.privateFlag) {
                    port = new VHDLPort((JavaRockComponentIface)this.module, this.BUSY_SIGNAL, (JavaRockType)VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.OUT);
                    this.module.output.put(port.name, port);
                    this.module.combinations.add(new VHDLNonBlockAssignStmt(this, (VHDLScopeIface)this, new VHDLIdent(port, VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLIdent(sig, VHDLExpr.TERM.RHS)));
                }
                this.addResetStmt(sig);
            }
            sig = this.module.addSignal(this.STATE_SIGNAL.value(), VHDLTypeBuilder.getStdLogicVector(31, 0), null, true, false);
            this.addResetStmt(sig);
            this.module.setSequential(flag);
        }
    }

    public void addResetStmt(VHDLSignal sig) {
        this.resets.add(sig);
        sig.setResetProcess(this);
    }

    public void setParallelFlag(boolean flag) {
        this.parallel = flag;
    }

    public void setBlock(VHDLBlock block) {
        this.block = block;
    }

    public String getInputParamName(String name) {
        return String.format("input_port_%s_%s", this.base, name);
    }

    public VHDLPort addParameter(VHDLArrayType type, String name) {
        if (this.privateFlag) {
            throw new RuntimeException("array has not been supported as parameter for private function yet.");
        }
        VHDLArrayPort port = new VHDLArrayPort(this, this.getInputParamName(name), type, VHDLPort.Dir.IN);
        this.parameters.put(name, port);
        for (VHDLPort p : port.ports.values()) {
            this.subparameters.put(p.name, p);
        }
        this.module.input.put(port.name, port);
        this.parameters_list.add(port);
        return port;
    }

    public VHDLSignal addParameter(JavaRockType type, String name) {
        VHDLSignal sig;
        if (type instanceof VHDLArrayType) {
            return this.addParameter((VHDLArrayType)type, name);
        }
        if (!this.privateFlag) {
            sig = this.module.addSignal("this_" + this.getInputParamName(name), type, null, true, false);
            VHDLPort port = new VHDLPort((JavaRockComponentIface)this.module, this.getInputParamName(name), type, VHDLPort.Dir.IN);
            this.module.input.put(port.name, port);
            this.module.combinations.add(new VHDLNonBlockAssignStmt(this, (VHDLScopeIface)this, new VHDLIdent(sig, VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLIdent(port, VHDLExpr.TERM.RHS)));
            sig = port;
        } else {
            sig = this.module.addSignal("this_" + this.getInputParamName(name), type, null, false, false);
        }
        this.parameters.put(name, sig);
        this.parameters_list.add(sig);
        return sig;
    }

    private String getReturnName() {
        return String.format("output_port_%s", this.base);
    }

    public VHDLPort addOutputPort(VHDLArrayType type) {
        if (this.privateFlag) {
            new RuntimeException("array is not supported as return type of private function.");
        }
        VHDLArrayPort port = new VHDLArrayPort(this, this.getReturnName(), type, VHDLPort.Dir.OUT);
        this.module.output.put(port.name, port);
        this.outp = port;
        return port;
    }

    public VHDLSignal addOutputPort(JavaRockType type) {
        VHDLSignal sig;
        if (type instanceof VHDLArrayType) {
            return this.addOutputPort((VHDLArrayType)type);
        }
        if (this.privateFlag) {
            sig = this.module.addSignal("this_" + this.getReturnName(), type, null, true, false);
        } else {
            sig = new VHDLPort((JavaRockComponentIface)this.module, this.getReturnName(), type, VHDLPort.Dir.OUT);
            this.module.output.put(sig.name, (VHDLPort)sig);
        }
        this.outp = sig;
        return sig;
    }

    public VHDLSignal getOutputPort() {
        return this.outp;
    }

    void addSensitive(VHDLIdent ident) {
        if (!this.sensitivities.containsKey(ident.sym)) {
            this.sensitivities.put(ident.sym, ident);
        }
    }

    @Override
    public StateSignal get_state_sig() {
        return this.STATE_SIGNAL;
    }

    @Override
    public VHDLIdent getIdent(String name, VHDLExpr.TERM t) {
        if (this.parameters.containsKey(name)) {
            return new VHDLIdent(this.parameters.get(name), t);
        }
        if (this.subparameters.containsKey(name)) {
            return new VHDLIdent(this.subparameters.get(name), t);
        }
        return this.module.getIdent(name, t);
    }

    @Override
    public boolean hasIdent(String name) {
        if (this.parameters.containsKey(name)) {
            return true;
        }
        return this.module.hasIdent(name);
    }

    @Override
    public void add(VHDLStatement stmt) {
        this.block.add(stmt);
    }

    @Override
    public VHDLSignal addSignal(JavaRockType t, String name) {
        return this.block.addSignal(t, name);
    }

    @Override
    public void addVariable(JavaRockType t, String name) {
        this.block.addVariable(t, name);
    }

    @Override
    public VHDLScopeIface getParent() {
        return null;
    }

    public JavaRockType getType() {
        return this.type;
    }

    public Collection<VHDLSignal> parameters() {
        return this.parameters_list;
    }

    public boolean isPrivate() {
        return this.privateFlag;
    }

    public void setRawFlag(boolean flag) {
        this.raw = flag;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public void setNoWaitFlag(boolean flag) {
        this.no_wait = flag;
    }

    public boolean isNoWait() {
        return this.no_wait;
    }

    public void addAccessor(InstancePointer pointer) {
        Accessor a = new Accessor(pointer);
        this.accessors.add(a);
        if (!this.sync) {
            this.module.combinations.add(new VHDLNonBlockAssignStmt(this, (VHDLScopeIface)this, new VHDLIdent(a.busy, VHDLExpr.TERM.LHS), (VHDLExpr)this.getIdent("this_" + this.BUSY_SIGNAL, VHDLExpr.TERM.RHS)));
        }
    }

    class Accessor {
        final InstancePointer pointer;
        final VHDLSignal busy;
        final VHDLSignal req;

        public Accessor(InstancePointer p) {
            this.pointer = p;
            this.req = VHDLProcess.this.module.addSignal(String.format("%s_%s_%s_method_request_port", p.owner().getName(), p.name(), VHDLProcess.this.base), VHDLTypeBuilder.getStdLogic(), null, true, false);
            this.busy = VHDLProcess.this.module.addSignal(String.format("%s_%s_%s_method_busy", p.owner().getName(), p.name(), VHDLProcess.this.base), VHDLTypeBuilder.getStdLogic(), null, true, false);
        }
    }
}

