/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.Hashtable;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.StateSignal;
import net.wasamon.javarock.model.vhdl.VHDLElement;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLNonBlockAssignStmt;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;

public class VHDLSynchronizedProcess
extends VHDLElement
implements VHDLItem {
    final VHDLModule m;
    final Hashtable<String, VHDLProcess> processes = new Hashtable();
    private final String BUSY_SIGNAL;
    private final StateSignal STATE_SIGNAL;
    private int state_base;
    private VHDLProcess last_process;
    private final VHDLSignal stateSig;
    private final VHDLSignal busySig;

    public VHDLSynchronizedProcess(VHDLModule m) {
        this.m = m;
        this.state_base = 1;
        this.last_process = null;
        this.BUSY_SIGNAL = String.valueOf(m.getName()) + "_method_busy";
        this.STATE_SIGNAL = new StateSignal(String.valueOf(m.getName()) + "_method_state");
        m.setSequential(true);
        this.stateSig = m.addSignal(this.getStateSignal().value(), VHDLTypeBuilder.getStdLogicVector(31, 0), null, true, false);
        this.busySig = m.addSignal("this_" + this.BUSY_SIGNAL, VHDLTypeBuilder.getStdLogic(), null, true, false);
        VHDLPort busyPort = new VHDLPort((JavaRockComponentIface)m, this.BUSY_SIGNAL, (JavaRockType)VHDLTypeBuilder.getStdLogic(), VHDLPort.Dir.OUT);
        m.output.put(this.BUSY_SIGNAL, busyPort);
        m.combinations.add(new VHDLNonBlockAssignStmt(null, null, new VHDLIdent(busyPort, VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLIdent(this.busySig, VHDLExpr.TERM.RHS)));
    }

    public VHDLProcess newProcess(JavaRockType type, String name, boolean privateFlag) {
        if (this.last_process != null) {
            this.state_base = this.last_process.get_last_state() + 1;
        }
        VHDLProcess p = new VHDLProcess(this.m, type, name, true, this.state_base, false, privateFlag);
        this.processes.put(name, p);
        this.last_process = p;
        this.m.busyTable.put(name, this.BUSY_SIGNAL);
        return p;
    }

    public String getBusySignal() {
        return "this_" + this.BUSY_SIGNAL;
    }

    public StateSignal getStateSignal() {
        return this.STATE_SIGNAL;
    }

    private void genVariableListAsString(PrintWriter out, int offset) {
        for (VHDLProcess p : this.processes.values()) {
            p.genVariableList(out, offset);
        }
    }

    private void genMethodPrologue(PrintWriter out, int offset) {
        this.writeln(out, "when 0 => ", offset);
        String branch = "if";
        for (VHDLProcess p : this.processes.values()) {
            this.writeln(out, String.format("%s(%s = '1') then", branch, p.getReqSignal()), offset + 2);
            this.writeln(out, String.format("%s <= '1';", this.getBusySignal()), offset + 4);
            this.writeln(out, String.format("%s <= conv_std_logic_vector(%d, 32);", this.getStateSignal().value(), p.state_base), offset + 4);
            branch = "elsif";
        }
        this.writeln(out, "else", offset + 2);
        this.writeln(out, String.format("%s <= '0';", this.getBusySignal()), offset + 4);
        this.writeln(out, "end if;", offset + 2);
    }

    private void genAllBlockString(PrintWriter out, int offset) {
        this.genMethodPrologue(out, offset);
        for (VHDLProcess p : this.processes.values()) {
            p.genStateMachine(out, offset);
            this.writeln(out, String.format("when %d =>", p.get_last_state()), offset);
            this.writeln(out, String.format("%s <= '0';", this.getBusySignal()), offset + 2);
            this.writeln(out, String.format("%s <= (others => '0');", this.getStateSignal().value()), offset + 2);
        }
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        this.writeln(out, "process (clk) -- synchronized", offset);
        this.genVariableListAsString(out, offset += 2);
        this.writeln(out, "begin", offset -= 2);
        this.writeln(out, "if (clk'event and clk = '1') then", offset += 2);
        this.writeln(out, "if (reset = '1') then", offset += 2);
        for (VHDLProcess p : this.processes.values()) {
            p.genResetStmts(out, offset + 2);
        }
        this.writeln(out, this.stateSig.getResetStmt(), offset + 2);
        this.writeln(out, this.busySig.getResetStmt(), offset + 2);
        this.writeln(out, "else", offset);
        this.writeln(out, String.format("case conv_integer(%s) is", this.STATE_SIGNAL.value()), offset += 2);
        this.genAllBlockString(out, offset += 2);
        this.writeln(out, String.format("when others => %s <= (others => '0');", this.STATE_SIGNAL.value()), (offset -= 2) + 2);
        this.writeln(out, "end case;", offset);
        this.writeln(out, "end if;", offset -= 2);
        this.writeln(out, "end if;", offset -= 2);
        this.writeln(out, "end process; -- synchronized", offset -= 2);
    }

    @Override
    public void connect() {
        for (VHDLProcess p : this.processes.values()) {
            p.connect();
        }
    }

    @Override
    public void link() {
        for (VHDLProcess p : this.processes.values()) {
            p.link();
        }
    }
}

