/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.tools;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.lang.model.type.ArrayType;
import net.wasamon.javarock.model.GlobalConstantTable;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.ArrayRef;
import net.wasamon.javarock.model.vhdl.StaticFieldAccess;
import net.wasamon.javarock.model.vhdl.VHDLArrayAccess;
import net.wasamon.javarock.model.vhdl.VHDLBinaryExpr;
import net.wasamon.javarock.model.vhdl.VHDLBlock;
import net.wasamon.javarock.model.vhdl.VHDLBreak;
import net.wasamon.javarock.model.vhdl.VHDLConstant;
import net.wasamon.javarock.model.vhdl.VHDLContinue;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLExprStatement;
import net.wasamon.javarock.model.vhdl.VHDLFieldAccess;
import net.wasamon.javarock.model.vhdl.VHDLFor;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLIf;
import net.wasamon.javarock.model.vhdl.VHDLLiteral;
import net.wasamon.javarock.model.vhdl.VHDLMethodInvoke;
import net.wasamon.javarock.model.vhdl.VHDLMethodReturnValueIdent;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLNewArray;
import net.wasamon.javarock.model.vhdl.VHDLNewComponentInstance;
import net.wasamon.javarock.model.vhdl.VHDLNonBlockAssignStmt;
import net.wasamon.javarock.model.vhdl.VHDLOp;
import net.wasamon.javarock.model.vhdl.VHDLParenExpr;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLRawIf;
import net.wasamon.javarock.model.vhdl.VHDLReturn;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.VHDLSkip;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.VHDLSwitch;
import net.wasamon.javarock.model.vhdl.VHDLSynchronizedProcess;
import net.wasamon.javarock.model.vhdl.VHDLUnaryExpr;
import net.wasamon.javarock.model.vhdl.VHDLWhile;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import net.wasamon.javarock.tools.types.ComponentType;
import net.wasamon.javarock.tools.types.VoidType;
import openjdk.com.sun.source.tree.Tree;
import openjdk.com.sun.tools.javac.code.Symbol;
import openjdk.com.sun.tools.javac.tree.JCTree;

public enum JavaEntry {
    INSTANCE;


    private boolean isExtended(String label, JCTree that) {
        return label.equals(that.toString());
    }

    public VHDLModule buildVHDLModule(JCTree.JCClassDecl decl, boolean runnable, Hashtable<String, String> importTable) {
        VHDLModule m = new VHDLModule(decl.sym.toString(), runnable, importTable);
        if (this.isAnnotatedBy(decl.mods.annotations, "javarockhdl")) {
            m.setJavaRockHDL(true);
        }
        if (decl.extending != null && this.isExtended("Thread", decl.extending)) {
            m.setThread(true);
        }
        for (JCTree def : decl.defs) {
            if (def == null) continue;
            if (def instanceof JCTree.JCMethodDecl) {
                this.buildProcess(m, (JCTree.JCMethodDecl)def);
                continue;
            }
            if (def instanceof JCTree.JCVariableDecl) {
                this.buildSignal(m, (JCTree.JCVariableDecl)def);
                continue;
            }
            System.out.printf("else@JavaEntry: %s (%s)", def, def.getClass());
        }
        return m;
    }

    private boolean isConstructor(JCTree.JCMethodDecl decl) {
        return "<init>".equals(decl.getName().toString());
    }

    private void buildSignal(VHDLModule m, JCTree.JCVariableDecl that) {
        String name = that.getName().toString();
        JavaRockType t = this.genType(that.mods.annotations, that.getType());
        if (t instanceof ComponentType) {
            if (that.init != null) {
                if (!(that.init instanceof JCTree.JCNewClass)) {
                    throw new RuntimeException(String.format("Invalid argument to initialize an instance: %s [%s]", that.init, that.init.getClass()));
                }
                m.addComponent((ComponentType)t);
                VHDLNewComponentInstance instance = m.newComponentInstance(name, (ComponentType)t, that.init != null, true);
                if (that.init != null && that.init instanceof JCTree.JCNewClass) {
                    String[] args = this.getNewInstanceArgs((JCTree.JCNewClass)that.init);
                    instance.setArgs(args);
                }
            } else {
                m.addInstancePointer((ComponentType)t, name);
            }
        } else if (t instanceof VHDLArrayType) {
            if (that.init != null) {
                VHDLExpr reset = this.buildExpr(null, (VHDLScopeIface)m, that.init, VHDLExpr.TERM.RHS);
                m.addSignal(name, t, reset, false, false);
            } else {
                m.addInstancePointer((VHDLArrayType)t, name);
            }
        } else {
            VHDLExpr reset = null;
            if (that.init != null) {
                reset = this.buildExpr(null, null, that.init, VHDLExpr.TERM.RHS);
            }
            if (reset instanceof VHDLLiteral && this.isFinal(that.mods)) {
                VHDLConstant c = new VHDLConstant(m, name, reset.getType(), reset.toString());
                m.addConstantant(c);
                if (this.isGlobalConstant(that.mods)) {
                    GlobalConstantTable.INSTANCE.put(m.getOrigName(), c.name(), reset.toString());
                }
            } else {
                m.addSignal(name, t, reset, false, !this.isPrivate(that.mods));
            }
        }
    }

    private String[] getNewInstanceArgs(JCTree.JCNewClass that) {
        ArrayList<String> args = new ArrayList<String>();
        if (that.args.size() == 0) {
            return new String[0];
        }
        for (JCTree.JCExpression arg : that.args) {
            if (arg instanceof JCTree.JCNewArray) {
                JCTree.JCNewArray array = (JCTree.JCNewArray)arg;
                for (JCTree.JCExpression expr : array.elems) {
                    args.add(this.buildExpr(null, null, expr, VHDLExpr.TERM.RHS).toString());
                }
                continue;
            }
            if (arg instanceof JCTree.JCIdent) {
                args.add(arg.toString());
                continue;
            }
            System.err.printf("%s[%s] is not supported as parameter for constructor.\n", that.args.get(0), that.args.get(0).getClass());
        }
        return args.toArray(new String[0]);
    }

    private VHDLStatement buildVariable(VHDLProcess p, VHDLScopeIface scope, JCTree.JCVariableDecl that) {
        String name = that.name.toString();
        JavaRockType t = this.genType(that.mods.annotations, that.getType());
        if (t instanceof ComponentType) {
            p.module.addInstancePointer((ComponentType)t, name);
            return null;
        }
        if (t instanceof VHDLArrayType) {
            p.module.addInstancePointer((VHDLArrayType)t, name);
            return null;
        }
        scope.addSignal(t, name);
        if (that.init != null) {
            return new VHDLNonBlockAssignStmt(p, scope, scope.getIdent(name, VHDLExpr.TERM.LHS), this.buildExpr(p, scope, that.init, VHDLExpr.TERM.RHS));
        }
        return null;
    }

    private JCTree.JCExpression getVariableWidth(List<JCTree.JCAnnotation> annotations) throws UseJavaDefaultType, IllegalArgumentException {
        for (JCTree.JCAnnotation annotation : annotations) {
            JCTree t = annotation.getAnnotationType();
            if (!(t instanceof JCTree.JCIdent) || !((JCTree.JCIdent)t).sym.toString().endsWith("width")) continue;
            return this.getKeyValue("size", annotation.getArguments());
        }
        throw new UseJavaDefaultType();
    }

    private JCTree.JCExpression getKeyValue(String key, List<JCTree.JCExpression> args) throws IllegalArgumentException {
        for (JCTree.JCExpression expr : args) {
            if (!(expr instanceof JCTree.JCAssign) || !(((JCTree.JCAssign)expr).lhs instanceof JCTree.JCIdent) || !((JCTree.JCIdent)((JCTree.JCAssign)expr).lhs).toString().equals("size")) continue;
            return ((JCTree.JCAssign)expr).rhs;
        }
        throw new IllegalArgumentException();
    }

    private JavaRockType genType(List<JCTree.JCAnnotation> annotations, JCTree type) {
        try {
            JavaRockType t = VHDLTypeBuilder.getType(this.getVariableWidth(annotations));
            return t;
        }
        catch (UseJavaDefaultType e) {
            return VHDLTypeBuilder.getType(type);
        }
    }

    private boolean isAnnotatedBy(List<JCTree.JCAnnotation> annotations, String key) {
        for (JCTree.JCAnnotation a : annotations) {
            Symbol s;
            if (!(a.getAnnotationType() instanceof JCTree.JCIdent) || !(s = ((JCTree.JCIdent)a.getAnnotationType()).sym).toString().endsWith(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isSynchronized(JCTree.JCModifiers mods) {
        if (mods == null) {
            return false;
        }
        return (mods.flags & 0x20L) == 32L;
    }

    private boolean isPrivate(JCTree.JCModifiers mods) {
        if (mods == null) {
            return false;
        }
        return (mods.flags & 2L) == 2L;
    }

    private boolean isFinal(JCTree.JCModifiers mods) {
        if (mods == null) {
            return false;
        }
        return (mods.flags & 0x10L) == 16L;
    }

    private boolean isGlobalConstant(JCTree.JCModifiers mods) {
        if (mods == null) {
            return false;
        }
        boolean f = true;
        f &= (mods.flags & 1L) == 1L;
        f &= (mods.flags & 0x10L) == 16L;
        return f &= (mods.flags & 8L) == 8L;
    }

    public void buildProcess(VHDLModule m, JCTree.JCMethodDecl that) {
        VHDLProcess p;
        if (this.isConstructor(that)) {
            return;
        }
        if (this.isAnnotatedBy(that.mods.annotations, "unsynthesizable")) {
            return;
        }
        String base = that.getName().toString();
        JavaRockType t = this.genType(that.mods.annotations, that.getReturnType());
        boolean privateFlag = this.isPrivate(that.mods);
        if (this.isSynchronized(that.mods)) {
            VHDLSynchronizedProcess sync = m.getSynchronizedProcess();
            if (sync == null) {
                sync = m.setSynchronizedProcess(new VHDLSynchronizedProcess(m));
            }
            p = sync.newProcess(t, base, privateFlag);
        } else {
            boolean auto2 = this.isAnnotatedBy(that.mods.annotations, "auto") && m.isJavaRockHDL();
            p = m.newProcess(t, base, auto2, privateFlag);
        }
        if (t != VHDLTypeBuilder.getVoidType()) {
            p.addOutputPort(t);
        }
        for (JCTree.JCVariableDecl param : that.getParameters()) {
            JavaRockType paramType = this.genType(param.mods.annotations, param.getType());
            p.addParameter(paramType, param.getName().toString());
        }
        p.setRawFlag(this.isAnnotatedBy(that.mods.annotations, "raw"));
        p.setBlock(this.buildBlockStatement(p, p, that.body));
        p.setSequentialFlag(!this.isAnnotatedBy(that.mods.annotations, "combination"));
        p.setParallelFlag(this.isAnnotatedBy(that.mods.annotations, "parallel"));
        p.setNoWaitFlag(this.isAnnotatedBy(that.mods.annotations, "no_wait"));
    }

    private VHDLStatement buildStatement(VHDLProcess p, VHDLScopeIface scope, JCTree.JCStatement that) {
        if (that instanceof JCTree.JCIf) {
            return this.buildIf(p, scope, (JCTree.JCIf)that);
        }
        if (that instanceof JCTree.JCForLoop) {
            return this.buildFor(p, scope, (JCTree.JCForLoop)that);
        }
        if (that instanceof JCTree.JCWhileLoop) {
            return this.buildWhile(p, scope, (JCTree.JCWhileLoop)that);
        }
        if (that instanceof JCTree.JCBlock) {
            return this.buildBlockStatement(p, scope, (JCTree.JCBlock)that);
        }
        if (that instanceof JCTree.JCReturn) {
            return this.buildReturn(p, scope, (JCTree.JCReturn)that);
        }
        if (that instanceof JCTree.JCExpressionStatement) {
            return this.buildExprStmt(p, scope, (JCTree.JCExpressionStatement)that);
        }
        if (that instanceof JCTree.JCVariableDecl) {
            return this.buildVariable(p, scope, (JCTree.JCVariableDecl)that);
        }
        if (that instanceof JCTree.JCBreak) {
            return new VHDLBreak(p, scope);
        }
        if (that instanceof JCTree.JCContinue) {
            return new VHDLContinue(p, scope);
        }
        if (that instanceof JCTree.JCSkip) {
            return new VHDLSkip();
        }
        if (that instanceof JCTree.JCTry) {
            return this.buildTryStatement(p, scope, (JCTree.JCTry)that);
        }
        if (that instanceof JCTree.JCSynchronized) {
            return this.buildBlockStatement(p, scope, ((JCTree.JCSynchronized)that).body);
        }
        if (that instanceof JCTree.JCSwitch) {
            return this.buildSwitch(p, scope, (JCTree.JCSwitch)that);
        }
        System.err.printf("else@buildStatement: %s (%s)\n", that, that.getClass());
        return null;
    }

    private VHDLStatement buildSwitch(VHDLProcess p, VHDLScopeIface scope, JCTree.JCSwitch that) {
        VHDLSwitch stmt = new VHDLSwitch(p, scope);
        JCTree.JCExpression cond = that.selector;
        stmt.setCond(this.buildExpr(p, scope, cond, VHDLExpr.TERM.RHS));
        for (JCTree.JCCase caseStmt : that.cases) {
            VHDLSwitch.SwitchElement elem = null;
            elem = caseStmt.pat != null ? stmt.getNewElement(this.buildExpr(p, (VHDLScopeIface)stmt, caseStmt.pat, VHDLExpr.TERM.RHS)) : stmt.getNewElement();
            for (JCTree.JCStatement stat : caseStmt.stats) {
                elem.add(this.buildStatement(p, elem, stat));
            }
        }
        return stmt;
    }

    private VHDLStatement buildExprStmt(VHDLProcess p, VHDLScopeIface scope, JCTree.JCExpressionStatement that) {
        if (that.expr instanceof JCTree.JCUnary) {
            return new VHDLExprStatement(p, this.convUnaryExpr(p, scope, (JCTree.JCUnary)that.expr));
        }
        if (that.expr instanceof JCTree.JCExpression) {
            VHDLExpr expr = this.buildExpr(p, scope, that.expr, VHDLExpr.TERM.RHS);
            if (expr != null) {
                return new VHDLExprStatement(p, expr);
            }
            return null;
        }
        System.err.printf("else@buildExprStatement: %s (%s)\n", that.expr, that.expr.getClass());
        return null;
    }

    private VHDLExpr convUnaryExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCUnary expr) {
        if ("++".equals(expr.operator.name.toString())) {
            VHDLBinaryExpr b = new VHDLBinaryExpr(p, scope, VHDLOp.PLUS, scope.getIdent(expr.arg.toString(), VHDLExpr.TERM.RHS), new VHDLLiteral("1", Tree.Kind.INT_LITERAL));
            return new VHDLBinaryExpr(p, scope, VHDLOp.NONBLOCKING_ASSIGN, scope.getIdent(expr.arg.toString(), VHDLExpr.TERM.LHS), b);
        }
        if ("--".equals(expr.operator.name.toString())) {
            VHDLBinaryExpr b = new VHDLBinaryExpr(p, scope, VHDLOp.MINUS, scope.getIdent(expr.arg.toString(), VHDLExpr.TERM.RHS), new VHDLLiteral("1", Tree.Kind.INT_LITERAL));
            return new VHDLBinaryExpr(p, scope, VHDLOp.NONBLOCKING_ASSIGN, scope.getIdent(expr.arg.toString(), VHDLExpr.TERM.LHS), b);
        }
        System.err.printf("convUnaryExpr: %s\n", expr.operator.name);
        return null;
    }

    private VHDLBlock buildBlockStatement(VHDLProcess process, VHDLScopeIface parent, JCTree.JCBlock that) {
        VHDLBlock block = new VHDLBlock(process, parent);
        for (JCTree.JCStatement stmt : that.getStatements()) {
            VHDLStatement s = this.buildStatement(process, block, stmt);
            if (s == null) continue;
            block.add(s);
        }
        return block;
    }

    private VHDLBlock buildTryStatement(VHDLProcess process, VHDLScopeIface parent, JCTree.JCTry that) {
        return this.buildBlockStatement(process, parent, that.body);
    }

    private VHDLIf buildIf(VHDLProcess p, VHDLScopeIface scope, JCTree.JCIf that) {
        VHDLIf stmt = p.module.isJavaRockHDL() && p.isRaw() ? new VHDLRawIf(p, scope) : new VHDLIf(p, scope);
        stmt.cond = this.buildExprCond(p, stmt, that.cond, VHDLExpr.TERM.RHS);
        stmt.thenpart = this.buildStatement(p, stmt, that.thenpart);
        if (that.elsepart != null) {
            stmt.elsepart = this.buildStatement(p, stmt, that.elsepart);
        }
        return stmt;
    }

    private VHDLWhile buildWhile(VHDLProcess p, VHDLScopeIface scope, JCTree.JCWhileLoop that) {
        VHDLWhile stmt = new VHDLWhile(p, scope);
        stmt.cond = this.buildExprCond(p, stmt, that.cond, VHDLExpr.TERM.RHS);
        stmt.body = this.buildStatement(p, stmt, that.body);
        return stmt;
    }

    private VHDLFor buildFor(VHDLProcess p, VHDLScopeIface scope, JCTree.JCForLoop that) {
        VHDLStatement s;
        VHDLFor stmt = new VHDLFor(p, scope);
        for (JCTree.JCStatement jCStatement : that.init) {
            s = this.buildStatement(p, stmt, jCStatement);
            stmt.init.add(s);
        }
        stmt.cond = this.buildExprCond(p, stmt, that.cond, VHDLExpr.TERM.RHS);
        for (JCTree.JCStatement jCStatement : that.step) {
            s = this.buildStatement(p, stmt, jCStatement);
            stmt.step.add(s);
        }
        stmt.body = this.buildStatement(p, stmt, that.body);
        return stmt;
    }

    private VHDLStatement buildReturn(VHDLProcess p, VHDLScopeIface scope, JCTree.JCReturn that) {
        if (p.getType() instanceof VoidType) {
            return new VHDLReturn(p, scope, null);
        }
        VHDLExpr rhs = this.buildExpr(p, scope, that.expr, VHDLExpr.TERM.RHS);
        return new VHDLReturn(p, scope, new VHDLNonBlockAssignStmt(p, scope, new VHDLIdent(p.getOutputPort(), VHDLExpr.TERM.LHS), rhs));
    }

    private VHDLExpr buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCExpression that, VHDLExpr.TERM t) {
        if (that instanceof JCTree.JCIdent) {
            String name = ((JCTree.JCIdent)that).sym.toString();
            VHDLIdent ident = scope.getIdent(name, t);
            return ident;
        }
        if (that instanceof JCTree.JCBinary) {
            return this.buildExpr(p, scope, (JCTree.JCBinary)that, t);
        }
        if (that instanceof JCTree.JCUnary) {
            return this.buildExpr(p, scope, (JCTree.JCUnary)that, t);
        }
        if (that instanceof JCTree.JCMethodInvocation) {
            return this.buildExpr(p, scope, (JCTree.JCMethodInvocation)that, t);
        }
        if (that instanceof JCTree.JCFieldAccess) {
            return this.buildExpr(p, scope, (JCTree.JCFieldAccess)that, t);
        }
        if (that instanceof JCTree.JCLiteral) {
            return this.buildExpr(p, scope, (JCTree.JCLiteral)that, t);
        }
        if (that instanceof JCTree.JCAssign) {
            return this.buildExpr(p, scope, (JCTree.JCAssign)that, t);
        }
        if (that instanceof JCTree.JCAssignOp) {
            return this.buildExpr(p, scope, (JCTree.JCAssignOp)that, t);
        }
        if (that instanceof JCTree.JCNewArray) {
            return this.buildExpr(p, scope, (JCTree.JCNewArray)that, t);
        }
        if (that instanceof JCTree.JCArrayAccess) {
            return this.buildExpr(p, scope, (JCTree.JCArrayAccess)that, t);
        }
        if (that instanceof JCTree.JCTypeCast) {
            return this.buildExpr(p, scope, (JCTree.JCTypeCast)that, t);
        }
        if (that instanceof JCTree.JCParens) {
            return this.buildExpr(p, scope, (JCTree.JCParens)that, t);
        }
        System.err.printf("unsupported expr: %s (%s)\n", that, that.getClass());
        return null;
    }

    private String getMethodName(String name) {
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            return name.substring(pos + 1);
        }
        return name;
    }

    private String getInstanceName(String name) {
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return "this";
    }

    private VHDLExpr buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCParens that, VHDLExpr.TERM t) {
        return new VHDLParenExpr(this.buildExpr(p, scope, that.expr, t));
    }

    private VHDLExpr buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCTypeCast that, VHDLExpr.TERM t) {
        return this.buildExpr(p, scope, that.expr, t);
    }

    private VHDLLiteral buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCLiteral that, VHDLExpr.TERM t) {
        return new VHDLLiteral(that.getValue(), that.getKind());
    }

    private VHDLArrayAccess buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCArrayAccess that, VHDLExpr.TERM t) {
        return new VHDLArrayAccess(p, scope, this.buildExpr(p, scope, that.indexed, VHDLExpr.TERM.RHS), this.buildExpr(p, scope, that.index, VHDLExpr.TERM.RHS), t);
    }

    private VHDLExpr buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCFieldAccess that, VHDLExpr.TERM t) {
        String instanceName = that.selected.toString();
        if (!p.hasIdent(instanceName)) {
            return new StaticFieldAccess(instanceName, that.toString());
        }
        if (that.selected instanceof JCTree.JCArrayAccess) {
            JCTree.JCArrayAccess expr = (JCTree.JCArrayAccess)that.selected;
            return new VHDLFieldAccess(p, scope, scope.getIdent(expr.indexed.toString(), t), that.name.toString());
        }
        return new VHDLFieldAccess(p, scope, scope.getIdent(that.selected.toString(), t), that.name.toString());
    }

    private VHDLExpr buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCNewArray that, VHDLExpr.TERM t) {
        VHDLNewArray a = null;
        if (that.elemtype != null) {
            a = new VHDLNewArray(VHDLTypeBuilder.getType(that.elemtype), that.dims.toString());
        } else if (that.type instanceof ArrayType) {
            ArrayType type = (ArrayType)((Object)that.type);
            ArrayList<VHDLExpr> list = new ArrayList<VHDLExpr>();
            for (JCTree.JCExpression expr : that.elems) {
                list.add(this.buildExpr(p, scope, expr, t));
            }
            a = new VHDLNewArray(VHDLTypeBuilder.getType(type.getComponentType().getKind()), list);
        } else {
            System.out.println("Unsupported: " + that);
        }
        return a;
    }

    private VHDLExpr buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCMethodInvocation that, VHDLExpr.TERM t) {
        int pos;
        String method = that.getMethodSelect().toString();
        ArrayList<VHDLExpr> args = new ArrayList<VHDLExpr>();
        for (JCTree.JCExpression expr : that.args) {
            args.add(this.buildExpr(p, scope, expr, VHDLExpr.TERM.RHS));
        }
        String instanceName = this.getInstanceName(method);
        String methodName = this.getMethodName(method);
        if (instanceName.startsWith("System")) {
            return null;
        }
        if (instanceName.startsWith("Math")) {
            instanceName = "JavaRockMath";
        }
        if ((pos = instanceName.indexOf(91)) > 0) {
            instanceName = instanceName.substring(0, pos);
        }
        VHDLMethodInvoke invoke = new VHDLMethodInvoke(p, scope, instanceName, methodName, args);
        scope.add(new VHDLMethodInvoke(p, scope, instanceName, methodName, args));
        return new VHDLMethodReturnValueIdent(p.module, scope, this.getInstanceName(method), this.getMethodName(method), invoke);
    }

    private VHDLExpr buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCUnary that, VHDLExpr.TERM t) {
        return new VHDLUnaryExpr(p, VHDLOp.getOp(that.operator.name.toString()), this.buildExpr(p, scope, that.arg, t));
    }

    private VHDLExpr buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCBinary that, VHDLExpr.TERM t) {
        return new VHDLBinaryExpr(p, scope, VHDLOp.getOp(that.operator.name.toString()), this.buildExpr(p, scope, that.lhs, t), this.buildExpr(p, scope, that.rhs, t));
    }

    private VHDLExpr buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCAssign that, VHDLExpr.TERM t) {
        VHDLExpr rhs = this.buildExpr(p, scope, that.rhs, VHDLExpr.TERM.RHS);
        String name = that.lhs.toString();
        if (that.lhs instanceof JCTree.JCArrayAccess) {
            VHDLArrayAccess lhs = this.buildExpr(p, scope, (JCTree.JCArrayAccess)that.lhs, VHDLExpr.TERM.LHS);
            return new VHDLBinaryExpr(p, scope, VHDLOp.NONBLOCKING_ASSIGN, lhs, rhs);
        }
        if (that.lhs instanceof JCTree.JCFieldAccess) {
            VHDLExpr lhs = this.buildExpr(p, scope, (JCTree.JCFieldAccess)that.lhs, VHDLExpr.TERM.LHS);
            return new VHDLBinaryExpr(p, scope, VHDLOp.NONBLOCKING_ASSIGN, lhs, rhs);
        }
        VHDLIdent lhs = scope.getIdent(name, VHDLExpr.TERM.LHS);
        if (lhs == null) {
            System.err.printf("undefined variable: %s\n", that.lhs.toString());
        }
        if (lhs.var instanceof VHDLSignal) {
            return new VHDLBinaryExpr(p, scope, VHDLOp.NONBLOCKING_ASSIGN, lhs, rhs);
        }
        if (lhs.var.type() instanceof ArrayRef) {
            ((ArrayRef)lhs.var.type()).setPointTo(p, rhs);
            return new VHDLBinaryExpr(p, scope, VHDLOp.POINTER_CONNECT, lhs, rhs);
        }
        return new VHDLBinaryExpr(p, scope, VHDLOp.BLOCKING_ASSIGN, lhs, rhs);
    }

    private VHDLExpr buildExpr(VHDLProcess p, VHDLScopeIface scope, JCTree.JCAssignOp that, VHDLExpr.TERM t) {
        VHDLIdent lhs = scope.getIdent(that.lhs.toString(), VHDLExpr.TERM.LHS);
        if (lhs == null) {
            System.err.printf("undefined variable: %s\n", that.lhs.toString());
        }
        VHDLOp op = VHDLOp.getOp(that.operator.name.toString());
        VHDLBinaryExpr expr = new VHDLBinaryExpr(p, scope, op, lhs, this.buildExpr(p, scope, that.rhs, VHDLExpr.TERM.RHS));
        if (lhs.var instanceof VHDLSignal) {
            return new VHDLBinaryExpr(p, scope, VHDLOp.NONBLOCKING_ASSIGN, lhs, expr);
        }
        return new VHDLBinaryExpr(p, scope, VHDLOp.BLOCKING_ASSIGN, lhs, expr);
    }

    private VHDLExpr buildExprCond(VHDLProcess p, VHDLScopeIface scope, JCTree.JCExpression that, VHDLExpr.TERM t) {
        if (that instanceof JCTree.JCLiteral && that.getTree().getKind() == Tree.Kind.BOOLEAN_LITERAL) {
            if (((JCTree.JCLiteral)that).toString().equals("true")) {
                return new VHDLLiteral("true", Tree.Kind.STRING_LITERAL);
            }
            return new VHDLLiteral("false", Tree.Kind.STRING_LITERAL);
        }
        if (that instanceof JCTree.JCIdent) {
            VHDLIdent ident = scope.getIdent(((JCTree.JCIdent)that).sym.name.toString(), VHDLExpr.TERM.RHS);
            return new VHDLBinaryExpr(p, scope, VHDLOp.COMPEQ, ident, new VHDLLiteral(true, Tree.Kind.BOOLEAN_LITERAL));
        }
        return this.buildExpr(p, scope, that, VHDLExpr.TERM.RHS);
    }

    private class UseJavaDefaultType
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UseJavaDefaultType() {
        }
    }
}

