/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.file;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import openjdk.com.sun.tools.javac.code.Lint;
import openjdk.com.sun.tools.javac.file.FSInfo;
import openjdk.com.sun.tools.javac.file.JavacFileManager;
import openjdk.com.sun.tools.javac.main.OptionName;
import openjdk.com.sun.tools.javac.util.Context;
import openjdk.com.sun.tools.javac.util.ListBuffer;
import openjdk.com.sun.tools.javac.util.Log;
import openjdk.com.sun.tools.javac.util.Options;

public class Paths {
    protected static final Context.Key<Paths> pathsKey = new Context.Key();
    private Log log;
    private Options options;
    private Lint lint;
    private FSInfo fsInfo;
    private boolean warn;
    private Map<JavaFileManager.Location, Path> pathsForLocation;
    private boolean inited = false;
    private File defaultBootClassPathRtJar = null;
    private boolean isDefaultBootClassPath;
    private Path sourceSearchPath;
    private Path classSearchPath;
    private Path otherSearchPath;

    public static Paths instance(Context context) {
        Paths instance = context.get(pathsKey);
        if (instance == null) {
            instance = new Paths(context);
        }
        return instance;
    }

    protected Paths(Context context) {
        context.put(pathsKey, this);
        this.pathsForLocation = new HashMap<JavaFileManager.Location, Path>(16);
        this.setContext(context);
    }

    void setContext(Context context) {
        this.log = Log.instance(context);
        this.options = Options.instance(context);
        this.lint = Lint.instance(context);
        this.fsInfo = FSInfo.instance(context);
    }

    Path getPathForLocation(JavaFileManager.Location location) {
        Path path = this.pathsForLocation.get(location);
        if (path == null) {
            this.setPathForLocation(location, null);
        }
        return this.pathsForLocation.get(location);
    }

    void setPathForLocation(JavaFileManager.Location location, Iterable<? extends File> path) {
        Path p;
        if (path == null) {
            p = location == StandardLocation.CLASS_PATH ? this.computeUserClassPath() : (location == StandardLocation.PLATFORM_CLASS_PATH ? this.computeBootClassPath() : (location == StandardLocation.ANNOTATION_PROCESSOR_PATH ? this.computeAnnotationProcessorPath() : (location == StandardLocation.SOURCE_PATH ? this.computeSourcePath() : null)));
        } else {
            if (location == StandardLocation.PLATFORM_CLASS_PATH) {
                this.defaultBootClassPathRtJar = null;
                this.isDefaultBootClassPath = false;
            }
            p = new Path();
            for (File file : path) {
                p.addFile(file, this.warn);
            }
        }
        this.pathsForLocation.put(location, p);
    }

    public boolean isDefaultBootClassPath() {
        this.lazy();
        return this.isDefaultBootClassPath;
    }

    protected void lazy() {
        if (!this.inited) {
            this.warn = this.lint.isEnabled(Lint.LintCategory.PATH);
            this.pathsForLocation.put(StandardLocation.PLATFORM_CLASS_PATH, this.computeBootClassPath());
            this.pathsForLocation.put(StandardLocation.CLASS_PATH, this.computeUserClassPath());
            this.pathsForLocation.put(StandardLocation.SOURCE_PATH, this.computeSourcePath());
            this.inited = true;
        }
    }

    public Collection<File> bootClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.getPathForLocation(StandardLocation.PLATFORM_CLASS_PATH));
    }

    public Collection<File> userClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.getPathForLocation(StandardLocation.CLASS_PATH));
    }

    public Collection<File> sourcePath() {
        this.lazy();
        Path p = this.getPathForLocation(StandardLocation.SOURCE_PATH);
        return p == null || p.size() == 0 ? null : Collections.unmodifiableCollection(p);
    }

    boolean isDefaultBootClassPathRtJar(File file) {
        return file.equals(this.defaultBootClassPathRtJar);
    }

    private static Iterable<File> getPathEntries(String path) {
        return Paths.getPathEntries(path, null);
    }

    private static Iterable<File> getPathEntries(String path, File emptyPathDefault) {
        ListBuffer<File> entries = new ListBuffer<File>();
        int start = 0;
        while (start <= path.length()) {
            int sep = path.indexOf(File.pathSeparatorChar, start);
            if (sep == -1) {
                sep = path.length();
            }
            if (start < sep) {
                entries.add(new File(path.substring(start, sep)));
            } else if (emptyPathDefault != null) {
                entries.add(emptyPathDefault);
            }
            start = sep + 1;
        }
        return entries;
    }

    private Path computeBootClassPath() {
        this.defaultBootClassPathRtJar = null;
        Path path = new Path();
        String bootclasspathOpt = this.options.get(OptionName.BOOTCLASSPATH);
        String endorseddirsOpt = this.options.get(OptionName.ENDORSEDDIRS);
        String extdirsOpt = this.options.get(OptionName.EXTDIRS);
        String xbootclasspathPrependOpt = this.options.get(OptionName.XBOOTCLASSPATH_PREPEND);
        String xbootclasspathAppendOpt = this.options.get(OptionName.XBOOTCLASSPATH_APPEND);
        path.addFiles(xbootclasspathPrependOpt);
        if (endorseddirsOpt != null) {
            path.addDirectories(endorseddirsOpt);
        } else {
            path.addDirectories(System.getProperty("java.endorsed.dirs"), false);
        }
        if (bootclasspathOpt != null) {
            path.addFiles(bootclasspathOpt);
        } else {
            String files = System.getProperty("sun.boot.class.path");
            path.addFiles(files, false);
            File rt_jar = new File("rt.jar");
            for (File file : Paths.getPathEntries(files)) {
                if (!new File(file.getName()).equals(rt_jar)) continue;
                this.defaultBootClassPathRtJar = file;
            }
        }
        path.addFiles(xbootclasspathAppendOpt);
        if (extdirsOpt != null) {
            path.addDirectories(extdirsOpt);
        } else {
            path.addDirectories(System.getProperty("java.ext.dirs"), false);
        }
        this.isDefaultBootClassPath = xbootclasspathPrependOpt == null && bootclasspathOpt == null && xbootclasspathAppendOpt == null;
        return path;
    }

    private Path computeUserClassPath() {
        String cp = this.options.get(OptionName.CLASSPATH);
        if (cp == null) {
            cp = System.getProperty("env.class.path");
        }
        if (cp == null && System.getProperty("application.home") == null) {
            cp = System.getProperty("java.class.path");
        }
        if (cp == null) {
            cp = ".";
        }
        return new Path().expandJarClassPaths(true).emptyPathDefault(new File(".")).addFiles(cp);
    }

    private Path computeSourcePath() {
        String sourcePathArg = this.options.get(OptionName.SOURCEPATH);
        if (sourcePathArg == null) {
            return null;
        }
        return new Path().addFiles(sourcePathArg);
    }

    private Path computeAnnotationProcessorPath() {
        String processorPathArg = this.options.get(OptionName.PROCESSORPATH);
        if (processorPathArg == null) {
            return null;
        }
        return new Path().addFiles(processorPathArg);
    }

    public Collection<File> sourceSearchPath() {
        if (this.sourceSearchPath == null) {
            this.lazy();
            Path sourcePath = this.getPathForLocation(StandardLocation.SOURCE_PATH);
            Path userClassPath = this.getPathForLocation(StandardLocation.CLASS_PATH);
            this.sourceSearchPath = sourcePath != null ? sourcePath : userClassPath;
        }
        return Collections.unmodifiableCollection(this.sourceSearchPath);
    }

    public Collection<File> classSearchPath() {
        if (this.classSearchPath == null) {
            this.lazy();
            Path bootClassPath = this.getPathForLocation(StandardLocation.PLATFORM_CLASS_PATH);
            Path userClassPath = this.getPathForLocation(StandardLocation.CLASS_PATH);
            this.classSearchPath = new Path();
            this.classSearchPath.addAll(bootClassPath);
            this.classSearchPath.addAll(userClassPath);
        }
        return Collections.unmodifiableCollection(this.classSearchPath);
    }

    Collection<File> otherSearchPath() {
        if (this.otherSearchPath == null) {
            this.lazy();
            Path userClassPath = this.getPathForLocation(StandardLocation.CLASS_PATH);
            Path sourcePath = this.getPathForLocation(StandardLocation.SOURCE_PATH);
            if (sourcePath == null) {
                this.otherSearchPath = userClassPath;
            } else {
                this.otherSearchPath = new Path();
                this.otherSearchPath.addAll(userClassPath);
                this.otherSearchPath.addAll(sourcePath);
            }
        }
        return Collections.unmodifiableCollection(this.otherSearchPath);
    }

    private boolean isArchive(File file) {
        String n = file.getName().toLowerCase();
        return this.fsInfo.isFile(file) && (n.endsWith(".jar") || n.endsWith(".zip"));
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            URL url = Paths.fileToURL(new File(st.nextToken()));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    private static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = String.valueOf(name) + "/";
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(file.toString());
        }
    }

    private class Path
    extends LinkedHashSet<File> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private Set<File> canonicalValues = new HashSet<File>();
        private File emptyPathDefault = null;

        public Path expandJarClassPaths(boolean x) {
            this.expandJarClassPaths = x;
            return this;
        }

        public Path emptyPathDefault(File x) {
            this.emptyPathDefault = x;
            return this;
        }

        public Path addDirectories(String dirs, boolean warn) {
            boolean prev = this.expandJarClassPaths;
            this.expandJarClassPaths = true;
            try {
                if (dirs != null) {
                    for (File dir : Paths.getPathEntries(dirs)) {
                        this.addDirectory(dir, warn);
                    }
                }
                Path path = this;
                return path;
            }
            finally {
                this.expandJarClassPaths = prev;
            }
        }

        public Path addDirectories(String dirs) {
            return this.addDirectories(dirs, Paths.this.warn);
        }

        private void addDirectory(File dir, boolean warn) {
            if (!dir.isDirectory()) {
                if (warn) {
                    Paths.this.log.warning(Lint.LintCategory.PATH, "dir.path.element.not.found", dir);
                }
                return;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File direntry = fileArray[n2];
                if (Paths.this.isArchive(direntry)) {
                    this.addFile(direntry, warn);
                }
                ++n2;
            }
        }

        public Path addFiles(String files, boolean warn) {
            if (files != null) {
                for (File file : Paths.getPathEntries(files, this.emptyPathDefault)) {
                    this.addFile(file, warn);
                }
            }
            return this;
        }

        public Path addFiles(String files) {
            return this.addFiles(files, Paths.this.warn);
        }

        public void addFile(File file, boolean warn) {
            if (this.contains(file)) {
                return;
            }
            if (!Paths.this.fsInfo.exists(file)) {
                if (warn) {
                    Paths.this.log.warning(Lint.LintCategory.PATH, "path.element.not.found", file);
                }
                super.add(file);
                return;
            }
            File canonFile = Paths.this.fsInfo.getCanonicalFile(file);
            if (this.canonicalValues.contains(canonFile)) {
                return;
            }
            if (Paths.this.fsInfo.isFile(file) && !Paths.this.isArchive(file)) {
                try {
                    ZipFile z = new ZipFile(file);
                    z.close();
                    if (warn) {
                        Paths.this.log.warning(Lint.LintCategory.PATH, "unexpected.archive.file", file);
                    }
                }
                catch (IOException e) {
                    if (warn) {
                        Paths.this.log.warning(Lint.LintCategory.PATH, "invalid.archive.file", file);
                    }
                    return;
                }
            }
            super.add(file);
            this.canonicalValues.add(canonFile);
            if (this.expandJarClassPaths && Paths.this.fsInfo.isFile(file)) {
                this.addJarClassPath(file, warn);
            }
        }

        private void addJarClassPath(File jarFile, boolean warn) {
            try {
                for (File f : Paths.this.fsInfo.getJarClassPath(jarFile)) {
                    this.addFile(f, warn);
                }
            }
            catch (IOException e) {
                Paths.this.log.error("error.reading.file", jarFile, JavacFileManager.getMessage(e));
            }
        }
    }
}

