/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.main;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.MissingResourceException;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import openjdk.com.sun.tools.javac.code.Source;
import openjdk.com.sun.tools.javac.file.CacheFSInfo;
import openjdk.com.sun.tools.javac.file.JavacFileManager;
import openjdk.com.sun.tools.javac.jvm.Target;
import openjdk.com.sun.tools.javac.main.CommandLine;
import openjdk.com.sun.tools.javac.main.JavaCompiler;
import openjdk.com.sun.tools.javac.main.JavacOption;
import openjdk.com.sun.tools.javac.main.OptionName;
import openjdk.com.sun.tools.javac.main.RecognizedOptions;
import openjdk.com.sun.tools.javac.processing.AnnotationProcessingError;
import openjdk.com.sun.tools.javac.util.ClientCodeException;
import openjdk.com.sun.tools.javac.util.Context;
import openjdk.com.sun.tools.javac.util.FatalError;
import openjdk.com.sun.tools.javac.util.JavacMessages;
import openjdk.com.sun.tools.javac.util.List;
import openjdk.com.sun.tools.javac.util.ListBuffer;
import openjdk.com.sun.tools.javac.util.Log;
import openjdk.com.sun.tools.javac.util.Options;
import openjdk.com.sun.tools.javac.util.PropagatedException;

public class Main {
    String ownName;
    PrintWriter out;
    boolean apiMode;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private JavacOption.Option[] recognizedOptions = RecognizedOptions.getJavaCompilerOptions(new RecognizedOptions.OptionHelper(){

        @Override
        public void setOut(PrintWriter out) {
            Main.this.out = out;
        }

        @Override
        public void error(String key, Object ... args) {
            Main.this.error(key, args);
        }

        @Override
        public void printVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("version", Main.this.ownName, JavaCompiler.version()));
        }

        @Override
        public void printFullVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("fullVersion", Main.this.ownName, JavaCompiler.fullVersion()));
        }

        @Override
        public void printHelp() {
            Main.this.help();
        }

        @Override
        public void printXhelp() {
            Main.this.xhelp();
        }

        @Override
        public void addFile(File f) {
            Main.this.filenames.add(f);
        }

        @Override
        public void addClassName(String s) {
            Main.this.classnames.append(s);
        }
    });
    private Options options = null;
    public Set<File> filenames = null;
    public ListBuffer<String> classnames = null;
    private JavaFileManager fileManager;
    private static final String javacBundleName = "openjdk.com.sun.tools.javac.resources.javac";
    private static JavacMessages messages;

    public Main(String name) {
        this(name, new PrintWriter(System.err, true));
    }

    public Main(String name, PrintWriter out) {
        this.ownName = name;
        this.out = out;
    }

    void help() {
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.header", this.ownName));
        int i = 0;
        while (i < this.recognizedOptions.length) {
            this.recognizedOptions[i].help(this.out);
            ++i;
        }
        this.out.println();
    }

    void xhelp() {
        int i = 0;
        while (i < this.recognizedOptions.length) {
            this.recognizedOptions[i].xhelp(this.out);
            ++i;
        }
        this.out.println();
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.nonstandard.footer", new Object[0]));
    }

    void error(String key, Object ... args) {
        if (this.apiMode) {
            String msg = Main.getLocalizedString(key, args);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.warning(key, args);
        Log.printLines(this.out, Main.getLocalizedString("msg.usage", this.ownName));
    }

    void warning(String key, Object ... args) {
        Log.printLines(this.out, String.valueOf(this.ownName) + ": " + Main.getLocalizedString(key, args));
    }

    public JavacOption.Option getOption(String flag) {
        JavacOption.Option[] optionArray = this.recognizedOptions;
        int n = this.recognizedOptions.length;
        int n2 = 0;
        while (n2 < n) {
            JavacOption.Option option = optionArray[n2];
            if (option.matches(flag)) {
                return option;
            }
            ++n2;
        }
        return null;
    }

    public void setOptions(Options options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.options = options;
    }

    public void setAPIMode(boolean apiMode) {
        this.apiMode = apiMode;
    }

    public Collection<File> processArgs(String[] flags) {
        return this.processArgs(flags, null);
    }

    public Collection<File> processArgs(String[] flags, String[] classNames) {
        String showClass;
        Target target;
        int ac = 0;
        while (ac < flags.length) {
            String flag = flags[ac];
            ++ac;
            JavacOption.Option option = null;
            if (flag.length() > 0) {
                int firstOptionToCheck;
                int j = firstOptionToCheck = flag.charAt(0) == '-' ? 0 : this.recognizedOptions.length - 1;
                while (j < this.recognizedOptions.length) {
                    if (this.recognizedOptions[j].matches(flag)) {
                        option = this.recognizedOptions[j];
                        break;
                    }
                    ++j;
                }
            }
            if (option == null) {
                this.error("err.invalid.flag", flag);
                return null;
            }
            if (option.hasArg()) {
                if (ac == flags.length) {
                    this.error("err.req.arg", flag);
                    return null;
                }
                String operand = flags[ac];
                ++ac;
                if (!option.process(this.options, flag, operand)) continue;
                return null;
            }
            if (!option.process(this.options, flag)) continue;
            return null;
        }
        if (this.classnames != null && classNames != null) {
            this.classnames.addAll((Collection<String>)Arrays.asList(classNames));
        }
        if (!this.checkDirectory(OptionName.D)) {
            return null;
        }
        if (!this.checkDirectory(OptionName.S)) {
            return null;
        }
        String sourceString = this.options.get(OptionName.SOURCE);
        Source source = sourceString != null ? Source.lookup(sourceString) : Source.DEFAULT;
        String targetString = this.options.get(OptionName.TARGET);
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0))) {
            if (target.compareTo(source.requiredTarget()) < 0) {
                if (targetString != null) {
                    if (sourceString == null) {
                        this.warning("warn.target.default.source.conflict", targetString, source.requiredTarget().name);
                    } else {
                        this.warning("warn.source.target.conflict", sourceString, source.requiredTarget().name);
                    }
                    return null;
                }
                target = source.requiredTarget();
                this.options.put("-target", target.name);
            } else if (targetString == null && !source.allowGenerics()) {
                target = Target.JDK1_4;
                this.options.put("-target", target.name);
            }
        }
        if ((showClass = this.options.get("showClass")) != null) {
            if (showClass.equals("showClass")) {
                showClass = "openjdk.com.sun.tools.javac.Main";
            }
            this.showClass(showClass);
        }
        return this.filenames;
    }

    private boolean checkDirectory(OptionName optName) {
        String value = this.options.get(optName);
        if (value == null) {
            return true;
        }
        File file = new File(value);
        if (!file.exists()) {
            this.error("err.dir.not.found", value);
            return false;
        }
        if (!file.isDirectory()) {
            this.error("err.file.not.directory", value);
            return false;
        }
        return true;
    }

    public int compile(String[] args) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        int result = this.compile(args, context);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    public int compile(String[] args, Context context) {
        return this.compile(args, context, List.<JavaFileObject>nil(), null);
    }

    public int compile(String[] args, Context context, List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        return this.compile(args, null, context, fileObjects, processors);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compile(String[] args, String[] classNames, Context context, List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        if (this.options == null) {
            this.options = Options.instance(context);
        }
        this.filenames = new LinkedHashSet<File>();
        this.classnames = new ListBuffer();
        JavaCompiler comp = null;
        try {
            boolean batchMode;
            if (args.length == 0 && (classNames == null || classNames.length == 0) && fileObjects.isEmpty()) {
                this.help();
                return 2;
            }
            Collection<File> files = this.processArgs(CommandLine.parse(args), classNames);
            if (files == null) {
                return 2;
            }
            if (files.isEmpty() && fileObjects.isEmpty() && this.classnames.isEmpty()) {
                if (this.options.isSet(OptionName.HELP) || this.options.isSet(OptionName.X) || this.options.isSet(OptionName.VERSION) || this.options.isSet(OptionName.FULLVERSION)) {
                    return 0;
                }
                if (JavaCompiler.explicitAnnotationProcessingRequested(this.options)) {
                    this.error("err.no.source.files.classes", new Object[0]);
                    return 2;
                } else {
                    this.error("err.no.source.files", new Object[0]);
                }
                return 2;
            }
            boolean forceStdOut = this.options.isSet("stdout");
            if (forceStdOut) {
                this.out.flush();
                this.out = new PrintWriter(System.out, true);
            }
            context.put(Log.outKey, this.out);
            boolean bl = batchMode = this.options.isUnset("nonBatchMode") && System.getProperty("nonBatchMode") == null;
            if (batchMode) {
                CacheFSInfo.preRegister(context);
            }
            this.fileManager = context.get(JavaFileManager.class);
            comp = JavaCompiler.instance(context);
            if (comp == null) {
                return 3;
            }
            Log log = Log.instance(context);
            if (!files.isEmpty()) {
                void var11_37;
                comp = JavaCompiler.instance(context);
                List list = List.nil();
                JavacFileManager dfm = (JavacFileManager)this.fileManager;
                for (JavaFileObject javaFileObject : dfm.getJavaFileObjectsFromFiles(files)) {
                    List<JavaFileObject> list2 = var11_37.prepend(javaFileObject);
                }
                for (JavaFileObject javaFileObject : var11_37) {
                    fileObjects = fileObjects.prepend(javaFileObject);
                }
            }
            comp.compile(fileObjects, this.classnames.toList(), processors);
            if (log.expectDiagKeys != null) {
                if (log.expectDiagKeys.isEmpty()) {
                    Log.printLines(log.noticeWriter, "all expected diagnostics found");
                    return 0;
                }
                Log.printLines(log.noticeWriter, "expected diagnostic keys not found: " + log.expectDiagKeys);
                return 1;
            }
            try {
                if (comp.errorCount() == 0) return 0;
                return 1;
            }
            catch (IOException ex) {
                this.ioMessage(ex);
                return 3;
            }
            catch (OutOfMemoryError ex) {
                this.resourceMessage(ex);
                return 3;
            }
            catch (StackOverflowError ex) {
                this.resourceMessage(ex);
                return 3;
            }
            catch (FatalError ex) {
                this.feMessage(ex);
                return 3;
            }
            catch (AnnotationProcessingError ex) {
                if (this.apiMode) {
                    throw new RuntimeException(ex.getCause());
                }
                this.apMessage(ex);
                return 3;
            }
            catch (ClientCodeException ex) {
                throw new RuntimeException(ex.getCause());
            }
            catch (PropagatedException ex) {
                throw ex.getCause();
            }
            catch (Throwable ex) {
                if (comp != null && comp.errorCount() != 0 && this.options != null && !this.options.isSet("dev")) return 4;
                this.bugMessage(ex);
                return 4;
            }
        }
        finally {
            if (comp != null) {
                try {
                    comp.close();
                }
                catch (ClientCodeException ex) {
                    throw new RuntimeException(ex.getCause());
                }
            }
            this.filenames = null;
            this.options = null;
        }
    }

    void bugMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.bug", JavaCompiler.version()));
        ex.printStackTrace(this.out);
    }

    void feMessage(Throwable ex) {
        Log.printLines(this.out, ex.getMessage());
        if (ex.getCause() != null && this.options.isSet("dev")) {
            ex.getCause().printStackTrace(this.out);
        }
    }

    void ioMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.io", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void resourceMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.resource", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void apMessage(AnnotationProcessingError ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.proc.annotation.uncaught.exception", new Object[0]));
        ex.getCause().printStackTrace(this.out);
    }

    void showClass(String className) {
        this.out.println("javac: show class: " + className);
        URL url = this.getClass().getResource(String.valueOf('/') + className.replace('.', '/') + ".class");
        if (url == null) {
            this.out.println("  class not found");
        } else {
            this.out.println("  " + url);
            try {
                byte[] digest;
                String algorithm = "MD5";
                MessageDigest md = MessageDigest.getInstance("MD5");
                DigestInputStream in = new DigestInputStream(url.openStream(), md);
                try {
                    int n;
                    byte[] buf = new byte[8192];
                    while ((n = in.read(buf)) > 0) {
                    }
                    digest = md.digest();
                }
                finally {
                    in.close();
                }
                StringBuilder sb = new StringBuilder();
                byte[] byArray = digest;
                int n = digest.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    sb.append(String.format("%02x", b));
                    ++n2;
                }
                this.out.println("  MD5 checksum: " + sb);
            }
            catch (Exception e) {
                this.out.println("  cannot compute digest: " + e);
            }
        }
    }

    public static String getLocalizedString(String key, Object ... args) {
        try {
            if (messages == null) {
                messages = new JavacMessages(javacBundleName);
            }
            return messages.getLocalizedString("javac." + key, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal Error: Resource for javac is missing", e);
        }
    }

    public static void useRawMessages(boolean enable) {
        messages = enable ? new JavacMessages(javacBundleName){

            @Override
            public String getLocalizedString(String key, Object ... args) {
                return key;
            }
        } : new JavacMessages(javacBundleName);
    }
}

