/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import net.wasamon.javarock.libraries.SimpleDualPortRamIface;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.VHDLConstant;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLNewArray;
import net.wasamon.javarock.model.vhdl.VHDLNewComponentInstance;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.type.StdLogic;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import net.wasamon.javarock.tools.types.CompiledComponentType;

public class VHDLFixedArray
extends VHDLSignal
implements VHDLItem {
    final VHDLArrayType atype;
    final VHDLModule module;
    CompiledComponentType component;
    final String prefix;

    public VHDLFixedArray(VHDLModule module, String name, VHDLArrayType type) {
        this(module, name, type, null);
    }

    private int convArrayLength(VHDLModule m, String length) {
        int value = 0;
        try {
            value = Integer.parseInt(length);
        }
        catch (NumberFormatException e) {
            VHDLConstant tmp = this.module.constants.get(length);
            if (tmp == null) {
                new RuntimeException(String.valueOf(length) + " is not defined.");
            }
            value = Integer.parseInt(tmp.value);
        }
        return value;
    }

    public VHDLFixedArray(VHDLModule module, String name, VHDLArrayType type, VHDLExpr reset) {
        super(module, name, type, reset);
        this.atype = type;
        this.module = module;
        this.prefix = name;
        if (reset != null) {
            this.atype.setLength(this.convArrayLength(module, ((VHDLNewArray)reset).length));
            if (!(this.atype.getType() instanceof StdLogicVector) && !(this.atype.getType() instanceof StdLogic)) {
                System.err.println("unsupported type: " + this.atype.getType().getClass());
                return;
            }
            module.addConstantant(new VHDLConstant(module, String.valueOf(this.prefix) + "_length", (JavaRockType)VHDLTypeBuilder.getInteger(), String.valueOf(this.atype.getLength())));
        }
    }

    @Override
    public void generate(PrintWriter out, int offset) {
    }

    public void initialize(VHDLNewArray expr) {
        SimpleDualPortRamIface memory = new SimpleDualPortRamIface(new String[]{String.valueOf(this.atype.getDepth()), ((StdLogicVector)this.atype.getType()).getWidth()});
        CompiledComponentType type = new CompiledComponentType(memory);
        this.module.addComponent(type);
        VHDLNewComponentInstance instance = this.module.newComponentInstance(this.name, type, false, false);
        instance.setArgs(new String[]{String.valueOf(this.atype.getDepth()), String.valueOf(this.atype.getWidth())});
    }

    @Override
    public void connect() {
        if (this.reset != null) {
            this.reset.connect();
            if (this.reset instanceof VHDLNewArray) {
                this.initialize((VHDLNewArray)this.reset);
            }
        }
    }
}

