/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.util.ArrayList;
import java.util.Hashtable;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.StateSignal;
import net.wasamon.javarock.model.vhdl.VHDLBlock;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLExprStatement;
import net.wasamon.javarock.model.vhdl.VHDLFor;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLIf;
import net.wasamon.javarock.model.vhdl.VHDLNonBlockAssignStmt;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.VHDLVariable;
import net.wasamon.javarock.model.vhdl.VHDLWhile;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import net.wasamon.javarock.opt.DataDependencyGraph;

public abstract class VHDLScope
extends VHDLStatement
implements VHDLScopeIface {
    final VHDLScopeIface parent;
    final VHDLProcess process;
    final String id;
    final StateSignal STATE_SIG;
    private final Hashtable<String, VHDLVariable> variables = new Hashtable();
    private final Hashtable<String, VHDLSignal> signals = new Hashtable();
    protected ArrayList<VHDLStatement> statements = new ArrayList();

    public VHDLScope(VHDLProcess process, VHDLScopeIface parent) {
        this.process = process;
        this.parent = parent;
        this.id = process.getScopeID();
        VHDLSignal sig = this.addSignal(VHDLTypeBuilder.getStdLogicVector(31, 0), String.format("state_counter_%s", process.base));
        this.STATE_SIG = new StateSignal(sig.name);
    }

    @Override
    public VHDLIdent getIdent(String name, VHDLExpr.TERM t) {
        if (this.variables.containsKey(name)) {
            return new VHDLIdent(this.variables.get(name), t);
        }
        if (this.signals.containsKey(name)) {
            return new VHDLIdent(this.signals.get(name), t);
        }
        return this.parent.getIdent(name, t);
    }

    @Override
    public boolean hasIdent(String name) {
        if (this.variables.containsKey(name)) {
            return true;
        }
        if (this.signals.containsKey(name)) {
            return true;
        }
        return this.parent.hasIdent(name);
    }

    @Override
    public StateSignal get_state_sig() {
        if (!(this.parent instanceof VHDLProcess)) {
            return this.STATE_SIG;
        }
        return this.parent.get_state_sig();
    }

    @Override
    public void addVariable(JavaRockType type, String name) {
        VHDLVariable var = new VHDLVariable(this.process.module, String.valueOf(name) + "_" + this.id, type);
        this.variables.put(name, var);
        this.process.variables.add(var);
    }

    @Override
    public VHDLSignal addSignal(JavaRockType type, String name) {
        VHDLSignal var = new VHDLSignal(this.process.module, String.valueOf(name) + "_" + this.id, type);
        this.signals.put(name, var);
        this.process.module.unique_access_signals.put(var.name, var);
        this.process.addResetStmt(var);
        return var;
    }

    @Override
    public void add(VHDLStatement stmt) {
        this.statements.add(stmt);
    }

    @Override
    public VHDLScopeIface getParent() {
        return this.parent;
    }

    private void doOptimize(DataDependencyGraph ddg) {
        ArrayList<DataDependencyGraph.Item> readies;
        while ((readies = ddg.getReadyItems()).size() != 0) {
            VHDLStatement stmt = null;
            for (DataDependencyGraph.Item item : readies) {
                if (stmt == null) {
                    stmt = item.getStatement();
                    continue;
                }
                VHDLStatement s0 = item.getStatement();
                stmt.addSibling(s0);
                this.statements.remove(s0);
                stmt = s0;
            }
            ddg.updateReadyItems();
            ArrayList<DataDependencyGraph.Item> arrayList = ddg.getReadyItems();
        }
    }

    public void optimize() {
        ArrayList<DataDependencyGraph> ddgs = new ArrayList<DataDependencyGraph>();
        DataDependencyGraph ddg = null;
        int cnt = 0;
        for (VHDLStatement stmt : this.statements) {
            if (ddg == null) {
                ddg = new DataDependencyGraph(String.valueOf(this.process.module.getName()) + "-" + this.id + "-" + cnt);
                ddgs.add(ddg);
            }
            if (stmt instanceof VHDLExprStatement) {
                ddg.addNewItemSequentially(stmt);
                continue;
            }
            if (stmt instanceof VHDLNonBlockAssignStmt) {
                ddg.addNewItemSequentially(stmt);
                continue;
            }
            ddg = null;
            if (stmt instanceof VHDLIf) {
                ((VHDLIf)stmt).optimize();
                continue;
            }
            if (stmt instanceof VHDLWhile) {
                ((VHDLWhile)stmt).optimize();
                continue;
            }
            if (stmt instanceof VHDLFor) {
                ((VHDLFor)stmt).optimize();
                continue;
            }
            if (!(stmt instanceof VHDLBlock)) continue;
            ((VHDLBlock)stmt).optimize();
        }
        for (DataDependencyGraph g : ddgs) {
            this.doOptimize(g);
        }
    }
}

