/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.StateSignal;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScope;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.VHDLStatement;

public class VHDLSwitch
extends VHDLScope
implements VHDLItem {
    private VHDLExpr cond;
    private String cond_expr;
    private ArrayList<SwitchElement> elements = new ArrayList();

    public VHDLSwitch(VHDLProcess process, VHDLScopeIface parent) {
        super(process, parent);
    }

    public void setCond(VHDLExpr cond) {
        this.cond = cond;
        this.cond_expr = String.valueOf(this.process.base) + "_cond_expr_" + this.process.getScopeID();
        this.parent.addSignal(cond.getType(), this.cond_expr);
    }

    public SwitchElement getNewElement(VHDLExpr expr) {
        SwitchElement elem = new SwitchElement(this.process, this, expr);
        this.elements.add(elem);
        return elem;
    }

    public SwitchElement getNewElement() {
        SwitchElement elem = new SwitchElement(this.process, this, null);
        this.elements.add(elem);
        return elem;
    }

    @Override
    public void connect() {
        this.cond.connect();
        for (SwitchElement elem : this.elements) {
            if (elem.pattern != null) {
                elem.pattern.connect();
            }
            elem.connect();
        }
    }

    @Override
    public void link() {
        this.setElementOffset();
        this.cond.link();
        for (SwitchElement elem : this.elements) {
            if (elem.pattern != null) {
                elem.pattern.link();
            }
            elem.link();
        }
    }

    @Override
    public int state_count() {
        return 1;
    }

    @Override
    public boolean isStepNext() {
        return true;
    }

    @Override
    public boolean isEndOfState() {
        return true;
    }

    @Override
    public boolean isSkip() {
        return false;
    }

    private void setElementOffset() {
        int offset = 1;
        for (SwitchElement elem : this.elements) {
            elem.offset = offset;
            offset += elem.stmts.size();
        }
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        this.writeln(out, String.format("case conv_integer(%s) is", this.STATE_SIG.value()), offset);
        this.writeln(out, "when 0 =>", offset + 2);
        String sep = "";
        for (SwitchElement elem : this.elements) {
            if (elem.pattern != null) {
                this.writeln(out, String.format("%sif (%s = %s) then", sep, this.cond, elem.pattern), offset + 4);
                this.writeln(out, String.format("  %s <= conv_std_logic_vector(%d, %s'length);", this.STATE_SIG.value(), elem.offset, this.STATE_SIG.value()), offset + 4);
            } else {
                this.writeln(out, String.format("else", new Object[0]), offset + 4);
                this.writeln(out, String.format("  %s <= conv_std_logic_vector(%d, %s'length);", this.STATE_SIG.value(), elem.offset, this.STATE_SIG.value()), offset + 4);
            }
            sep = "els";
        }
        this.writeln(out, String.format("end if;", new Object[0]), offset + 4);
        int cnt = 1;
        boolean state_label = true;
        for (SwitchElement elem : this.elements) {
            cnt = elem.offset;
            for (VHDLStatement stmt : elem.stmts) {
                if (state_label) {
                    this.writeln(out, String.format("when %d =>", cnt), offset + 2);
                }
                stmt.generate(out, offset + 4);
                if (!stmt.isStepNext()) {
                    this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 4);
                }
                if (!(state_label = stmt.isEndOfState())) continue;
                ++cnt;
            }
        }
        this.writeln(out, "when others =>", offset + 2);
        this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIG.value()), offset + 4);
        this.writeln(out, String.format("%s <= %s + 1;", this.parent.get_state_sig().value(), this.parent.get_state_sig().value()), offset + 4);
        this.writeln(out, "end case;", offset);
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        ArrayList<VHDLIdent> l = this.cond.getDestIdent();
        if (l != null) {
            list.addAll(l);
        }
        for (SwitchElement elem : this.elements) {
            ArrayList<VHDLIdent> l2 = elem.getDestIdent();
            if (l2 == null) continue;
            list.addAll(l2);
        }
        return list;
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        ArrayList<VHDLIdent> l = this.cond.getSrcIdent();
        if (l != null) {
            list.addAll(l);
        }
        for (SwitchElement elem : this.elements) {
            ArrayList<VHDLIdent> l2 = elem.getSrcIdent();
            if (l2 == null) continue;
            list.addAll(l2);
        }
        return list;
    }

    @Override
    public void optimize() {
        for (SwitchElement elem : this.elements) {
            elem.optimize();
        }
    }

    public class SwitchElement
    implements VHDLScopeIface {
        public final VHDLExpr pattern;
        public final VHDLProcess process;
        public final VHDLScopeIface scope;
        public final ArrayList<VHDLStatement> stmts;
        public int offset;

        public SwitchElement(VHDLProcess process, VHDLScopeIface scope, VHDLExpr pat) {
            this.process = process;
            this.scope = scope;
            this.pattern = pat;
            this.stmts = new ArrayList();
        }

        public ArrayList<VHDLIdent> getDestIdent() {
            ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
            for (VHDLStatement stmt : VHDLSwitch.this.statements) {
                ArrayList<VHDLIdent> l = stmt.getDestIdent();
                if (l == null) continue;
                list.addAll(l);
            }
            return list;
        }

        public ArrayList<VHDLIdent> getSrcIdent() {
            ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
            for (VHDLStatement stmt : VHDLSwitch.this.statements) {
                ArrayList<VHDLIdent> l = stmt.getSrcIdent();
                if (l == null) continue;
                list.addAll(l);
            }
            return list;
        }

        public void link() {
            int cnt = this.offset;
            for (VHDLStatement stmt : this.stmts) {
                stmt.link();
                stmt.setStateLabel(cnt);
                if (!stmt.isEndOfState()) continue;
                ++cnt;
            }
        }

        public void connect() {
            for (VHDLStatement stmt : this.stmts) {
                stmt.connect();
            }
        }

        public void optimize() {
        }

        @Override
        public VHDLIdent getIdent(String name, VHDLExpr.TERM t) {
            return this.scope.getIdent(name, t);
        }

        @Override
        public boolean hasIdent(String name) {
            return this.scope.hasIdent(name);
        }

        @Override
        public StateSignal get_state_sig() {
            return this.scope.get_state_sig();
        }

        @Override
        public VHDLSignal addSignal(JavaRockType t, String name) {
            return this.scope.addSignal(t, name);
        }

        @Override
        public void addVariable(JavaRockType t, String name) {
            this.scope.addVariable(t, name);
        }

        @Override
        public void add(VHDLStatement stmt) {
            this.stmts.add(stmt);
        }

        @Override
        public VHDLScopeIface getParent() {
            return this.scope.getParent();
        }
    }
}

