/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.classfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import openjdk.com.sun.tools.classfile.Attribute;
import openjdk.com.sun.tools.classfile.ClassFile;
import openjdk.com.sun.tools.classfile.ConstantPool;

public class ClassReader {
    private DataInputStream in;
    private ClassFile classFile;
    private Attribute.Factory attributeFactory;

    ClassReader(ClassFile classFile, InputStream in, Attribute.Factory attributeFactory) throws IOException {
        classFile.getClass();
        attributeFactory.getClass();
        this.classFile = classFile;
        this.in = new DataInputStream(new BufferedInputStream(in));
        this.attributeFactory = attributeFactory;
    }

    ClassFile getClassFile() {
        return this.classFile;
    }

    ConstantPool getConstantPool() {
        return this.classFile.constant_pool;
    }

    public Attribute readAttribute() throws IOException {
        int name_index = this.readUnsignedShort();
        int length = this.readInt();
        byte[] data = new byte[length];
        this.readFully(data);
        DataInputStream prev = this.in;
        this.in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            Attribute attribute = this.attributeFactory.createAttribute(this, name_index, data);
            return attribute;
        }
        finally {
            this.in = prev;
        }
    }

    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

